/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network;

import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;
import java.util.EnumMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.util.IThreadListener;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLIndexedMessageToMessageCodec;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.network.PacketBase;

@ChannelHandler.Sharable
public final class PacketHandler {
    private Codec CODEC;
    private final EnumMap<Side, FMLEmbeddedChannel> CHANNELS = Maps.newEnumMap(Side.class);
    private final ModBase mod;

    public PacketHandler(ModBase mod) {
        this.mod = mod;
    }

    public void init() {
        if (!this.CHANNELS.isEmpty()) {
            return;
        }
        this.CODEC = new Codec();
        this.CHANNELS.putAll(NetworkRegistry.INSTANCE.newChannel(this.mod.getModId(), new ChannelHandler[]{this.CODEC, new HandlerServer()}));
        if (FMLCommonHandler.instance().getSide().isClient()) {
            FMLEmbeddedChannel channel = this.CHANNELS.get(Side.CLIENT);
            String codecName = channel.findChannelHandlerNameForType(Codec.class);
            channel.pipeline().addAfter(codecName, "ClientHandler", (ChannelHandler)new HandlerClient());
        }
    }

    public void register(Class<? extends PacketBase> packetType) {
        this.CODEC.addDiscriminator(Helpers.getNewId(this.mod, Helpers.IDType.PACKET), packetType);
    }

    public FMLEmbeddedChannel getClientChannel() {
        return this.CHANNELS.get(Side.CLIENT);
    }

    public FMLEmbeddedChannel getServerChannel() {
        return this.CHANNELS.get(Side.SERVER);
    }

    public void sendToServer(PacketBase packet) {
        this.getClientChannel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.getClientChannel().writeAndFlush((Object)packet);
    }

    public void sendToPlayer(PacketBase packet, EntityPlayer player) {
        this.getServerChannel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.getServerChannel().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.getServerChannel().writeAndFlush((Object)packet);
    }

    public void sendToAllAround(PacketBase packet, NetworkRegistry.TargetPoint point) {
        this.getServerChannel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.getServerChannel().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.getServerChannel().writeAndFlush((Object)packet);
    }

    public void sendToDimension(PacketBase packet, int dimension) {
        this.getServerChannel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.getServerChannel().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimension);
        this.getServerChannel().writeAndFlush((Object)packet);
    }

    public void sendToAll(PacketBase packet) {
        this.getServerChannel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.getServerChannel().writeAndFlush((Object)packet);
    }

    public Packet toMcPacket(PacketBase packet) {
        return this.CHANNELS.get(FMLCommonHandler.instance().getEffectiveSide()).generatePacketFrom((Object)packet);
    }

    @ChannelHandler.Sharable
    private static final class HandlerServer
    extends SimpleChannelInboundHandler<PacketBase> {
        private HandlerServer() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, PacketBase packet) throws Exception {
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                return;
            }
            EntityPlayerMP player = ((NetHandlerPlayServer)ctx.channel().attr((AttributeKey)NetworkRegistry.NET_HANDLER).get()).field_147369_b;
            packet.actionServer(player.field_70170_p, player);
        }
    }

    @ChannelHandler.Sharable
    @SideOnly(value=Side.CLIENT)
    private static final class HandlerClient
    extends SimpleChannelInboundHandler<PacketBase> {
        private HandlerClient() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, final PacketBase packet) throws Exception {
            final Minecraft mc = Minecraft.func_71410_x();
            IThreadListener thread = FMLCommonHandler.instance().getWorldThread((INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get());
            if (packet.isAsync() || thread.func_152345_ab()) {
                packet.actionClient((World)mc.field_71441_e, (EntityPlayer)mc.field_71439_g);
            } else {
                thread.func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        packet.actionClient((World)mc.field_71441_e, (EntityPlayer)mc.field_71439_g);
                    }
                });
            }
        }
    }

    private static final class Codec
    extends FMLIndexedMessageToMessageCodec<PacketBase> {
        private Codec() {
        }

        public void encodeInto(ChannelHandlerContext ctx, PacketBase packet, ByteBuf target) throws Exception {
            ByteArrayDataOutput output = ByteStreams.newDataOutput();
            packet.encode(output);
            target.writeBytes(output.toByteArray());
        }

        public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, PacketBase packet) {
            ByteArrayDataInput input = ByteStreams.newDataInput((byte[])source.array());
            input.skipBytes(1);
            packet.decode(input);
        }
    }
}

