/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.persist.world;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.NBTProviderComponent;

public abstract class WorldStorage
implements INBTProvider {
    protected final ModBase mod;
    private INBTProvider nbtProviderComponent = new NBTProviderComponent(this);

    public WorldStorage(ModBase mod) {
        this.mod = mod;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.readGeneratedFieldsFromNBT(tag);
    }

    public void writeToNBT(NBTTagCompound tag) {
        this.writeGeneratedFieldsToNBT(tag);
    }

    public abstract void reset();

    public void onStartedEvent(FMLServerStartedEvent event) {
        this.loadData();
        this.afterLoad();
    }

    public void onStoppingEvent(FMLServerStoppingEvent event) {
        this.beforeSave();
        this.saveData();
    }

    protected abstract String getDataId();

    private NBTDataHolder getDataHolder() {
        String dataId = this.mod.getModId() + "_" + this.getDataId();
        NBTDataHolder data = (NBTDataHolder)MinecraftServer.func_71276_C().field_71305_c[0].func_72943_a(NBTDataHolder.class, dataId);
        if (data == null) {
            data = new NBTDataHolder(dataId);
            MinecraftServer.func_71276_C().field_71305_c[0].func_72823_a(dataId, (WorldSavedData)data);
        }
        return data;
    }

    private synchronized void loadData() {
        this.reset();
        this.readFromNBT(this.getDataHolder().tag);
    }

    private synchronized void saveData() {
        NBTDataHolder data = this.getDataHolder();
        this.writeToNBT(data.tag);
        data.func_76186_a(true);
    }

    public void afterLoad() {
    }

    public void beforeSave() {
    }

    @Override
    public void writeGeneratedFieldsToNBT(NBTTagCompound tag) {
        this.nbtProviderComponent.writeGeneratedFieldsToNBT(tag);
    }

    @Override
    public void readGeneratedFieldsFromNBT(NBTTagCompound tag) {
        this.nbtProviderComponent.readGeneratedFieldsFromNBT(tag);
    }

    public static class NBTDataHolder
    extends WorldSavedData {
        private static String KEY = "WorldStorageData";
        public NBTTagCompound tag = new NBTTagCompound();

        public NBTDataHolder(String key) {
            super(key);
        }

        public void func_76184_a(NBTTagCompound tag) {
            this.tag = tag.func_74775_l(KEY);
        }

        public void func_76187_b(NBTTagCompound tag) {
            tag.func_74782_a(KEY, (NBTBase)this.tag);
        }
    }
}

