/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe.xml;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigHandler;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.init.RecipeHandler;
import org.cyclops.cyclopscore.recipe.xml.IRecipeConditionHandler;
import org.cyclops.cyclopscore.recipe.xml.IRecipeTypeHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlRecipeLoader {
    private final RecipeHandler recipeHandler;
    private final ModBase mod;
    private final StreamSource stream;
    private final String fileName;
    private InputStream xsdIs = null;
    private Document doc = null;

    public XmlRecipeLoader(ModBase mod, InputStream is, String fileName, RecipeHandler recipeHandler) {
        this.mod = mod;
        this.stream = new StreamSource(is);
        this.fileName = fileName;
        this.recipeHandler = recipeHandler;
    }

    public void setValidator(InputStream xsdIs) {
        this.xsdIs = xsdIs;
    }

    public void validate() throws XmlRecipeException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            if (this.xsdIs != null) {
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                factory.setErrorHandler(new ErrorHandler(){

                    @Override
                    public void warning(SAXParseException exception) throws SAXException {
                        XmlRecipeLoader.this.getMod().log(Level.WARN, "[" + XmlRecipeLoader.this.fileName + "]: " + exception.getMessage());
                    }

                    @Override
                    public void fatalError(SAXParseException exception) throws SAXException {
                        XmlRecipeLoader.this.getMod().log(Level.FATAL, "[" + XmlRecipeLoader.this.fileName + "]: " + exception.getMessage());
                    }

                    @Override
                    public void error(SAXParseException exception) throws SAXException {
                        XmlRecipeLoader.this.getMod().log(Level.ERROR, "[" + XmlRecipeLoader.this.fileName + "]: " + exception.getMessage());
                    }
                });
                Schema schema = factory.newSchema(new StreamSource(this.xsdIs));
                dbFactory.setSchema(schema);
            }
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            InputStream is = this.stream.getInputStream();
            if (is == null) {
                throw new XmlRecipeException("The recipe file " + this.fileName + " was not found for this mod.");
            }
            this.doc = dBuilder.parse(is);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new XmlRecipeException(e);
        }
    }

    public void loadRecipes(boolean crashOnInvalidRecipe) throws XmlRecipeException {
        if (this.doc == null) {
            this.validate();
        }
        NodeList recipes = this.doc.getElementsByTagName("recipe");
        for (int i = 0; i < recipes.getLength(); ++i) {
            Element recipe = (Element)recipes.item(i);
            if (!this.isRecipeEnabled(recipe)) continue;
            try {
                this.handleRecipe(recipe);
                continue;
            }
            catch (XmlRecipeException e) {
                if (crashOnInvalidRecipe) {
                    throw e;
                }
                this.getMod().log(Level.ERROR, e.getMessage());
            }
        }
    }

    private boolean isRecipeEnabled(Element recipe) {
        boolean enable = true;
        NodeList conditions = recipe.getElementsByTagName("condition");
        for (int j = 0; j < conditions.getLength() && enable; ++j) {
            Node condition = conditions.item(j);
            String conditionType = condition.getAttributes().getNamedItem("type").getTextContent();
            IRecipeConditionHandler handler = this.recipeHandler.getRecipeConditionHandlers().get(conditionType);
            if (handler == null) {
                throw new XmlRecipeException(String.format("Could not find a recipe condition handler of type '%s'", conditionType));
            }
            String param = condition.getTextContent();
            enable = handler.isSatisfied(this.recipeHandler, param);
        }
        return enable;
    }

    private void handleRecipe(Element recipe) throws XmlRecipeException {
        String type = recipe.getAttributes().getNamedItem("type").getTextContent();
        IRecipeTypeHandler handler = this.recipeHandler.getRecipeTypeHandlers().get(type);
        if (handler == null) {
            throw new XmlRecipeException(String.format("Could not find a recipe type handler of type '%s'", type));
        }
        ItemStack output = handler.loadRecipe(this.recipeHandler, recipe);
        ExtendedConfig<?> config = ConfigHandler.getConfigFromItem(output.func_77973_b());
        for (String tag : this.getTags(recipe)) {
            this.getMod().getRecipeHandler().getTaggedOutput().put((Object)tag, (Object)output);
            this.getMod().getRecipeHandler().getTaggedConfigurablesOutput().put((Object)tag, config);
        }
    }

    private List<String> getTags(Element recipe) {
        NodeList tagNodes = recipe.getElementsByTagName("tag");
        ArrayList tags = Lists.newArrayListWithCapacity((int)tagNodes.getLength());
        for (int i = 0; i < tagNodes.getLength(); ++i) {
            Element tag = (Element)tagNodes.item(i);
            tags.add(tag.getTextContent());
        }
        return tags;
    }

    public ModBase getMod() {
        return this.mod;
    }

    public static class XmlRecipeException
    extends RuntimeException {
        public XmlRecipeException(String message) {
            super(message);
        }

        public XmlRecipeException(Exception e) {
            super(e.getMessage());
        }
    }
}

