/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.tileentity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockContainer;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.persist.nbt.NBTProviderComponent;

public class CyclopsTileEntity
extends TileEntity
implements INBTProvider {
    private static final int UPDATE_BACKOFF_TICKS = 1;
    @NBTPersist
    private Boolean rotatable = false;
    private EnumFacing rotation = EnumFacing.NORTH;
    private INBTProvider nbtProviderComponent = new NBTProviderComponent(this);
    private boolean shouldSendUpdate = false;
    private int sendUpdateBackoff = (int)Math.round(Math.random() * (double)this.getUpdateBackoffTicks());
    private final boolean ticking = this instanceof ITickingTile;

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    protected boolean isTicking() {
        return this.ticking;
    }

    public final void sendUpdate() {
        if (!this.isTicking()) {
            throw new RuntimeException("If you want to update, you must implement ITickingTile. This is a mod error.");
        }
        this.shouldSendUpdate = true;
    }

    public final void sendImmediateUpdate() {
        this.sendUpdate();
        this.sendUpdateBackoff = 0;
    }

    private void updateTicking() {
        this.updateTileEntity();
        this.trySendActualUpdate();
    }

    protected void updateTileEntity() {
    }

    private void trySendActualUpdate() {
        --this.sendUpdateBackoff;
        if (this.sendUpdateBackoff <= 0) {
            this.sendUpdateBackoff = this.getUpdateBackoffTicks();
            if (this.shouldSendUpdate) {
                this.shouldSendUpdate = false;
                this.beforeSendUpdate();
                this.onSendUpdate();
                this.afterSendUpdate();
            }
        }
    }

    protected void onSendUpdate() {
        this.field_145850_b.func_175689_h(this.func_174877_v());
    }

    protected void beforeSendUpdate() {
    }

    protected void afterSendUpdate() {
    }

    public Packet func_145844_m() {
        return new S35PacketUpdateTileEntity(this.func_174877_v(), 1, this.getNBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        NBTTagCompound tag = packet.func_148857_g();
        this.func_145839_a(tag);
        this.onUpdateReceived();
    }

    public void onUpdateReceived() {
    }

    protected int getUpdateBackoffTicks() {
        return 1;
    }

    public void destroy() {
        this.func_145843_s();
    }

    public boolean canInteractWith(EntityPlayer entityPlayer) {
        return true;
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.writeGeneratedFieldsToNBT(tag);
        tag.func_74768_a("rotation", this.rotation.ordinal());
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readGeneratedFieldsFromNBT(tag);
        EnumFacing foundRotation = EnumFacing.field_82609_l[tag.func_74762_e("rotation")];
        if (foundRotation != null) {
            this.rotation = foundRotation;
        }
        this.onLoad();
    }

    public void onLoad() {
    }

    public NBTTagCompound getNBTTagCompound() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return tag;
    }

    public boolean isRotatable() {
        return this.rotatable;
    }

    public void setRotatable(boolean rotatable) {
        this.rotatable = rotatable;
    }

    public EnumFacing getRotation() {
        return this.rotation;
    }

    public void setRotation(EnumFacing rotation) {
        this.rotation = rotation;
    }

    public ConfigurableBlockContainer getBlock() {
        return (ConfigurableBlockContainer)this.func_145838_q();
    }

    @Override
    public void writeGeneratedFieldsToNBT(NBTTagCompound tag) {
        this.nbtProviderComponent.writeGeneratedFieldsToNBT(tag);
    }

    @Override
    public void readGeneratedFieldsFromNBT(NBTTagCompound tag) {
        this.nbtProviderComponent.readGeneratedFieldsFromNBT(tag);
    }

    public static class TickingTileComponent
    implements ITickingTile {
        private final CyclopsTileEntity tile;

        public TickingTileComponent(CyclopsTileEntity tile) {
            this.tile = tile;
        }

        public void func_73660_a() {
            this.tile.updateTicking();
        }
    }

    public static interface ITickingTile
    extends IUpdatePlayerListBox {
    }
}

