/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.tileentity;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.util.EnumFacing;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.tileentity.InventoryTileEntityBase;

public abstract class InventoryTileEntity
extends InventoryTileEntityBase {
    protected SimpleInventory inventory;
    protected Map<EnumFacing, int[]> slotSides;
    protected Map<EnumFacing, Integer> slotSidesSize;

    public InventoryTileEntity(int inventorySize, String inventoryName, int stackSize) {
        this.inventory = new SimpleInventory(inventorySize, inventoryName, stackSize);
        this.slotSides = Maps.newHashMap();
        this.slotSidesSize = Maps.newHashMap();
        for (EnumFacing side : DirectionHelpers.DIRECTIONS) {
            int[] array = new int[inventorySize];
            for (int i = 0; i < inventorySize; ++i) {
                array[i] = -1;
            }
            this.slotSides.put(side, array);
            this.slotSidesSize.put(side, 0);
        }
    }

    public InventoryTileEntity(int inventorySize, String inventoryName) {
        this(inventorySize, inventoryName, 64);
    }

    protected void addSlotsToSide(EnumFacing side, Collection<Integer> slots) {
        int[] currentSlots = this.slotSides.get(side);
        int offset = this.slotSidesSize.get(side);
        int i = 0;
        Iterator<Integer> i$ = slots.iterator();
        while (i$.hasNext()) {
            int slot;
            currentSlots[offset + i] = slot = i$.next().intValue();
            ++i;
        }
        this.slotSidesSize.put(side, offset + i);
    }

    @Override
    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public int[] func_180463_a(EnumFacing side) {
        return this.slotSides.get(side);
    }
}

