/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.tileentity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import org.cyclops.cyclopscore.inventory.INBTInventory;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;

public abstract class InventoryTileEntityBase
extends CyclopsTileEntity
implements ISidedInventory {
    protected boolean sendUpdateOnInventoryChanged = false;

    public abstract INBTInventory getInventory();

    public int func_70302_i_() {
        return this.getInventory().func_70302_i_();
    }

    public ItemStack func_70301_a(int slotId) {
        if (slotId >= this.func_70302_i_() || slotId < 0) {
            return null;
        }
        return this.getInventory().func_70301_a(slotId);
    }

    public ItemStack func_70298_a(int slotId, int count) {
        ItemStack itemStack = this.getInventory().func_70298_a(slotId, count);
        this.onInventoryChanged();
        return itemStack;
    }

    public ItemStack func_70304_b(int slotId) {
        return this.getInventory().func_70304_b(slotId);
    }

    public void func_70299_a(int slotId, ItemStack itemstack) {
        this.getInventory().func_70299_a(slotId, itemstack);
        this.onInventoryChanged();
    }

    protected void onInventoryChanged() {
        if (this.isSendUpdateOnInventoryChanged()) {
            this.sendUpdate();
        }
    }

    public String func_70005_c_() {
        return this.getInventory().func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.getInventory().func_145818_k_();
    }

    public IChatComponent func_145748_c_() {
        return null;
    }

    public int func_70297_j_() {
        return this.getInventory().func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && entityPlayer.func_174818_b(this.func_174877_v().func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public void func_174889_b(EntityPlayer playerIn) {
        this.getInventory().func_174889_b(playerIn);
    }

    public void func_174886_c(EntityPlayer playerIn) {
        this.getInventory().func_174886_c(playerIn);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.getInventory().func_94041_b(index, stack);
    }

    public int func_174887_a_(int id) {
        return this.getInventory().func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.getInventory().func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.getInventory().func_174890_g();
    }

    public void func_174888_l() {
        this.getInventory().func_174888_l();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        INBTInventory inventory = this.getInventory();
        if (inventory != null) {
            inventory.readFromNBT(tag);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        INBTInventory inventory = this.getInventory();
        if (inventory != null) {
            inventory.writeToNBT(tag);
        }
    }

    protected boolean canAccess(int slot, EnumFacing side) {
        boolean canAccess = false;
        for (int slotAccess : this.func_180463_a(side)) {
            if (slotAccess != slot) continue;
            canAccess = true;
        }
        return canAccess;
    }

    public boolean func_180462_a(int slot, ItemStack itemStack, EnumFacing side) {
        return this.canAccess(slot, side) && this.func_94041_b(slot, itemStack);
    }

    public boolean func_180461_b(int slot, ItemStack itemStack, EnumFacing side) {
        return this.canAccess(slot, side);
    }

    public boolean isSendUpdateOnInventoryChanged() {
        return this.sendUpdateOnInventoryChanged;
    }

    public void setSendUpdateOnInventoryChanged(boolean sendUpdateOnInventoryChanged) {
        this.sendUpdateOnInventoryChanged = sendUpdateOnInventoryChanged;
    }
}

