/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.tileentity;

import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.tileentity.InventoryTileEntity;

public abstract class TankInventoryTileEntity
extends InventoryTileEntity
implements IFluidHandler {
    private SingleUseTank tank;
    protected int tankSize;
    private String tankName;
    private Fluid acceptedFluid = null;
    protected boolean sendUpdateOnTankChanged = false;

    public TankInventoryTileEntity(int inventorySize, String inventoryName, int tankSize, String tankName, int stackSize) {
        super(inventorySize, inventoryName, stackSize);
        this.tankSize = tankSize;
        this.tankName = tankName;
        this.setSendUpdateOnTankChanged(true);
        this.tank = this.newTank(tankName, tankSize);
    }

    public TankInventoryTileEntity(int inventorySize, String inventoryName, int tankSize, String tankName) {
        this(inventorySize, inventoryName, tankSize, tankName, 64);
    }

    protected SingleUseTank newTank(String tankName, int tankSize) {
        return new SingleUseTank(tankName, tankSize, this);
    }

    public TankInventoryTileEntity(int inventorySize, String inventoryName, int stackSize, int tankSize, String tankName) {
        super(inventorySize, inventoryName, stackSize);
        this.tankSize = tankSize;
        this.tankName = tankName;
        this.setSendUpdateOnTankChanged(true);
        this.tank = this.newTank(tankName, tankSize);
    }

    public TankInventoryTileEntity(int inventorySize, String inventoryName, int tankSize, String tankName, Fluid acceptedFluid) {
        this(inventorySize, inventoryName, tankSize, tankName);
        this.tankSize = tankSize;
        this.tankName = tankName;
        this.acceptedFluid = acceptedFluid;
        this.tank.setAcceptedFluid(acceptedFluid);
    }

    public TankInventoryTileEntity(int inventorySize, String inventoryName, int stackSize, int tankSize, String tankName, Fluid acceptedFluid) {
        this(inventorySize, inventoryName, stackSize, tankSize, tankName);
        this.tankSize = tankSize;
        this.tankName = tankName;
        this.acceptedFluid = acceptedFluid;
        this.tank.setAcceptedFluid(acceptedFluid);
    }

    public SingleUseTank getTank() {
        return this.tank;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.tank.readFromNBT(data);
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.tank.writeToNBT(data);
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.fill(EnumFacing.UP, resource, doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.drain(EnumFacing.DOWN, resource, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.drain(EnumFacing.DOWN, maxDrain, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return this.tank.getAcceptedFluid() == null || this.tank.canTankAccept(fluid);
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return this.tank.getAcceptedFluid() == null || this.tank.canTankAccept(fluid);
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        FluidTankInfo[] info = new FluidTankInfo[]{this.tank.getInfo()};
        return info;
    }

    public boolean isSendUpdateOnTankChanged() {
        return this.sendUpdateOnTankChanged;
    }

    public void setSendUpdateOnTankChanged(boolean sendUpdateOnTankChanged) {
        this.sendUpdateOnTankChanged = sendUpdateOnTankChanged;
    }

    @Override
    protected void onSendUpdate() {
        super.onSendUpdate();
        if (this.getBlock().func_149740_M()) {
            this.field_145850_b.func_175685_c(this.func_174877_v(), (Block)this.getBlock());
        }
    }
}

