/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.world.gen;

import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.world.gen.IRetroGen;
import org.cyclops.cyclopscore.world.gen.IRetroGenRegistry;

public class RetroGenRegistry
implements IRetroGenRegistry {
    private static RetroGenRegistry _instance = null;
    private final Set<IRetroGen> retroGeneratables = Sets.newHashSet();
    private final Random random = new Random();
    private final ModBase mod;

    public RetroGenRegistry(ModBase mod) {
        this.mod = mod;
    }

    protected String getNBTTag() {
        return this.getMod().getModId() + "-RetroGen";
    }

    @Override
    public void registerRetroGen(IRetroGen retroGen) {
        this.retroGeneratables.add(retroGen);
    }

    @Override
    @SubscribeEvent
    public void retroGenLoad(ChunkDataEvent.Load event) {
        if (this.getMod().getReferenceValue(ModBase.REFKEY_RETROGEN).booleanValue() && event.getData() != null) {
            NBTTagCompound tag = event.getData().func_74775_l(this.getNBTTag());
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            this.setChunkSeed(event.world, event.getChunk());
            boolean atLeastOneModified = false;
            for (IRetroGen retroGen : this.retroGeneratables) {
                if (!retroGen.shouldRetroGen(tag, event.world.field_73011_w.func_177502_q())) continue;
                retroGen.retroGenerateChunk(tag, event.getChunk(), this.random);
                this.getMod().log(Level.INFO, "Retrogenerating chunk at " + event.getChunk().field_76635_g + ":" + event.getChunk().field_76647_h);
                atLeastOneModified = true;
            }
            if (atLeastOneModified) {
                event.getChunk().func_76630_e();
            }
        }
    }

    private void setChunkSeed(World world, Chunk chunk) {
        this.random.setSeed(world.func_72905_C());
        long xSeed = this.random.nextLong() >> 3;
        long zSeed = this.random.nextLong() >> 3;
        long chunkSeed = xSeed * (long)chunk.field_76635_g + zSeed * (long)chunk.field_76647_h ^ world.func_72905_C();
        this.random.setSeed(chunkSeed);
    }

    @Override
    @SubscribeEvent
    public void retroGenSave(ChunkDataEvent.Save event) {
        if (this.getMod().getReferenceValue(ModBase.REFKEY_RETROGEN).booleanValue() && event.getData() != null) {
            NBTTagCompound tag = event.getData().func_74775_l(this.getNBTTag());
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            for (IRetroGen retroGen : this.retroGeneratables) {
                retroGen.afterRetroGen(tag);
            }
            event.getData().func_74782_a(this.getNBTTag(), (NBTBase)tag);
        }
    }

    public ModBase getMod() {
        return this.mod;
    }
}

