/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurable;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockContainer;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.IGuiContainerProviderConfigurable;
import org.cyclops.cyclopscore.inventory.container.TileInventoryContainer;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;

public abstract class ConfigurableBlockContainerGui
extends ConfigurableBlockContainer
implements IGuiContainerProviderConfigurable {
    private int guiID;

    public ConfigurableBlockContainerGui(ExtendedConfig eConfig, Material material, Class<? extends CyclopsTileEntity> tileEntity) {
        super(eConfig, material, tileEntity);
        this.hasGui = true;
        if (this.hasGui()) {
            this.guiID = Helpers.getNewId(eConfig.getMod(), Helpers.IDType.GUI);
        }
    }

    @Override
    public int getGuiID() {
        return this.guiID;
    }

    @Override
    public ModBase getMod() {
        return this.getConfig().getMod();
    }

    public boolean func_149721_r() {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos blockPos, IBlockState blockState, EntityPlayer entityplayer, EnumFacing side, float par7, float par8, float par9) {
        super.func_180639_a(world, blockPos, blockState, entityplayer, side, par7, par8, par9);
        if (entityplayer.func_70093_af()) {
            return false;
        }
        if (!world.field_72995_K && this.hasGui()) {
            entityplayer.openGui((Object)this.getConfig().getMod(), this.getGuiID(), world, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
        }
        return true;
    }

    @Override
    protected void onPostBlockDestroyed(World world, BlockPos blockPos) {
        super.onPostBlockDestroyed(world, blockPos);
        if (world.field_72995_K) {
            this.tryCloseClientGui(world);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void tryCloseClientGui(World world) {
        TileInventoryContainer container;
        if (Minecraft.func_71410_x().field_71439_g.field_71070_bA instanceof TileInventoryContainer && ((container = (TileInventoryContainer)Minecraft.func_71410_x().field_71439_g.field_71070_bA).getTile() == null || container.getTile().func_145837_r())) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
        }
    }
}

