/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.cyclops.cyclopscore.client.gui.GuiHandler;
import org.cyclops.cyclopscore.config.configurabletypeaction.ConfigurableTypeAction;
import org.cyclops.cyclopscore.config.extendedconfig.IModelProviderConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;

public class ItemAction
extends ConfigurableTypeAction<ItemConfig> {
    public static void register(Item item, String name, @Nullable CreativeTabs creativeTabs) {
        GameRegistry.registerItem((Item)item, (String)name);
        if (creativeTabs != null) {
            item.func_77637_a(creativeTabs);
        }
    }

    @Override
    public void preRun(ItemConfig eConfig, Configuration config, boolean startup) {
        Property property = config.get(eConfig.getHolderType().getCategory(), eConfig.getNamedId(), eConfig.isEnabled());
        property.setRequiresMcRestart(true);
        property.comment = eConfig.getComment();
        if (startup) {
            eConfig.setEnabled(property.getBoolean(true));
        }
    }

    @Override
    public void postRun(ItemConfig eConfig, Configuration config) {
        eConfig.save();
        Item item = (Item)eConfig.getSubInstance();
        ItemAction.register(item, eConfig.getSubUniqueName(), eConfig.getTargetTab());
        if (item instanceof IGuiContainerProvider) {
            IGuiContainerProvider gui = (IGuiContainerProvider)item;
            eConfig.getMod().getGuiHandler().registerGUI(gui, GuiHandler.GuiType.ITEM);
        }
    }

    public static void handleItemModel(Item item, String namedId, CreativeTabs tab, String modId, IModelProviderConfig modelProvider) {
        if (MinecraftHelpers.isClientSide()) {
            if (item.func_77614_k()) {
                LinkedList itemStacks = Lists.newLinkedList();
                item.func_150895_a(item, tab, (List)itemStacks);
                for (ItemStack itemStack : itemStacks) {
                    String itemName = modelProvider.getModelName(itemStack);
                    ModelBakery.addVariantName((Item)item, (String[])new String[]{modId + ":" + itemName});
                    Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, itemStack.func_77960_j(), new ModelResourceLocation(modId + ":" + itemName, "inventory"));
                }
            } else {
                Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, 0, new ModelResourceLocation(modId + ":" + namedId, "inventory"));
            }
        }
    }

    @Override
    public void polish(ItemConfig config) {
        ItemAction.handleItemModel(config.getItemInstance(), config.getNamedId(), config.getTargetTab(), config.getMod().getModId(), config);
    }
}

