/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.StringHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.cyclopscore.persist.nbt.INBTSerializable;

public final class L10NHelpers {
    public static final int MAX_TOOLTIP_LINE_LENGTH = 25;
    private static final String KEY_ENABLED = "general.cyclopscore.info.enabled";
    private static final String KEY_DISABLED = "general.cyclopscore.info.disabled";

    public static String localize(String key) {
        if (MinecraftHelpers.isModdedEnvironment()) {
            return StatCollector.func_74838_a((String)key);
        }
        return key;
    }

    public static String localize(String key, Object ... params) {
        if (MinecraftHelpers.isModdedEnvironment()) {
            return StatCollector.func_74837_a((String)key, (Object[])params);
        }
        return String.format("%s: %s", key, Arrays.toString(params));
    }

    public static void addStatusInfo(List<String> infoLines, boolean isEnabled, String statusPrefixKey) {
        String autoSupply = L10NHelpers.localize(KEY_DISABLED);
        if (isEnabled) {
            autoSupply = L10NHelpers.localize(KEY_ENABLED);
        }
        infoLines.add(L10NHelpers.localize(statusPrefixKey, autoSupply));
    }

    public static String getLocalizedEntityName(String entityId) {
        return L10NHelpers.localize("entity." + entityId + ".name");
    }

    public static void addOptionalInfo(List list, String prefix) {
        String key = prefix + ".info";
        if (StatCollector.func_94522_b((String)key)) {
            if (MinecraftHelpers.isShifted()) {
                String localized = L10NHelpers.localize(key);
                list.addAll(StringHelpers.splitLines(localized, 25, IInformationProvider.INFO_PREFIX));
            } else {
                list.add(L10NHelpers.localize(EnumChatFormatting.GRAY.toString() + EnumChatFormatting.ITALIC.toString() + L10NHelpers.localize("general.cyclopscore.tooltip.info")));
            }
        }
    }

    public static class UnlocalizedString
    implements INBTSerializable {
        private String parameterizedString;
        private Object[] parameters;

        public UnlocalizedString(String parameterizedString, Object ... parameters) {
            this.parameterizedString = parameterizedString;
            this.parameters = parameters;
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i] instanceof UnlocalizedString || parameters[i] instanceof String) continue;
                parameters[i] = String.valueOf(parameters[i]);
            }
        }

        public UnlocalizedString() {
            this.parameterizedString = null;
            this.parameters = null;
        }

        public String localize() {
            Object[] realParameters = new Object[this.parameters.length];
            for (int i = 0; i < this.parameters.length; ++i) {
                Object param = this.parameters[i];
                realParameters[i] = param instanceof UnlocalizedString ? ((UnlocalizedString)param).localize() : param;
            }
            return L10NHelpers.localize(this.parameterizedString, realParameters);
        }

        @Override
        public NBTTagCompound toNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("parameterizedString", this.parameterizedString);
            NBTTagList list = new NBTTagList();
            for (Object parameter : this.parameters) {
                if (parameter instanceof UnlocalizedString) {
                    NBTTagCompound objectTag = ((UnlocalizedString)parameter).toNBT();
                    objectTag.func_74778_a("type", "object");
                    list.func_74742_a((NBTBase)objectTag);
                    continue;
                }
                NBTTagCompound stringTag = new NBTTagCompound();
                stringTag.func_74782_a("value", (NBTBase)new NBTTagString((String)parameter));
                stringTag.func_74778_a("type", "string");
                list.func_74742_a((NBTBase)stringTag);
            }
            tag.func_74782_a("parameters", (NBTBase)list);
            return tag;
        }

        @Override
        public void fromNBT(NBTTagCompound tag) {
            this.parameterizedString = tag.func_74779_i("parameterizedString");
            NBTTagList list = tag.func_150295_c("parameters", MinecraftHelpers.NBTTag_Types.NBTTagCompound.ordinal());
            this.parameters = new Object[list.func_74745_c()];
            for (int i = 0; i < this.parameters.length; ++i) {
                NBTTagCompound elementTag = list.func_150305_b(i);
                if ("object".equals(elementTag.func_74779_i("type"))) {
                    UnlocalizedString object = new UnlocalizedString();
                    object.fromNBT(elementTag);
                    this.parameters[i] = object;
                    continue;
                }
                this.parameters[i] = elementTag.func_74779_i("value");
            }
        }
    }
}

