/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockContainer;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.cyclopscore.tileentity.TileEntityNBTStorage;
import org.lwjgl.input.Keyboard;

public class MinecraftHelpers {
    public static final int MINECRAFT_DAY = 24000;
    public static final int COMPARATOR_MULTIPLIER = 15;
    public static final int SECOND_IN_TICKS = 20;
    public static final int BLOCK_NOTIFY = 1;
    public static final int BLOCK_NOTIFY_CLIENT = 2;
    public static final int BLOCK_NOTIFY_NO_RERENDER = 4;
    public static List<String> CHESTGENCATEGORIES = new LinkedList<String>();

    public static boolean isDay(World world) {
        return world.func_72820_D() % 24000L < 12000L;
    }

    public static void setDay(World world, boolean toDay) {
        int currentTime = (int)world.func_72820_D();
        int newTime = currentTime - currentTime % 12000 + 12000;
        world.func_72877_b((long)newTime);
    }

    public static Entity spawnCreature(World world, String entityName, double x, double y, double z) {
        return ItemMonsterPlacer.spawnCreature((World)world, (String)entityName, (double)x, (double)y, (double)z);
    }

    public static void dropItems(World world, ItemStack stack, BlockPos blockPos) {
        if (stack.field_77994_a > 0) {
            float offsetMultiply = 0.7f;
            double offsetX = (double)(world.field_73012_v.nextFloat() * offsetMultiply) + (double)(1.0f - offsetMultiply) * 0.5;
            double offsetY = (double)(world.field_73012_v.nextFloat() * offsetMultiply) + (double)(1.0f - offsetMultiply) * 0.5;
            double offsetZ = (double)(world.field_73012_v.nextFloat() * offsetMultiply) + (double)(1.0f - offsetMultiply) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)blockPos.func_177958_n() + offsetX, (double)blockPos.func_177956_o() + offsetY, (double)blockPos.func_177952_p() + offsetZ, stack);
            entityitem.func_174867_a(10);
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static void dropItems(World world, IInventory inventory, BlockPos blockPos) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack == null || itemStack.field_77994_a <= 0) continue;
            MinecraftHelpers.dropItems(world, inventory.func_70301_a(i).func_77946_l(), blockPos);
        }
    }

    public static boolean isPlayerInventoryFull(EntityPlayer player) {
        return player.field_71071_by.func_70447_i() == -1;
    }

    public static boolean isModdedEnvironment() {
        return MinecraftHelpers.class.getClassLoader() instanceof LaunchClassLoader;
    }

    public static boolean isClientSide() {
        if (MinecraftHelpers.isModdedEnvironment()) {
            return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
        }
        return true;
    }

    public static boolean isFluidAndAmountEqual(FluidStack fluid1, FluidStack fluid2) {
        if (fluid1 == null && fluid2 != null || fluid1 != null && fluid2 == null) {
            return false;
        }
        if (fluid1 == null) {
            return true;
        }
        return fluid1.getFluid().getID() == fluid2.getFluid().getID() && fluid1.amount == fluid2.amount;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isShifted() {
        return Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42);
    }

    public static void preDestroyBlock(ConfigurableBlockContainer block, World world, BlockPos blockPos, boolean saveNBT) {
        CyclopsTileEntity ecTile;
        TileEntity tile = world.func_175625_s(blockPos);
        if (tile instanceof IInventory && !world.field_72995_K) {
            MinecraftHelpers.dropItems(world, (IInventory)tile, blockPos);
            InventoryHelpers.clearInventory((IInventory)tile);
        }
        if (tile instanceof CyclopsTileEntity && saveNBT) {
            ecTile = (CyclopsTileEntity)tile;
            TileEntityNBTStorage.TAG = ecTile.getNBTTagCompound();
            block.writeAdditionalInfo(tile, TileEntityNBTStorage.TAG);
            ecTile.destroy();
        } else {
            TileEntityNBTStorage.TAG = null;
        }
        if (tile instanceof IWorldNameable && ((IWorldNameable)tile).func_145818_k_()) {
            ecTile = (IWorldNameable)tile;
            TileEntityNBTStorage.NAME = ecTile.func_70005_c_();
        } else {
            TileEntityNBTStorage.NAME = null;
        }
    }

    public static void postDestroyBlock(IBlockAccess world, BlockPos blockPos) {
    }

    public static int compareBlockPos(BlockPos pos1, BlockPos pos2) {
        int compX = Integer.compare(pos1.func_177958_n(), pos2.func_177958_n());
        if (compX == 0) {
            int compY = Integer.compare(pos1.func_177956_o(), pos2.func_177956_o());
            if (compY == 0) {
                return Integer.compare(pos1.func_177952_p(), pos2.func_177952_p());
            }
            return compY;
        }
        return compX;
    }

    static {
        CHESTGENCATEGORIES.add("bonusChest");
        CHESTGENCATEGORIES.add("dungeonChest");
        CHESTGENCATEGORIES.add("mineshaftCorridor");
        CHESTGENCATEGORIES.add("pyramidDesertyChest");
        CHESTGENCATEGORIES.add("pyramidJungleChest");
        CHESTGENCATEGORIES.add("pyramidJungleDispenser");
        CHESTGENCATEGORIES.add("strongholdCorridor");
        CHESTGENCATEGORIES.add("strongholdCrossing");
        CHESTGENCATEGORIES.add("strongholdLibrary");
        CHESTGENCATEGORIES.add("villageBlacksmith");
    }

    public static enum NBTTag_Types {
        NBTTagEnd,
        NBTTagByte,
        NBTTagShort,
        NBTTagInt,
        NBTTagLong,
        NBTTagFloat,
        NBTTagDouble,
        NBTTagByteArray,
        NBTTagString,
        NBTTagList,
        NBTTagCompound,
        NBTTagIntArray;

    }
}

