/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButton;
import org.cyclops.cyclopscore.infobook.HyperLink;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBookRegistry;
import org.cyclops.cyclopscore.infobook.InfoSection;

public abstract class GuiInfoBook
extends GuiScreen {
    private static final int BUTTON_NEXT = 1;
    private static final int BUTTON_PREVIOUS = 2;
    private static final int BUTTON_PARENT = 3;
    private static final int BUTTON_BACK = 4;
    private static final int BUTTON_HYPERLINKS_START = 5;
    private static final int HR_WIDTH = 88;
    private static final int HR_HEIGHT = 10;
    private static final int BANNER_WIDTH = 91;
    private static final int BANNER_HEIGHT = 12;
    private static final int ARROW_WIDTH = 22;
    private static final int ARROW_HEIGHT = 13;
    private static final int BORDER_CORNER = 4;
    private static final int BORDER_WIDTH = 2;
    private static final int BORDER_X = 0;
    private static final int BORDER_Y = 206;
    protected final IInfoBook infoBook;
    protected final ItemStack itemStack;
    protected final ResourceLocation texture;
    private NextPageButton buttonNextPage;
    private NextPageButton buttonPreviousPage;
    private NextPageButton buttonParent;
    private NextPageButton buttonBack;
    private InfoSection nextSection;
    private int nextPage;
    private boolean goToLastPage;
    private int left;
    private int top;

    public GuiInfoBook(EntityPlayer player, int itemIndex, IInfoBook infoBook, ResourceLocation texture) {
        this.itemStack = InventoryHelpers.getItemFromIndex(player, itemIndex);
        this.infoBook = infoBook;
        this.texture = texture;
        if (infoBook.getCurrentSection() == null) {
            infoBook.setCurrentSection(infoBook.getMod().getRegistryManager().getRegistry(IInfoBookRegistry.class).getRoot(infoBook));
            infoBook.setCurrentPage(0);
        }
    }

    protected int getPages() {
        return this.infoBook.getPagesPerView();
    }

    protected abstract int getGuiWidth();

    protected abstract int getGuiHeight();

    protected abstract int getPageWidth();

    public void func_73866_w_() {
        int page;
        this.field_146292_n.clear();
        super.func_73866_w_();
        this.left = (this.field_146294_l - this.getGuiWidth()) / 2;
        this.top = (this.field_146295_m - this.getGuiHeight()) / 2;
        this.buttonNextPage = new NextPageButton(1, this.left + this.getPageWidth() + 100, this.top + 156, 0, 180, 18, 13, this);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonPreviousPage = new NextPageButton(2, this.left + 23, this.top + 156, 0, 193, 18, 13, this);
        this.field_146292_n.add(this.buttonPreviousPage);
        this.buttonParent = new NextPageButton(3, this.left + 2, this.top + 2, 36, 180, 8, 8, this);
        this.field_146292_n.add(this.buttonParent);
        this.buttonBack = new NextPageButton(4, this.left + this.getPageWidth() + 127, this.top + 2, 0, 223, 13, 18, this);
        this.field_146292_n.add(this.buttonBack);
        this.updateGui();
        if (this.goToLastPage) {
            int page2 = Math.max(0, this.infoBook.getCurrentSection().getPages() - this.getPages());
            page2 += page2 % this.getPages();
            this.infoBook.setCurrentPage(page2);
        }
        int nextId = 5;
        for (int innerPage = page = this.infoBook.getCurrentPage(); innerPage <= page + this.getPages() - 1; ++innerPage) {
            for (HyperLink link : this.infoBook.getCurrentSection().getLinks(innerPage)) {
                int xOffset = this.getOffsetXForPageWithWidths(innerPage % this.getPages());
                this.field_146292_n.add(new TextOverlayButton(nextId++, link, this.left + xOffset + link.getX(), this.top + 8 + link.getY(), InfoSection.getFontHeight(this.getFontRenderer()), this));
            }
            this.field_146292_n.addAll(this.infoBook.getCurrentSection().getAdvancedButtons(innerPage));
        }
    }

    protected abstract int getOffsetXForPageBase(int var1);

    protected int getOffsetXForPageWithWidths(int page) {
        return this.getOffsetXForPageBase(page) + page * this.getPageWidth();
    }

    protected int getOffsetXTotal() {
        int total = 0;
        for (int i = 0; i < this.getPages(); ++i) {
            total += this.getOffsetXForPageBase(i);
        }
        return total;
    }

    public void func_73863_a(int x, int y, float f) {
        int i;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.texture);
        this.func_73729_b(this.left, this.top, 0, 0, this.getPageWidth(), this.getGuiHeight());
        this.drawTexturedModalRectMirrored(this.left + this.getPageWidth() - 1, this.top, 0, 0, this.getPageWidth(), this.getGuiHeight());
        int width = this.getPageWidth() - this.getOffsetXTotal();
        for (i = 0; i < this.getPages(); ++i) {
            this.infoBook.getCurrentSection().drawScreen(this, this.left + this.getOffsetXForPageWithWidths(i), this.top, width, this.getGuiHeight(), this.infoBook.getCurrentPage() + i, x, y);
        }
        super.func_73863_a(x, y, f);
        for (i = 0; i < this.getPages(); ++i) {
            this.infoBook.getCurrentSection().postDrawScreen(this, this.left + this.getOffsetXForPageWithWidths(i), this.top, width, this.getGuiHeight(), this.infoBook.getCurrentPage() + i, x, y);
        }
    }

    public void drawTexturedModalRectMirrored(int x, int y, int u, int v, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)(x + 0), (double)(y + height), (double)this.field_73735_i).func_181673_a((double)((float)(u + width) * f), (double)((float)(v + height) * f1)).func_181675_d();
        worldRenderer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_181673_a((double)((float)(u + 0) * f), (double)((float)(v + height) * f1)).func_181675_d();
        worldRenderer.func_181662_b((double)(x + width), (double)(y + 0), (double)this.field_73735_i).func_181673_a((double)((float)(u + 0) * f), (double)((float)(v + 0) * f1)).func_181675_d();
        worldRenderer.func_181662_b((double)(x + 0), (double)(y + 0), (double)this.field_73735_i).func_181673_a((double)((float)(u + width) * f), (double)((float)(v + 0) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public boolean func_73868_f() {
        return false;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public int getBannerWidth() {
        return 91;
    }

    private void updateGui() {
        boolean oldUnicode = this.field_146297_k.field_71466_p.func_82883_a();
        this.field_146297_k.field_71466_p.func_78264_a(true);
        int width = this.getPageWidth() - this.getOffsetXTotal();
        int lineHeight = InfoSection.getFontHeight(this.getFontRenderer());
        int maxLines = (this.getGuiHeight() - 32 - 5) / lineHeight;
        LinkedList infoSectionsToBake = Lists.newLinkedList();
        infoSectionsToBake.add(this.infoBook.getCurrentSection());
        this.getPreviousSections(infoSectionsToBake);
        this.getNextSections(infoSectionsToBake);
        for (InfoSection infoSection : infoSectionsToBake) {
            if (infoSection == null) continue;
            infoSection.bakeSection(this.getFontRenderer(), width, maxLines, lineHeight);
        }
        this.updateButtons();
        this.field_146297_k.field_71466_p.func_78264_a(oldUnicode);
    }

    protected void getPreviousSections(List<InfoSection> sections) {
        InfoSection.Location location = this.infoBook.getCurrentSection().getPrevious(this.infoBook.getCurrentPage(), false);
        if (location != null) {
            sections.add(location.getInfoSection());
        }
    }

    protected void getNextSections(List<InfoSection> sections) {
        InfoSection.Location location = this.infoBook.getCurrentSection().getNext(this.infoBook.getCurrentPage() + this.getPages() - 1, false);
        if (location != null) {
            sections.add(location.getInfoSection());
        }
    }

    private void updateButtons() {
        InfoSection.Location current1 = new InfoSection.Location(this.infoBook.getCurrentPage(), this.infoBook.getCurrentSection());
        InfoSection.Location current2 = new InfoSection.Location(this.infoBook.getCurrentPage() + this.getPages() - 1, this.infoBook.getCurrentSection());
        InfoSection.Location wouldBeNext = this.infoBook.getCurrentSection().getNext(this.infoBook.getCurrentPage() + this.getPages() - 1, false);
        this.buttonNextPage.field_146125_m = !current1.equals(wouldBeNext) && !current2.equals(wouldBeNext);
        this.buttonPreviousPage.field_146125_m = !current1.equals(this.infoBook.getCurrentSection().getPrevious(this.infoBook.getCurrentPage(), false));
        this.buttonParent.field_146125_m = this.infoBook.getCurrentSection() != null && this.infoBook.getCurrentSection().getParent() != null;
        this.buttonBack.field_146125_m = this.infoBook.getHistory().currentSize() > 0;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        this.goToLastPage = false;
        this.nextSection = this.infoBook.getCurrentSection();
        this.nextPage = this.infoBook.getCurrentPage();
        if (button.field_146127_k == 1 && button.field_146125_m) {
            InfoSection.Location location = this.infoBook.getCurrentSection().getNext(this.infoBook.getCurrentPage() + this.getPages() - 1, MinecraftHelpers.isShifted());
            this.nextSection = location.getInfoSection();
            this.nextPage = location.getPage();
            this.infoBook.getHistory().push(new InfoSection.Location(this.infoBook.getCurrentPage(), this.infoBook.getCurrentSection()));
        } else if (button.field_146127_k == 2 && button.field_146125_m) {
            InfoSection.Location location = this.infoBook.getCurrentSection().getPrevious(this.infoBook.getCurrentPage(), MinecraftHelpers.isShifted());
            this.nextSection = location.getInfoSection();
            this.nextPage = location.getPage();
            this.goToLastPage = this.nextSection != this.infoBook.getCurrentSection() && !MinecraftHelpers.isShifted();
            this.infoBook.getHistory().push(new InfoSection.Location(this.infoBook.getCurrentPage(), this.infoBook.getCurrentSection()));
        } else if (button.field_146127_k == 3 && button.field_146125_m) {
            if (MinecraftHelpers.isShifted()) {
                this.nextSection = this.infoBook.getCurrentSection().getParent();
                while (this.nextSection.getParent() != null) {
                    this.nextSection = this.nextSection.getParent();
                }
            } else {
                this.nextSection = this.infoBook.getCurrentSection().getParent();
            }
            this.nextPage = 0;
            this.infoBook.getHistory().push(new InfoSection.Location(this.infoBook.getCurrentPage(), this.infoBook.getCurrentSection()));
        } else if (button.field_146127_k == 4 && button.field_146125_m && this.infoBook.getHistory().currentSize() > 0) {
            InfoSection.Location location = this.infoBook.getHistory().pop();
            this.nextSection = location.getInfoSection();
            this.nextPage = location.getPage();
        } else if (button instanceof TextOverlayButton) {
            this.nextSection = ((TextOverlayButton)button).getLink().getTarget();
            this.nextPage = 0;
            if (this.nextSection != this.infoBook.getCurrentSection()) {
                this.infoBook.getHistory().push(new InfoSection.Location(this.infoBook.getCurrentPage(), this.infoBook.getCurrentSection()));
            }
        } else if (button instanceof AdvancedButton && ((AdvancedButton)button).isVisible()) {
            this.nextSection = ((AdvancedButton)button).getTarget();
            this.nextPage = 0;
            if (this.nextSection != this.infoBook.getCurrentSection()) {
                this.infoBook.getHistory().push(new InfoSection.Location(this.infoBook.getCurrentPage(), this.infoBook.getCurrentSection()));
            }
        } else {
            super.func_146284_a(button);
        }
    }

    protected void func_73864_a(int x, int y, int p_73864_3_) throws IOException {
        super.func_73864_a(x, y, p_73864_3_);
        if (p_73864_3_ == 0 && this.nextSection != null && (this.nextSection != this.infoBook.getCurrentSection() || this.infoBook.getCurrentPage() != this.nextPage)) {
            this.infoBook.setCurrentSection(this.nextSection);
            this.nextSection = null;
            this.infoBook.setCurrentPage(this.nextPage);
            this.func_73866_w_();
        }
    }

    public void drawScaledCenteredString(String string, int x, int y, int width, float originalScale, int maxWidth, int color) {
        float originalWidth = (float)this.getFontRenderer().func_78256_a(string) * originalScale;
        float scale = Math.min(originalScale, (float)maxWidth / originalWidth * originalScale);
        this.drawScaledCenteredString(string, x, y, width, scale, color);
    }

    public void drawScaledCenteredString(String string, int x, int y, int width, float scale, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        int titleLength = this.field_146289_q.func_78256_a(string);
        int titleHeight = this.field_146289_q.field_78288_b;
        this.field_146289_q.func_78276_b(string, Math.round((float)(x + width / 2) / scale - (float)(titleLength / 2)), Math.round((float)y / scale - (float)(titleHeight / 2)), color);
        GlStateManager.func_179121_F();
    }

    public void drawHorizontalRule(int x, int y) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.texture);
        this.func_73729_b(x - 44, y - 5, 52, 180, 88, 10);
        GlStateManager.func_179084_k();
    }

    public void drawTextBanner(int x, int y) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.texture);
        this.func_73729_b(x - 45, y - 6, 52, 191, 91, 12);
        GlStateManager.func_179084_k();
    }

    public void drawArrowRight(int x, int y) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.texture);
        this.func_73729_b(x, y, 0, 210, 22, 13);
        GlStateManager.func_179084_k();
    }

    public void drawOuterBorder(int x, int y, int width, int height) {
        this.drawOuterBorder(x, y, width, height, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void drawOuterBorder(int x, int y, int width, int height, float r, float g, float b, float alpha) {
        int i;
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)alpha);
        this.field_146297_k.func_110434_K().func_110577_a(this.texture);
        this.func_73729_b(x - 2, y - 2, 0, 206, 4, 4);
        this.func_73729_b(x + width - 2, y - 2, 4, 206, 4, 4);
        this.func_73729_b(x - 2, y + height - 2, 12, 206, 4, 4);
        this.func_73729_b(x + width - 2, y + height - 2, 8, 206, 4, 4);
        for (i = 2; i < width - 2; i += 2) {
            int drawWidth = 2;
            if (i + 2 >= width - 4) {
                drawWidth -= i - (width - 4);
            }
            this.func_73729_b(x + i, y - 2, 16, 206, drawWidth, 2);
            this.func_73729_b(x + i, y + height, 16, 206, drawWidth, 2);
        }
        for (i = 2; i < height - 2; i += 2) {
            int drawHeight = 2;
            if (i + 2 >= height - 4) {
                drawHeight -= i - (height - 4);
            }
            if (drawHeight <= 0) continue;
            this.func_73729_b(x - 2, y + i, 16, 206, 2, drawHeight);
            this.func_73729_b(x + width, y + i, 16, 206, 2, drawHeight);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void func_146285_a(ItemStack itemStack, int x, int y) {
        super.func_146285_a(itemStack, x, y);
    }

    public int getTick() {
        return (int)this.field_146297_k.field_71441_e.func_72820_D();
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.field_146297_k.field_71439_g.func_70089_S() || this.field_146297_k.field_71439_g.field_70128_L) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public abstract void playPageFlipSound(SoundHandler var1);

    @SideOnly(value=Side.CLIENT)
    static class TextOverlayButton
    extends GuiButton {
        private final GuiInfoBook guiInfoBook;
        private HyperLink link;

        public TextOverlayButton(int id, HyperLink link, int x, int y, int height, GuiInfoBook guiInfoBook) {
            super(id, x, y, 0, height, InfoSection.formatString(L10NHelpers.localize(link.getUnlocalizedName())));
            this.guiInfoBook = guiInfoBook;
            this.link = link;
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            boolean oldUnicode = fontRenderer.func_82883_a();
            fontRenderer.func_78264_a(true);
            this.field_146120_f = fontRenderer.func_78256_a(this.field_146126_j);
            fontRenderer.func_78264_a(oldUnicode);
        }

        public void func_146112_a(Minecraft minecraft, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                boolean isHover = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                boolean oldUnicode = minecraft.field_71466_p.func_82883_a();
                minecraft.field_71466_p.func_78264_a(true);
                minecraft.field_71466_p.func_78276_b((isHover ? "\u00a7n" : "") + this.field_146126_j + "\u00a7r", this.field_146128_h, this.field_146129_i, Helpers.RGBToInt(isHover ? 100 : 0, isHover ? 100 : 0, isHover ? 150 : 125));
                minecraft.field_71466_p.func_78264_a(oldUnicode);
            }
        }

        public void func_146113_a(SoundHandler soundHandler) {
            this.guiInfoBook.playPageFlipSound(soundHandler);
        }

        public HyperLink getLink() {
            return this.link;
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class NextPageButton
    extends GuiButton {
        private final GuiInfoBook guiInfoBook;
        private int x;
        private int y;

        public NextPageButton(int id, int xPosition, int yPosition, int x, int y, int width, int height, GuiInfoBook guiInfoBook) {
            super(id, xPosition, yPosition, width, height, "");
            this.x = x;
            this.y = y;
            this.guiInfoBook = guiInfoBook;
        }

        public void func_146112_a(Minecraft minecraft, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                boolean isHover = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                minecraft.func_110434_K().func_110577_a(this.guiInfoBook.texture);
                int k = this.x;
                int l = this.y;
                if (isHover) {
                    k += this.field_146120_f;
                }
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, k, l, this.field_146120_f, this.field_146121_g);
                GlStateManager.func_179084_k();
            }
        }

        public void func_146113_a(SoundHandler soundHandler) {
            this.guiInfoBook.playPageFlipSound(soundHandler);
        }
    }
}

