/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;

public final class ItemStackHelpers {
    private static final Random RANDOM = new Random();

    public static NBTTagCompound getSafeTagCompound(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return itemStack.func_77978_p();
    }

    public static void spawnItemStack(World world, BlockPos pos, ItemStack itemStack) {
        ItemStackHelpers.spawnItemStack(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), itemStack);
    }

    public static void spawnItemStack(World world, double x, double y, double z, ItemStack itemStack) {
        float offsetX = RANDOM.nextFloat() * 0.8f + 0.1f;
        float offsetY = RANDOM.nextFloat() * 0.8f + 0.1f;
        float offsetZ = RANDOM.nextFloat() * 0.8f + 0.1f;
        while (itemStack.field_77994_a > 0) {
            int i = RANDOM.nextInt(21) + 10;
            if (i > itemStack.field_77994_a) {
                i = itemStack.field_77994_a;
            }
            itemStack.field_77994_a -= i;
            ItemStack dropStack = itemStack.func_77946_l();
            dropStack.field_77994_a = i;
            EntityItem entityitem = new EntityItem(world, x + (double)offsetX, y + (double)offsetY, z + (double)offsetZ, dropStack);
            float motion = 0.05f;
            entityitem.field_70159_w = RANDOM.nextGaussian() * (double)motion;
            entityitem.field_70181_x = RANDOM.nextGaussian() * (double)motion + 0.2;
            entityitem.field_70179_y = RANDOM.nextGaussian() * (double)motion;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static void spawnItemStackToPlayer(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        if (!world.field_72995_K) {
            float f = 0.5f;
            double xo = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double yo = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double zo = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + xo, (double)pos.func_177956_o() + yo, (double)pos.func_177952_p() + zo, stack);
            double d0 = 8.0;
            double d1 = (player.field_70165_t - entityitem.field_70165_t) / d0;
            double d2 = (player.field_70163_u + (double)player.func_70047_e() - entityitem.field_70163_u) / d0;
            double d3 = (player.field_70161_v - entityitem.field_70161_v) / d0;
            entityitem.field_70159_w += d1;
            entityitem.field_70181_x += d2;
            entityitem.field_70179_y += d3;
            entityitem.func_174868_q();
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static boolean hasPlayerItem(EntityPlayer player, Item item) {
        PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
        while (it.hasNext()) {
            ItemStack itemStack = it.next();
            if (itemStack == null || itemStack.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static List<ItemStack> getVariants(ItemStack itemStack) {
        LinkedList output = Lists.newLinkedList();
        if (itemStack.func_77952_i() == Short.MAX_VALUE) {
            itemStack.func_77973_b().func_150895_a(itemStack.func_77973_b(), null, (List)output);
        } else {
            output.add(itemStack);
        }
        return output;
    }

    public static ItemStack parseItemStack(String itemStackString) {
        String[] split = itemStackString.split(":");
        String itemName = split[0] + ":" + split[1];
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemName));
        if (item == null) {
            throw new IllegalArgumentException("Invalid ItemStack item: " + itemName);
        }
        int amount = 1;
        int meta = 0;
        if (split.length > 2) {
            try {
                amount = Integer.parseInt(split[2]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid ItemStack amount: " + split[2]);
            }
            if (split.length > 3) {
                try {
                    meta = Integer.parseInt(split[3]);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid ItemStack meta: " + split[3]);
                }
            }
        }
        return new ItemStack(item, amount, meta);
    }

    public static boolean areItemStacksIdentical(ItemStack a, ItemStack b) {
        return ItemStack.func_77989_b((ItemStack)a, (ItemStack)b) && (a == null && b == null || a != null && a.field_77994_a == b.field_77994_a);
    }
}

