/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.helpers.Strings;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.InfoSectionTagIndex;
import org.cyclops.cyclopscore.infobook.pageelement.AchievementRewards;
import org.cyclops.cyclopscore.infobook.pageelement.AchievementRewardsAppendix;
import org.cyclops.cyclopscore.infobook.pageelement.CraftingRecipeAppendix;
import org.cyclops.cyclopscore.infobook.pageelement.FurnaceRecipeAppendix;
import org.cyclops.cyclopscore.infobook.pageelement.IReward;
import org.cyclops.cyclopscore.infobook.pageelement.IRewardFactory;
import org.cyclops.cyclopscore.infobook.pageelement.ImageAppendix;
import org.cyclops.cyclopscore.infobook.pageelement.RewardItem;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.init.RecipeHandler;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeProperties;
import org.cyclops.cyclopscore.recipe.custom.component.DummyPropertiesComponent;
import org.cyclops.cyclopscore.recipe.custom.component.ItemStackRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.ItemStacksRecipeComponent;
import org.cyclops.cyclopscore.recipe.xml.ConfigRecipeConditionHandler;
import org.cyclops.cyclopscore.recipe.xml.IRecipeConditionHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InfoBookParser {
    private static final Map<String, IInfoSectionFactory> SECTION_FACTORIES = Maps.newHashMap();
    private static final Map<String, IAppendixFactory> APPENDIX_FACTORIES = Maps.newHashMap();
    private static final Set<String> IGNORED_APPENDIX_FACTORIES = Sets.newHashSet();
    private static final Map<String, IAppendixListFactory> APPENDIX_LIST_FACTORIES = Maps.newHashMap();
    private static final Map<String, IAppendixItemFactory> APPENDIX_RECIPELIST_FACTORIES = Maps.newHashMap();
    private static final Map<String, IRewardFactory> REWARD_FACTORIES = Maps.newHashMap();

    public static void registerFactory(String name, IInfoSectionFactory factory) {
        if (SECTION_FACTORIES.put(name, factory) != null) {
            throw new RuntimeException(String.format("A section factory with name %s was registered while another one already existed!", name));
        }
    }

    public static void registerIgnoredFactory(String name) {
        IGNORED_APPENDIX_FACTORIES.add(name);
    }

    public static void registerFactory(String name, IAppendixFactory factory) {
        if (APPENDIX_FACTORIES.put(name, factory) != null) {
            throw new RuntimeException(String.format("An appendix factory with name %s was registered while another one already existed!", name));
        }
    }

    public static void registerFactory(String name, IAppendixItemFactory factory) {
        if (APPENDIX_RECIPELIST_FACTORIES.put(name, factory) != null) {
            throw new RuntimeException(String.format("An appendix item factory with name %s was registered while another one already existed!", name));
        }
    }

    public static void registerFactory(String name, IAppendixListFactory factory) {
        if (APPENDIX_LIST_FACTORIES.put(name, factory) != null) {
            throw new RuntimeException(String.format("An appendix item factory with name %s was registered while another one already existed!", name));
        }
    }

    public static void registerFactory(String name, IRewardFactory factory) {
        if (REWARD_FACTORIES.put(name, factory) != null) {
            throw new RuntimeException(String.format("A reward factory with name %s was registered while another one already existed!", name));
        }
    }

    public static int getIndex(Element node) {
        int index = 0;
        if (!node.getAttribute("index").isEmpty()) {
            index = Integer.parseInt(node.getAttribute("index"));
        }
        return index;
    }

    public static ItemStack createStack(Element node, RecipeHandler recipeHandler) throws InvalidAppendixException {
        int meta = Short.MAX_VALUE;
        int amount = 1;
        if (!node.getAttribute("meta").isEmpty()) {
            meta = Integer.parseInt(node.getAttribute("meta"));
        }
        if (!node.getAttribute("amount").isEmpty()) {
            amount = Integer.parseInt(node.getAttribute("amount"));
        }
        if ("true".equals(node.getAttribute("predefined"))) {
            ItemStack itemStack = recipeHandler.getPredefinedItem(node.getTextContent());
            if (itemStack == null) {
                throw new InvalidAppendixException("Could not find predefined item " + node.getTextContent());
            }
            return itemStack;
        }
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(node.getTextContent()));
        if (item == null) {
            throw new InvalidAppendixException("Invalid item " + node.getTextContent());
        }
        return new ItemStack(item, amount, meta);
    }

    public static FluidStack createFluidStack(Element node, RecipeHandler recipeHandler) throws InvalidAppendixException {
        Fluid fluid;
        int amount = 1000;
        if (!node.getAttribute("amount").isEmpty()) {
            amount = Integer.parseInt(node.getAttribute("amount"));
        }
        if ((fluid = FluidRegistry.getFluid((String)node.getTextContent())) == null) {
            throw new InvalidAppendixException("Invalid fluid " + node.getTextContent());
        }
        return new FluidStack(fluid, amount);
    }

    public static InfoSection initializeInfoBook(IInfoBook infoBook, String path, @Nullable InfoSection parent) {
        try {
            InfoSectionTagIndex tagIndex;
            InputStream is = InfoBookParser.class.getResourceAsStream(path);
            StreamSource stream = new StreamSource(is);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(stream.getInputStream());
            InfoSection root = InfoBookParser.buildSection(infoBook, parent, 0, doc.getDocumentElement());
            if (parent == null) {
                tagIndex = new InfoSectionTagIndex(infoBook, root);
                root.registerSection(tagIndex);
                infoBook.setTagIndex(tagIndex);
            } else {
                tagIndex = infoBook.getTagIndex();
            }
            tagIndex.addSoftLinks(root);
            return root;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
            throw new InfoBookException("Info Book XML is invalid.");
        }
    }

    protected static InfoSection buildSection(IInfoBook infoBook, InfoSection parent, int childIndex, Element sectionElement) {
        ModBase mod = infoBook.getMod();
        NodeList sections = sectionElement.getElementsByTagName("section");
        NodeList tags = sectionElement.getElementsByTagName("tag");
        NodeList paragraphs = sectionElement.getElementsByTagName("paragraph");
        NodeList appendixes = sectionElement.getElementsByTagName("appendix");
        NodeList appendixLists = sectionElement.getElementsByTagName("appendixList");
        ArrayList paragraphList = Lists.newArrayListWithCapacity((int)paragraphs.getLength());
        ArrayList appendixList = Lists.newArrayListWithCapacity((int)appendixes.getLength());
        ArrayList tagList = Lists.newArrayListWithCapacity((int)tags.getLength());
        String sectionName = sectionElement.getAttribute("name");
        InfoSection section = InfoBookParser.createSection(infoBook, parent, childIndex, sectionElement.getAttribute("type"), sectionName, paragraphList, appendixList, tagList);
        infoBook.addSection(sectionName, section);
        if (sections.getLength() > 0) {
            int subChildIndex = 0;
            for (int i = 0; i < sections.getLength(); ++i) {
                InfoSection subsubsection;
                Element subsection = (Element)sections.item(i);
                if (subsection.getParentNode() != sectionElement || (subsubsection = InfoBookParser.buildSection(infoBook, section, subChildIndex, subsection)) == null) continue;
                section.registerSection(subsubsection);
                ++subChildIndex;
            }
        } else {
            int j;
            for (j = 0; j < tags.getLength(); ++j) {
                IRecipeConditionHandler conditionHandler;
                Element tag = (Element)tags.item(j);
                String tagString = tag.getTextContent();
                String type = "config";
                if (tag.hasAttribute("type")) {
                    type = tag.getAttribute("type");
                }
                ModBase modRecipe = mod;
                if (tagString.contains(":")) {
                    String[] split = tagString.split(":");
                    modRecipe = ModBase.get(split[0]);
                    tagString = split[1];
                }
                if (!(conditionHandler = modRecipe.getRecipeHandler().getRecipeConditionHandlers().get(type)).isSatisfied(modRecipe.getRecipeHandler(), tagString)) {
                    return null;
                }
                if (!(conditionHandler instanceof ConfigRecipeConditionHandler)) continue;
                tagList.add(tag.getTextContent());
            }
            for (j = 0; j < paragraphs.getLength(); ++j) {
                Element paragraph = (Element)paragraphs.item(j);
                paragraphList.add(paragraph.getTextContent());
            }
            for (j = 0; j < appendixes.getLength(); ++j) {
                try {
                    Element appendix = (Element)appendixes.item(j);
                    SectionAppendix sectionAppendix = InfoBookParser.createAppendix(infoBook, appendix.getAttribute("type"), appendix);
                    if (sectionAppendix == null) continue;
                    appendixList.add(sectionAppendix);
                    continue;
                }
                catch (InvalidAppendixException e) {
                    infoBook.getMod().log(Level.WARN, e.getMessage());
                }
            }
            for (j = 0; j < appendixLists.getLength(); ++j) {
                Element appendixListNode = (Element)appendixLists.item(j);
                String factoryType = appendixListNode.getAttribute("factory");
                if (Strings.isEmpty((CharSequence)factoryType)) {
                    factoryType = "default";
                }
                if (!Strings.isNotEmpty((CharSequence)factoryType)) continue;
                try {
                    appendixList.addAll(InfoBookParser.createAppendixes(infoBook, factoryType, appendixListNode));
                    continue;
                }
                catch (InvalidAppendixException e) {
                    infoBook.getMod().log(Level.WARN, e.getMessage());
                }
            }
        }
        return section;
    }

    protected static InfoSection createSection(IInfoBook infoBook, InfoSection parent, int childIndex, String type, String unlocalizedName, ArrayList<String> paragraphs, List<SectionAppendix> appendixes, ArrayList<String> tagList) {
        IInfoSectionFactory factory;
        if (type == null) {
            type = "";
        }
        if ((factory = SECTION_FACTORIES.get(type)) == null) {
            throw new InfoBookException("No section of type '" + type + "' was found.");
        }
        return factory.create(infoBook, parent, childIndex, unlocalizedName, paragraphs, appendixes, tagList);
    }

    protected static SectionAppendix createAppendix(IInfoBook infoBook, String type, Element node) throws InvalidAppendixException {
        IAppendixFactory factory;
        if (type == null) {
            type = "";
        }
        if ((factory = APPENDIX_FACTORIES.get(type)) == null) {
            if (IGNORED_APPENDIX_FACTORIES.contains(type)) {
                throw new InvalidAppendixException("Ignore appendix of type '" + type + "'.");
            }
            throw new InfoBookException("No appendix of type '" + type + "' was found.");
        }
        return factory.create(infoBook, node);
    }

    protected static SectionAppendix createAppendix(IInfoBook infoBook, String type, IRecipe recipe) throws InvalidAppendixException {
        IAppendixItemFactory factory;
        if (type == null) {
            type = "";
        }
        if ((factory = APPENDIX_RECIPELIST_FACTORIES.get(type)) == null) {
            throw new InfoBookException("No appendix list of type '" + type + "' was found.");
        }
        return factory.create(infoBook, recipe);
    }

    protected static List<SectionAppendix> createAppendixes(IInfoBook infoBook, String factory, Element node) throws InvalidAppendixException {
        IAppendixListFactory factoryInstance;
        if (factory == null) {
            factory = "";
        }
        if ((factoryInstance = APPENDIX_LIST_FACTORIES.get(factory)) == null) {
            throw new InfoBookException("No appendix list of factory '" + factory + "' was found.");
        }
        return factoryInstance.create(infoBook, node);
    }

    protected static IReward createReward(IInfoBook infoBook, String type, Element node) throws InvalidAppendixException {
        IRewardFactory factory;
        if (type == null) {
            type = "";
        }
        if ((factory = REWARD_FACTORIES.get(type)) == null) {
            throw new InfoBookException("No reward factory of type '" + type + "' was found.");
        }
        return factory.create(infoBook, node);
    }

    static {
        InfoBookParser.registerFactory("", new IInfoSectionFactory(){

            @Override
            public InfoSection create(IInfoBook infoBook, InfoSection parent, int childIndex, String unlocalizedName, ArrayList<String> paragraphs, List<SectionAppendix> appendixes, ArrayList<String> tagList) {
                return new InfoSection(infoBook, parent, childIndex, unlocalizedName, paragraphs, appendixes, tagList);
            }
        });
        InfoBookParser.registerFactory("image", new IAppendixFactory(){

            @Override
            public SectionAppendix create(IInfoBook infoBook, Element node) throws InvalidAppendixException {
                return new ImageAppendix(infoBook, new ResourceLocation(node.getTextContent()), Integer.parseInt(node.getAttribute("width")), Integer.parseInt(node.getAttribute("height")));
            }
        });
        InfoBookParser.registerFactory("craftingRecipe", new IAppendixFactory(){

            @Override
            public SectionAppendix create(IInfoBook infoBook, Element node) throws InvalidAppendixException {
                try {
                    return new CraftingRecipeAppendix(infoBook, CraftingHelpers.findCraftingRecipe(InfoBookParser.createStack(node, infoBook.getMod().getRecipeHandler()), InfoBookParser.getIndex(node)));
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidAppendixException(e.getMessage());
                }
            }
        });
        InfoBookParser.registerFactory("furnaceRecipe", new IAppendixFactory(){

            @Override
            public SectionAppendix create(IInfoBook infoBook, Element node) throws InvalidAppendixException {
                try {
                    return new FurnaceRecipeAppendix(infoBook, CraftingHelpers.findFurnaceRecipe(InfoBookParser.createStack(node, infoBook.getMod().getRecipeHandler()), InfoBookParser.getIndex(node)));
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidAppendixException(e.getMessage());
                }
            }
        });
        InfoBookParser.registerFactory("achievement_rewards", new IAppendixFactory(){

            @Override
            public SectionAppendix create(IInfoBook infoBook, Element node) throws InvalidAppendixException {
                if (infoBook.getMod().getReferenceValue(ModBase.REFKEY_INFOBOOK_REWARDS).booleanValue()) {
                    ArrayList achievements = Lists.newArrayList();
                    ArrayList rewards = Lists.newArrayList();
                    String achievementRewardsId = node.getAttribute("id");
                    NodeList children = node.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        int j;
                        if (!(children.item(i) instanceof Element)) continue;
                        Element child = (Element)children.item(i);
                        NodeList subChildren = child.getChildNodes();
                        if (child.getNodeName().equals("achievements")) {
                            for (j = 0; j < subChildren.getLength(); ++j) {
                                Element achievementNode;
                                String achievementId;
                                if (!(subChildren.item(j) instanceof Element) || (achievementId = (achievementNode = (Element)subChildren.item(j)).getAttribute("id")).isEmpty()) continue;
                                Achievement achievement = (Achievement)StatList.func_151177_a((String)achievementId);
                                if (achievement == null) {
                                    throw new InvalidAppendixException(String.format("Could not find an achievement by id '%s'", achievementId));
                                }
                                achievements.add(achievement);
                            }
                            continue;
                        }
                        if (!child.getNodeName().equals("rewards")) continue;
                        for (j = 0; j < subChildren.getLength(); ++j) {
                            if (!(subChildren.item(j) instanceof Element)) continue;
                            Element rewardNode = (Element)subChildren.item(j);
                            String rewardType = rewardNode.getAttribute("type");
                            rewards.add(InfoBookParser.createReward(infoBook, rewardType, rewardNode));
                        }
                    }
                    if (achievementRewardsId == null || achievementRewardsId.isEmpty()) {
                        throw new InvalidAppendixException("Every achievement rewards tag must have a unique id attribute");
                    }
                    AchievementRewards achievementRewards = new AchievementRewards(achievementRewardsId, achievements, rewards);
                    return new AchievementRewardsAppendix(infoBook, achievementRewards);
                }
                return null;
            }
        });
        InfoBookParser.registerFactory("default", new IAppendixListFactory(){

            @Override
            public List<SectionAppendix> create(IInfoBook infoBook, Element node) throws InvalidAppendixException {
                ArrayList appendixList = Lists.newArrayList();
                String type = node.getAttribute("type");
                Collection recipes = infoBook.getMod().getRecipeHandler().getTaggedRecipes().get((Object)(type + ":" + node.getTextContent()));
                for (IRecipe recipe : recipes) {
                    try {
                        appendixList.add(InfoBookParser.createAppendix(infoBook, type, recipe));
                    }
                    catch (InvalidAppendixException e) {
                        infoBook.getMod().log(Level.WARN, e.getMessage());
                    }
                }
                return appendixList;
            }
        });
        InfoBookParser.registerFactory("craftingRecipe", new IAppendixItemFactory<ItemStacksRecipeComponent, ItemStackRecipeComponent, DummyPropertiesComponent>(){

            @Override
            public SectionAppendix create(IInfoBook infoBook, IRecipe<ItemStacksRecipeComponent, ItemStackRecipeComponent, DummyPropertiesComponent> recipe) throws InvalidAppendixException {
                try {
                    return new CraftingRecipeAppendix(infoBook, CraftingHelpers.findCraftingRecipe(recipe.getOutput().getItemStack(), 0));
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidAppendixException(e.getMessage());
                }
            }
        });
        InfoBookParser.registerFactory("furnaceRecipe", new IAppendixItemFactory<ItemStackRecipeComponent, ItemStackRecipeComponent, DummyPropertiesComponent>(){

            @Override
            public SectionAppendix create(IInfoBook infoBook, IRecipe<ItemStackRecipeComponent, ItemStackRecipeComponent, DummyPropertiesComponent> recipe) throws InvalidAppendixException {
                try {
                    return new FurnaceRecipeAppendix(infoBook, CraftingHelpers.findFurnaceRecipe(recipe.getOutput().getItemStack(), 0));
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidAppendixException(e.getMessage());
                }
            }
        });
        InfoBookParser.registerFactory("item", new IRewardFactory(){

            @Override
            public IReward create(IInfoBook infoBook, Element node) throws InvalidAppendixException {
                ItemStack itemStack = InfoBookParser.createStack(node, infoBook.getMod().getRecipeHandler());
                if (itemStack.func_77960_j() == Short.MAX_VALUE) {
                    itemStack.func_77964_b(0);
                }
                return new RewardItem(itemStack);
            }
        });
    }

    public static class InvalidAppendixException
    extends Exception {
        public InvalidAppendixException(String message) {
            super(message);
        }
    }

    public static class InfoBookException
    extends RuntimeException {
        public InfoBookException(String message) {
            super(message);
        }
    }

    public static interface IAppendixItemFactory<I extends IRecipeInput, O extends IRecipeOutput, P extends IRecipeProperties> {
        public SectionAppendix create(IInfoBook var1, IRecipe<I, O, P> var2) throws InvalidAppendixException;
    }

    public static interface IAppendixListFactory {
        public List<SectionAppendix> create(IInfoBook var1, Element var2) throws InvalidAppendixException;
    }

    public static interface IAppendixFactory {
        public SectionAppendix create(IInfoBook var1, Element var2) throws InvalidAppendixException;
    }

    public static interface IInfoSectionFactory {
        public InfoSection create(IInfoBook var1, InfoSection var2, int var3, String var4, ArrayList<String> var5, List<SectionAppendix> var6, ArrayList<String> var7);
    }
}

