/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntObjectMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ItemMatch;
import org.cyclops.commoncapabilities.api.capability.itemhandler.SlotlessItemHandlerWrapper;

public class IndexedSlotlessItemHandlerWrapper
extends SlotlessItemHandlerWrapper {
    private final IInventoryIndexReference inventory;
    private MovementStrategy inputStrategy;
    private MovementStrategy outputStrategy;

    public IndexedSlotlessItemHandlerWrapper(IItemHandler itemHandler, IInventoryIndexReference inventory, MovementStrategy inputStrategy, MovementStrategy outputStrategy) {
        super(itemHandler);
        this.inventory = inventory;
        this.inputStrategy = inputStrategy;
        this.outputStrategy = outputStrategy;
    }

    public IndexedSlotlessItemHandlerWrapper(IItemHandler itemHandler, IInventoryIndexReference inventory) {
        this(itemHandler, inventory, MovementStrategy.FIRST, MovementStrategy.FIRST);
    }

    protected int getNonFullSlotWithItemStack(@Nonnull ItemStack itemStack, int matchFlags) {
        Map<Item, TIntObjectMap<ItemStack>> items = this.inventory.getIndex();
        TIntObjectMap<ItemStack> stacks = items.get(itemStack.func_77973_b());
        if (stacks != null) {
            TIntObjectIterator it = stacks.iterator();
            while (it.hasNext()) {
                it.advance();
                if (((ItemStack)it.value()).field_77994_a >= Math.min(this.inventory.getInventoryStackLimit(), ((ItemStack)it.value()).func_77976_d()) || !ItemMatch.areItemStacksEqual((ItemStack)((ItemStack)it.value()), (ItemStack)itemStack, (int)matchFlags)) continue;
                return it.key();
            }
        }
        return -1;
    }

    protected int getNonEmptySlotWithItemStack(@Nonnull ItemStack itemStack, int matchFlags) {
        Map<Item, TIntObjectMap<ItemStack>> items = this.inventory.getIndex();
        TIntObjectMap<ItemStack> stacks = items.get(itemStack.func_77973_b());
        if (stacks != null) {
            TIntObjectIterator it = stacks.iterator();
            while (it.hasNext()) {
                it.advance();
                if (!ItemMatch.areItemStacksEqual((ItemStack)((ItemStack)it.value()), (ItemStack)itemStack, (int)matchFlags)) continue;
                return it.key();
            }
        }
        return -1;
    }

    protected int getEmptySlot() {
        return this.inputStrategy == MovementStrategy.FIRST ? this.inventory.getFirstEmptySlot() : this.inventory.getLastEmptySlot();
    }

    protected int getNonEmptySlot() {
        return this.outputStrategy == MovementStrategy.FIRST ? this.inventory.getFirstNonEmptySlot() : this.inventory.getLastNonEmptySlot();
    }

    public MovementStrategy getInputStrategy() {
        return this.inputStrategy;
    }

    public void setInputStrategy(MovementStrategy inputStrategy) {
        this.inputStrategy = inputStrategy;
    }

    public MovementStrategy getOutputStrategy() {
        return this.outputStrategy;
    }

    public void setOutputStrategy(MovementStrategy outputStrategy) {
        this.outputStrategy = outputStrategy;
    }

    public static interface IInventoryIndexReference {
        public int getInventoryStackLimit();

        public Map<Item, TIntObjectMap<ItemStack>> getIndex();

        public int getFirstEmptySlot();

        public int getLastEmptySlot();

        public int getFirstNonEmptySlot();

        public int getLastNonEmptySlot();
    }

    public static enum MovementStrategy {
        FIRST,
        LAST;

    }
}

