/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.world.gen;

import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.feature.WorldGenMinable;
import org.cyclops.cyclopscore.world.gen.IRetroGen;

public class WorldGenMinableExtended
extends WorldGenMinable
implements IRetroGen {
    protected int blocksPerVein;
    protected int veinsPerChunk;
    protected int startY;
    protected int endY;
    protected IBlockState state;
    protected Block replaceTarget;

    public WorldGenMinableExtended(IBlockState state, int blocksPerVein, int veinsPerChunk, int startY, int endY, Block replaceTarget) {
        super(state, blocksPerVein, (Predicate)BlockMatcher.func_177642_a((Block)replaceTarget));
        this.state = state;
        this.blocksPerVein = blocksPerVein;
        this.veinsPerChunk = veinsPerChunk;
        this.startY = startY;
        this.endY = endY;
        this.replaceTarget = replaceTarget;
    }

    public void loopGenerate(World world, Random rand, int chunkX, int chunkZ) {
        for (int k = 0; k < this.veinsPerChunk; ++k) {
            int firstBlockXCoord = chunkX + rand.nextInt(16);
            int firstBlockYCoord = this.startY + rand.nextInt(this.endY - this.startY);
            int firstBlockZCoord = chunkZ + rand.nextInt(16);
            this.func_180709_b(world, rand, new BlockPos(firstBlockXCoord, firstBlockYCoord, firstBlockZCoord));
        }
    }

    protected String getUniqueName() {
        return this.state.func_177230_c().func_149739_a();
    }

    protected boolean generate(Chunk chunk, Random rand, int x, int y, int z) {
        float f = rand.nextFloat() * (float)Math.PI;
        double d0 = (float)(x + 8) + MathHelper.func_76126_a((float)f) * (float)this.blocksPerVein / 8.0f;
        double d1 = (float)(x + 8) - MathHelper.func_76126_a((float)f) * (float)this.blocksPerVein / 8.0f;
        double d2 = (float)(z + 8) + MathHelper.func_76134_b((float)f) * (float)this.blocksPerVein / 8.0f;
        double d3 = (float)(z + 8) - MathHelper.func_76134_b((float)f) * (float)this.blocksPerVein / 8.0f;
        double d4 = y + rand.nextInt(3) - 2;
        double d5 = y + rand.nextInt(3) - 2;
        for (int l = 0; l <= this.blocksPerVein; ++l) {
            double d6 = d0 + (d1 - d0) * (double)l / (double)this.blocksPerVein;
            double d7 = d4 + (d5 - d4) * (double)l / (double)this.blocksPerVein;
            double d8 = d2 + (d3 - d2) * (double)l / (double)this.blocksPerVein;
            double d9 = rand.nextDouble() * (double)this.blocksPerVein / 16.0;
            double d10 = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)this.blocksPerVein)) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)this.blocksPerVein)) + 1.0f) * d9 + 1.0;
            int i1 = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
            int j1 = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
            int k1 = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
            int l1 = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
            int i2 = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
            int j2 = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
            for (int cx = i1; cx <= l1; ++cx) {
                double d12 = ((double)cx + 0.5 - d6) / (d10 / 2.0);
                if (!(d12 * d12 < 1.0)) continue;
                for (int cy = j1; cy <= i2; ++cy) {
                    double d13 = ((double)cy + 0.5 - d7) / (d11 / 2.0);
                    if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                    for (int cz = k1; cz <= j2; ++cz) {
                        IBlockState oldBlockState;
                        Block oldBlock;
                        if (cx <= 0 || cx >= 16 || cz <= 0 || cz >= 16) continue;
                        BlockPos blockPos = new BlockPos(cx, cy, cz);
                        ExtendedBlockStorage storage = chunk.func_76587_i()[y >> 4];
                        if (storage == null || (oldBlock = (oldBlockState = chunk.func_177435_g(blockPos)).func_177230_c()) == null || oldBlockState == this.state || !oldBlock.isReplaceableOreGen(oldBlockState, (IBlockAccess)chunk.func_177412_p(), blockPos, (Predicate)new Predicate<IBlockState>(){

                            public boolean apply(@Nullable IBlockState input) {
                                return input.equals(oldBlockState);
                            }

                            public boolean equals(@Nullable Object object) {
                                return object.equals(oldBlockState);
                            }
                        }) || oldBlock.hasTileEntity(oldBlockState)) continue;
                        storage.func_177484_a(x, y & 0xF, z, oldBlockState);
                    }
                }
            }
        }
        return true;
    }

    @Override
    public void retroGenerateChunk(NBTTagCompound tag, Chunk chunk, Random rand) {
        for (int k = 0; k < this.veinsPerChunk; ++k) {
            int x = rand.nextInt(16);
            int y = this.startY + rand.nextInt(this.endY - this.startY);
            int z = rand.nextInt(16);
            this.generate(chunk, rand, x, y, z);
        }
    }

    @Override
    public boolean shouldRetroGen(NBTTagCompound tag, int dimensionId) {
        return !tag.func_74767_n(this.getUniqueName());
    }

    @Override
    public void afterRetroGen(NBTTagCompound tag) {
        tag.func_74757_a(this.getUniqueName(), true);
    }
}

