/*
 * Decompiled with CFR 0.152.
 */
package me.benfah.doorsofinfinity.block;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import me.benfah.doorsofinfinity.block.entity.InfinityDoorBlockEntity;
import me.benfah.doorsofinfinity.config.DOFConfig;
import me.benfah.doorsofinfinity.dimension.InfinityDimHelper;
import me.benfah.doorsofinfinity.init.DOFBlocks;
import me.benfah.doorsofinfinity.init.DOFDimensions;
import me.benfah.doorsofinfinity.utils.MCUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class InfinityDoorBlock
extends ContainerBlock {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.field_208142_aq;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    protected static final VoxelShape SOUTH_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_SHAPE = Block.func_208617_a((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);

    public InfinityDoorBlock(Block.Properties settings) {
        super(settings);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a(HINGE, (Comparable)DoorHingeSide.LEFT)).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        boolean flag = (Boolean)state.func_177229_b((IProperty)OPEN) == false;
        boolean flag1 = state.func_177229_b(HINGE) == DoorHingeSide.RIGHT;
        switch (direction) {
            default: {
                return flag ? EAST_SHAPE : (flag1 ? NORTH_SHAPE : SOUTH_SHAPE);
            }
            case SOUTH: {
                return flag ? SOUTH_SHAPE : (flag1 ? EAST_SHAPE : WEST_SHAPE);
            }
            case WEST: {
                return flag ? WEST_SHAPE : (flag1 ? SOUTH_SHAPE : NORTH_SHAPE);
            }
            case NORTH: 
        }
        return flag ? NORTH_SHAPE : (flag1 ? WEST_SHAPE : EAST_SHAPE);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.func_177229_b(HALF);
        if (facing.func_176740_k() == Direction.Axis.Y && doubleBlockHalf == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            return neighborState.func_177230_c() == this && neighborState.func_177229_b(HALF) != doubleBlockHalf ? (BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)FACING, neighborState.func_177229_b((IProperty)FACING))).func_206870_a((IProperty)OPEN, neighborState.func_177229_b((IProperty)OPEN))).func_206870_a(HINGE, neighborState.func_177229_b(HINGE)) : Blocks.field_150350_a.func_176223_P();
        }
        return doubleBlockHalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !state.func_196955_c((IWorldReader)world, pos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(state, facing, neighborState, world, pos, neighborPos);
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, TileEntity blockEntity, ItemStack stack) {
        super.func_180657_a(world, player, pos, Blocks.field_150350_a.func_176223_P(), blockEntity, stack);
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos lowerPos = state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? pos : pos.func_177977_b();
        BlockState lowerBlockState = world.func_180495_p(lowerPos);
        InfinityDoorBlockEntity firstEntity = (InfinityDoorBlockEntity)world.func_175625_s(lowerPos);
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.func_177229_b(HALF);
        BlockPos otherPos = doubleBlockHalf == DoubleBlockHalf.LOWER ? pos.func_177984_a() : pos.func_177977_b();
        BlockState otherblockState = world.func_180495_p(otherPos);
        InfinityDoorBlockEntity lowerBlockEntity = (InfinityDoorBlockEntity)world.func_175625_s(lowerPos);
        if (otherblockState.func_177230_c() == this && otherblockState.func_177229_b(HALF) != doubleBlockHalf) {
            world.func_217378_a(player, 2001, otherPos, Block.func_196246_j((BlockState)otherblockState));
            if (!world.field_72995_K && !player.func_184812_l_() && player.func_184823_b(otherblockState)) {
                Block.func_220059_a((BlockState)lowerBlockState, (World)world, (BlockPos)lowerPos, (TileEntity)world.func_175625_s(lowerPos));
            }
            world.func_180501_a(otherPos, Blocks.field_150350_a.func_176223_P(), 35);
        }
        if (!world.field_72995_K && MCUtils.immersivePortalsPresent) {
            lowerBlockEntity.deleteLocalPortal();
        }
        super.func_176208_a(world, pos, state, player);
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader world, BlockPos pos) {
        if (world instanceof World && ((World)world).func_201675_m().func_186058_p() == DOFDimensions.INFINITY_DIM) {
            return 0.0f;
        }
        return super.func_180647_a(state, player, world, pos);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return (Boolean)state.func_177229_b((IProperty)OPEN);
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return (Boolean)state.func_177229_b((IProperty)OPEN);
            }
        }
        return false;
    }

    private int getCloseSound() {
        return this.field_149764_J == Material.field_151573_f ? 1011 : 1012;
    }

    private int getOpenSound() {
        return this.field_149764_J == Material.field_151573_f ? 1005 : 1006;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        if (blockpos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(blockpos.func_177984_a()).func_196953_a(context)) {
            World world = context.func_195991_k();
            boolean flag = world.func_175640_z(blockpos) || world.func_175640_z(blockpos.func_177984_a());
            return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f())).func_206870_a(HINGE, (Comparable)this.getHinge(context))).func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(flag))).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.func_180501_a(pos.func_177984_a(), (BlockState)state.func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER && !worldIn.field_72995_K) {
            InfinityDoorBlockEntity blockEntity;
            if (stack != null && stack.func_179543_a("BlockEntity") != null) {
                blockEntity = new InfinityDoorBlockEntity();
                blockEntity.updateSyncDoor();
            }
            blockEntity = (InfinityDoorBlockEntity)worldIn.func_175625_s(pos);
            InfinityDimHelper.PersonalDimension personalDim = blockEntity.getOrCreateLinkedDimension();
            blockEntity.placeSyncedDoor((World)worldIn.func_73046_m().func_71218_a(DOFDimensions.INFINITY_DIM), personalDim.getPlayerPos());
        }
    }

    private DoorHingeSide getHinge(BlockItemUseContext ctx) {
        boolean bl2;
        World blockView = ctx.func_195991_k();
        BlockPos blockPos = ctx.func_195995_a();
        Direction direction = ctx.func_195992_f();
        BlockPos blockPos2 = blockPos.func_177984_a();
        Direction direction2 = direction.func_176735_f();
        BlockPos blockPos3 = blockPos.func_177972_a(direction2);
        BlockState blockState = blockView.func_180495_p(blockPos3);
        BlockPos blockPos4 = blockPos2.func_177972_a(direction2);
        BlockState blockState2 = blockView.func_180495_p(blockPos4);
        Direction direction3 = direction.func_176746_e();
        BlockPos blockPos5 = blockPos.func_177972_a(direction3);
        BlockState blockState3 = blockView.func_180495_p(blockPos5);
        BlockPos blockPos6 = blockPos2.func_177972_a(direction3);
        BlockState blockState4 = blockView.func_180495_p(blockPos6);
        int i = (blockState.func_215686_e((IBlockReader)blockView, blockPos3) ? -1 : 0) + (blockState2.func_215686_e((IBlockReader)blockView, blockPos4) ? -1 : 0) + (blockState3.func_215686_e((IBlockReader)blockView, blockPos5) ? 1 : 0) + (blockState4.func_215686_e((IBlockReader)blockView, blockPos6) ? 1 : 0);
        boolean bl = blockState.func_177230_c() == this && blockState.func_177229_b(HALF) == DoubleBlockHalf.LOWER;
        boolean bl3 = bl2 = blockState3.func_177230_c() == this && blockState3.func_177229_b(HALF) == DoubleBlockHalf.LOWER;
        if ((!bl || bl2) && i <= 0) {
            if ((!bl2 || bl) && i >= 0) {
                int j = direction.func_82601_c();
                int k = direction.func_82599_e();
                Vec3d vec3d = ctx.func_221532_j();
                double d = vec3d.field_72450_a - (double)blockPos.func_177958_n();
                double e = vec3d.field_72449_c - (double)blockPos.func_177952_p();
                return !(j < 0 && !(e >= 0.5) || j > 0 && !(e <= 0.5) || k < 0 && !(d <= 0.5) || k > 0 && !(d >= 0.5)) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        state = (BlockState)state.func_177231_a((IProperty)OPEN);
        world.func_180501_a(pos, state, 10);
        world.func_217378_a(player, (Boolean)state.func_177229_b((IProperty)OPEN) != false ? this.getCloseSound() : this.getOpenSound(), pos, 0);
        if (!world.field_72995_K) {
            BlockPos lowerPos = state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? pos : pos.func_177977_b();
            InfinityDoorBlockEntity blockEntity = (InfinityDoorBlockEntity)world.func_175625_s(lowerPos);
            blockEntity.updateSyncDoor();
        }
        return ActionResultType.SUCCESS;
    }

    public void setOpen(World world, BlockPos pos, boolean open) {
        BlockState blockState = world.func_180495_p(pos);
        if ((Boolean)blockState.func_177229_b((IProperty)OPEN) != open) {
            world.func_180501_a(pos, (BlockState)blockState.func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(open)), 10);
            this.playOpenCloseSound(world, pos, open);
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos neighborPos, boolean moved) {
        pos = state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? pos : pos.func_177977_b();
        state = world.func_180495_p(pos);
        InfinityDoorBlockEntity blockEntity = (InfinityDoorBlockEntity)world.func_175625_s(pos);
        if (!state.func_196958_f() && !this.func_196260_a(state, (IWorldReader)world, pos)) {
            blockEntity.deleteLocalPortal();
            world.func_180501_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 35);
            world.func_175655_b(pos, true);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        if (!((Boolean)DOFConfig.getInstance().requireDoorBorder.get()).booleanValue()) {
            BlockPos blockPos = pos.func_177977_b();
            BlockState blockState = world.func_180495_p(blockPos);
            if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
                return blockState.func_224755_d((IBlockReader)world, blockPos, Direction.UP);
            }
            return blockState.func_177230_c() == this;
        }
        pos = state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? pos : pos.func_177977_b();
        return this.topAndBottomMatch(pos, world) && (this.sideMatches(pos, world, Direction.NORTH) && this.sideMatches(pos, world, Direction.SOUTH) || this.sideMatches(pos, world, Direction.EAST) && this.sideMatches(pos, world, Direction.WEST));
    }

    private boolean topAndBottomMatch(BlockPos pos, IWorldReader world) {
        Predicate<Block> matchingBlocks = block -> block == DOFBlocks.BLOCK_OF_INFINITY.get() || block == DOFBlocks.GENERATED_BLOCK_OF_INFINITY.get();
        return matchingBlocks.test(world.func_180495_p(pos.func_177977_b()).func_177230_c()) && matchingBlocks.test(world.func_180495_p(pos.func_177981_b(2)).func_177230_c());
    }

    private boolean sideMatches(BlockPos pos, IWorldReader world, Direction d) {
        Predicate<Block> matchingBlocks = block -> block == DOFBlocks.BLOCK_OF_INFINITY.get() || block == DOFBlocks.GENERATED_BLOCK_OF_INFINITY.get();
        BlockPos sidePos = pos.func_177971_a(d.func_176730_m());
        return matchingBlocks.test(world.func_180495_p(sidePos).func_177230_c()) && matchingBlocks.test(world.func_180495_p(sidePos.func_177984_a()).func_177230_c());
    }

    private void playOpenCloseSound(World world, BlockPos pos, boolean open) {
        world.func_217378_a((PlayerEntity)null, open ? this.getCloseSound() : this.getOpenSound(), pos, 0);
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : (BlockState)state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING))).func_177231_a(HINGE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(BlockState state, BlockPos pos) {
        return MathHelper.func_180187_c((int)pos.func_177958_n(), (int)pos.func_177979_c(state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).func_177956_o(), (int)pos.func_177952_p());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{HALF, FACING, OPEN, HINGE});
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new InfinityDoorBlockEntity();
    }
}

