/*
 * Decompiled with CFR 0.152.
 */
package me.benfah.doorsofinfinity.block.entity;

import com.qouteall.immersive_portals.McHelper;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.portal.PortalManipulation;
import java.util.function.Function;
import me.benfah.doorsofinfinity.block.InfinityDoorBlock;
import me.benfah.doorsofinfinity.dimension.InfinityDimHelper;
import me.benfah.doorsofinfinity.init.DOFBlockEntities;
import me.benfah.doorsofinfinity.init.DOFBlocks;
import me.benfah.doorsofinfinity.init.DOFDimensions;
import me.benfah.doorsofinfinity.utils.BoxUtils;
import me.benfah.doorsofinfinity.utils.MCUtils;
import me.benfah.doorsofinfinity.utils.PortalCreationHelper;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;

public class InfinityDoorBlockEntity
extends TileEntity
implements ITickableTileEntity {
    public InfinityDimHelper.PersonalDimension link;
    public BlockPos syncDoorPos;
    public World syncDoorWorld;
    public Portal localPortal;
    public int installedUpgrades = 0;

    public InfinityDoorBlockEntity() {
        super((TileEntityType)DOFBlockEntities.INFINITY_DOOR.get());
    }

    public void syncWith(InfinityDoorBlockEntity entity) {
        int upgrades;
        entity.syncDoorPos = this.field_174879_c;
        entity.syncDoorWorld = this.field_145850_b;
        this.syncDoorPos = entity.field_174879_c;
        this.syncDoorWorld = entity.field_145850_b;
        this.installedUpgrades = upgrades = Math.max(entity.installedUpgrades, this.installedUpgrades);
        entity.installedUpgrades = upgrades;
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        entity.field_145850_b.func_184138_a(entity.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
    }

    public void updateSyncDoor() {
        if (this.isSyncPresent()) {
            this.syncDoorWorld.func_180501_a(this.syncDoorPos, (BlockState)((BlockState)this.getSyncEntity().func_145831_w().func_180495_p(this.getSyncEntity().func_174877_v()).func_206870_a(InfinityDoorBlock.HINGE, this.func_195044_w().func_177229_b(InfinityDoorBlock.HINGE))).func_206870_a((IProperty)InfinityDoorBlock.OPEN, this.func_195044_w().func_177229_b((IProperty)InfinityDoorBlock.OPEN)), 10);
            if (MCUtils.immersivePortalsPresent && this.field_145850_b.func_201675_m().func_186058_p() == DOFDimensions.INFINITY_DIM && this.field_145850_b.func_175647_a(Portal.class, BoxUtils.getBoxInclusive(this.field_174879_c, this.field_174879_c.func_177984_a()), null).isEmpty()) {
                this.deleteSyncPortal();
                PortalManipulation.completeBiWayPortal((Portal)this.getSyncEntity().localPortal, (EntityType)Portal.entityType);
            }
        }
    }

    public boolean isSyncPresent() {
        return this.syncDoorPos != null && this.syncDoorWorld != null && !this.syncDoorWorld.func_180495_p(this.syncDoorPos).func_196958_f();
    }

    public void deleteLocalPortal() {
        this.deletePortals(this.field_145850_b, this.field_174879_c);
    }

    public void deleteSyncPortal() {
        this.deletePortals(this.syncDoorWorld, this.syncDoorPos);
    }

    private void deletePortals(World world, BlockPos pos) {
        world.func_175647_a(Portal.class, BoxUtils.getBoxInclusive(pos, pos.func_177984_a()), null).forEach(portal -> portal.func_70106_y());
    }

    public void createSyncedPortals() {
        Direction direction = (Direction)this.func_195044_w().func_177229_b((IProperty)InfinityDoorBlock.FACING);
        Direction rightDirection = Direction.func_176731_b((int)(direction.func_176736_b() + 1));
        Vec3d portalPos = new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 1.0, 0.5);
        Quaternion rot = new Quaternion(Vector3f.field_229181_d_, (float)(direction.func_176734_d().func_176736_b() * 90), true);
        InfinityDimHelper.PersonalDimension personalDim = this.getOrCreateLinkedDimension();
        if (MCUtils.immersivePortalsPresent) {
            this.deleteSyncPortal();
            this.localPortal = PortalCreationHelper.spawn(this.field_145850_b, portalPos, 1.0, 2.0, rightDirection, DOFDimensions.INFINITY_DIM, personalDim.getPlayerPosCentered().func_72441_c(0.0, 1.0, 0.0), true, rot);
        }
        this.updateSyncDoor();
    }

    public void placeSyncedDoor(World otherWorld, BlockPos otherPos) {
        BlockState state = this.func_195044_w();
        otherWorld.func_175656_a(otherPos, (BlockState)((BlockState)((BlockState)((InfinityDoorBlock)DOFBlocks.GENERATED_INFINITY_DOOR.get()).func_176223_P().func_206870_a(InfinityDoorBlock.HINGE, state.func_177229_b(InfinityDoorBlock.HINGE))).func_206870_a((IProperty)InfinityDoorBlock.FACING, (Comparable)(MCUtils.immersivePortalsPresent ? Direction.NORTH : Direction.SOUTH))).func_206870_a(InfinityDoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        otherWorld.func_175656_a(otherPos.func_177984_a(), (BlockState)((BlockState)((BlockState)((InfinityDoorBlock)DOFBlocks.GENERATED_INFINITY_DOOR.get()).func_176223_P().func_206870_a(InfinityDoorBlock.HINGE, state.func_177229_b(InfinityDoorBlock.HINGE))).func_206870_a((IProperty)InfinityDoorBlock.FACING, (Comparable)(MCUtils.immersivePortalsPresent ? Direction.NORTH : Direction.SOUTH))).func_206870_a(InfinityDoorBlock.HALF, (Comparable)DoubleBlockHalf.UPPER));
        InfinityDoorBlockEntity dimInfinityDoor = (InfinityDoorBlockEntity)otherWorld.func_175625_s(otherPos);
        this.syncWith(dimInfinityDoor);
        this.createSyncedPortals();
    }

    public void sync() {
        this.syncWith(this.getSyncEntity());
    }

    public InfinityDoorBlockEntity getSyncEntity() {
        if (this.syncDoorWorld == null) {
            return null;
        }
        return (InfinityDoorBlockEntity)this.syncDoorWorld.func_175625_s(this.syncDoorPos);
    }

    public InfinityDimHelper.PersonalDimension getOrCreateLinkedDimension() {
        if (this.link == null) {
            this.link = InfinityDimHelper.getEmptyPersonalDimension(this.field_145850_b.func_73046_m());
            this.link.generate();
        }
        return this.link;
    }

    private CompoundNBT writeClientData(CompoundNBT compound) {
        compound.func_74768_a("Upgrades", this.installedUpgrades);
        return compound;
    }

    private void readClientData(CompoundNBT compound) {
        this.installedUpgrades = compound.func_74762_e("Upgrades");
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.writeClientData(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.readClientData(pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.writeClientData(super.func_189517_E_());
    }

    public void handleUpdateTag(CompoundNBT tag) {
        super.handleUpdateTag(tag);
        this.readClientData(tag);
    }

    public void func_145839_a(CompoundNBT tag) {
        if (tag.func_74764_b("SyncDoorDimId")) {
            this.syncDoorWorld = McHelper.getServer().func_71218_a(DimensionType.func_186069_a((int)tag.func_74762_e("SyncDoorDimId")));
            this.syncDoorPos = new BlockPos(tag.func_74762_e("SyncDoorX"), tag.func_74762_e("SyncDoorY"), tag.func_74762_e("SyncDoorZ"));
        }
        if (tag.func_74764_b("Upgrades")) {
            this.installedUpgrades = tag.func_74762_e("Upgrades");
        }
        if (tag.func_74764_b("DimOffset")) {
            this.link = InfinityDimHelper.getPersonalDimension(tag.func_74762_e("DimOffset"), this.installedUpgrades, McHelper.getServer());
        }
        super.func_145839_a(tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        if (this.link != null) {
            tag.func_74768_a("DimOffset", this.link.getDimensionOffset());
        }
        if (this.syncDoorWorld != null) {
            tag.func_74768_a("SyncDoorDimId", this.syncDoorWorld.func_201675_m().func_186058_p().func_186068_a());
            tag.func_74768_a("SyncDoorX", this.syncDoorPos.func_177958_n());
            tag.func_74768_a("SyncDoorY", this.syncDoorPos.func_177956_o());
            tag.func_74768_a("SyncDoorZ", this.syncDoorPos.func_177952_p());
        }
        tag.func_74768_a("Upgrades", this.installedUpgrades);
        return super.func_189515_b(tag);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && !MCUtils.immersivePortalsPresent && this.func_195044_w().func_177229_b(InfinityDoorBlock.HALF) == DoubleBlockHalf.LOWER && this.syncDoorWorld != null) {
            this.field_145850_b.func_217357_a(PlayerEntity.class, BoxUtils.getBoxInclusive(this.field_174879_c, this.field_174879_c.func_177984_a())).forEach(entity -> entity.changeDimension(this.syncDoorWorld.func_201675_m().func_186058_p(), new ITeleporter(){

                public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                    if (InfinityDoorBlockEntity.this.link != null) {
                        Vec3d pos = InfinityDoorBlockEntity.this.link.getPlayerPosCentered().func_72441_c(0.0, 0.0, -1.0);
                        entity.func_70080_a(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), 180.0f, 0.0f);
                        return entity;
                    }
                    Direction facing = (Direction)InfinityDoorBlockEntity.this.getSyncEntity().func_195044_w().func_177229_b((IProperty)InfinityDoorBlock.FACING);
                    BlockPos pos = InfinityDoorBlockEntity.this.syncDoorPos.func_177971_a(facing.func_176734_d().func_176730_m());
                    entity.func_70080_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 180.0f, 0.0f);
                    return entity;
                }
            }));
        }
    }
}

