/*
 * Decompiled with CFR 0.152.
 */
package me.benfah.doorsofinfinity.block.entity.renderer;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import me.benfah.doorsofinfinity.block.InfinityDoorBlock;
import me.benfah.doorsofinfinity.block.entity.InfinityDoorBlockEntity;
import me.benfah.doorsofinfinity.utils.MCUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.dispenser.IPosition;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TranslationTextComponent;

public class InfinityDoorBlockEntityRenderer
extends TileEntityRenderer<InfinityDoorBlockEntity> {
    private static Random RANDOM = (Random)Util.func_200696_a((Object)new Random(), r -> r.setSeed(31100L));
    private static final List<RenderType> endLayers = (List)IntStream.range(0, 16).mapToObj(i -> RenderType.func_228630_a_((int)(i + 1))).collect(ImmutableList.toImmutableList());
    private static Minecraft client = Minecraft.func_71410_x();

    public InfinityDoorBlockEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public static RenderType getOwnRenderLayer() {
        RenderType.State params = RenderType.State.func_228694_a_().func_228726_a_(new RenderState.TransparencyState("translucent_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.defaultBlendFunc();
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.disableAlphaTest();
        })).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"colored_upgrade", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)params);
    }

    public void render(InfinityDoorBlockEntity entity, float tickDelta, MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, int overlay) {
        BlockRayTraceResult blockHitResult;
        Direction direction = (Direction)entity.func_195044_w().func_177229_b((IProperty)InfinityDoorBlock.FACING);
        if (!MCUtils.immersivePortalsPresent) {
            this.drawEndTexture(entity, tickDelta, matrices, vertexConsumers, direction);
        }
        RayTraceResult rayTrace = InfinityDoorBlockEntityRenderer.client.field_71439_g.func_213324_a((double)InfinityDoorBlockEntityRenderer.client.field_71442_b.func_78757_d(), tickDelta, false);
        if (InfinityDoorBlockEntityRenderer.client.field_71439_g.func_213453_ef() && entity.func_195044_w().func_177229_b(InfinityDoorBlock.HALF) == DoubleBlockHalf.LOWER && ((blockHitResult = (BlockRayTraceResult)rayTrace).func_216350_a().equals((Object)entity.func_174877_v()) || blockHitResult.func_216350_a().equals((Object)entity.func_174877_v().func_177984_a()))) {
            matrices.func_227860_a_();
            InfinityDoorBlockEntityRenderer.transformToFace(matrices, direction);
            matrices.func_227861_a_(0.5, 1.9, -0.001);
            matrices.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            matrices.func_227862_a_(0.01f, 0.01f, 1.0f);
            this.drawCenteredTextWithRect(new TranslationTextComponent("text.doorsofinfinity.installed_upgrades", new Object[]{entity.installedUpgrades}).func_150254_d(), 0, 0xFFFFFF, false, matrices.func_227866_c_().func_227870_a_(), vertexConsumers, false, 0xFFFFFF, light, 0.168f, 0.341f, 0.156f, 0.5f);
            matrices.func_227865_b_();
        }
    }

    public static void drawRect(IRenderTypeBuffer vertexConsumerProvider, Matrix4f matrix, int x1, int y1, int x2, int y2, float r, float g, float b, float a) {
        IVertexBuilder consumer = vertexConsumerProvider.getBuffer(InfinityDoorBlockEntityRenderer.getOwnRenderLayer());
        consumer.func_227888_a_(matrix, (float)x1, (float)y2, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        consumer.func_227888_a_(matrix, (float)x2, (float)y2, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        consumer.func_227888_a_(matrix, (float)x2, (float)y1, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        consumer.func_227888_a_(matrix, (float)x1, (float)y1, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void transformToFace(MatrixStack stack, Direction direction) {
        stack.func_227861_a_(0.5, 0.0, 0.5);
        Quaternion rotationQuaternion = direction.func_229384_a_();
        rotationQuaternion.func_195890_a(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
        stack.func_227863_a_(rotationQuaternion);
        stack.func_227861_a_(-0.5, 0.0, -0.5);
    }

    public void drawRightBoundText(String text, int x, int y, int color, boolean shadow, Matrix4f matrix, IRenderTypeBuffer vertexConsumers, boolean seeThrough, int backgroundColor, int light) {
        int textLength = this.field_228858_b_.func_147548_a().func_78256_a(text);
        this.field_228858_b_.func_147548_a().func_228079_a_(text, (float)(x - textLength), (float)y, color, shadow, matrix, vertexConsumers, seeThrough, backgroundColor, light);
    }

    public void drawCenteredText(String text, int y, int color, boolean shadow, Matrix4f matrix, IRenderTypeBuffer vertexConsumers, boolean seeThrough, int backgroundColor, int light) {
        int textLength = this.field_228858_b_.func_147548_a().func_78256_a(text);
        this.field_228858_b_.func_147548_a().func_228079_a_(text, (float)(-textLength / 2), (float)y, color, shadow, matrix, vertexConsumers, seeThrough, backgroundColor, light);
    }

    public void drawCenteredTextWithRect(String text, int y, int color, boolean shadow, Matrix4f matrix, IRenderTypeBuffer vertexConsumers, boolean seeThrough, int backgroundColor, int light, float r, float g, float b, float a) {
        int textLength = this.field_228858_b_.func_147548_a().func_78256_a(text);
        int border = 4;
        int n = -textLength / 2 - border;
        int n2 = textLength / 2 + border;
        this.field_228858_b_.func_147548_a().getClass();
        InfinityDoorBlockEntityRenderer.drawRect(vertexConsumers, matrix, n, y - 2, n2, y + 9 + 2, r, g, b, a);
        this.drawCenteredText(text, y, color, shadow, matrix, vertexConsumers, seeThrough, backgroundColor, light);
    }

    public void drawRightBoundTextWithRect(String text, int x, int y, int color, boolean shadow, Matrix4f matrix, IRenderTypeBuffer vertexConsumers, boolean seeThrough, int backgroundColor, int light, float r, float g, float b, float a) {
        int border = 4;
        int textLength = this.field_228858_b_.func_147548_a().func_78256_a(text);
        this.field_228858_b_.func_147548_a().getClass();
        InfinityDoorBlockEntityRenderer.drawRect(vertexConsumers, matrix, x - textLength - border * 2, y - 2, x, y + 9 + 2, r, g, b, a);
        this.drawRightBoundText(text, x - border, y, color, shadow, matrix, vertexConsumers, seeThrough, backgroundColor, light);
    }

    public void drawEndTexture(InfinityDoorBlockEntity endPortalBlockEntity, float f, MatrixStack matrixStack, IRenderTypeBuffer vertexConsumerProvider, Direction direction) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)direction.func_176730_m().func_177958_n() * 0.1, 0.0, (double)direction.func_176730_m().func_177952_p() * 0.1);
        RANDOM.setSeed(31100L);
        double d = endPortalBlockEntity.func_174877_v().func_218138_a((IPosition)this.field_228858_b_.field_217666_g.func_216785_c(), true);
        int k = this.getLayersToRender(d);
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        this.drawEndLayer(endPortalBlockEntity, 0.15f, matrix4f, vertexConsumerProvider.getBuffer(endLayers.get(0)));
        for (int l = 1; l < 16; ++l) {
            this.drawEndLayer(endPortalBlockEntity, 2.0f / (float)(18 - l), matrix4f, vertexConsumerProvider.getBuffer(endLayers.get(l)));
        }
        matrixStack.func_227865_b_();
    }

    private void drawEndLayer(InfinityDoorBlockEntity endPortalBlockEntity, float g, Matrix4f matrix4f, IVertexBuilder vertexConsumer) {
        float h = (RANDOM.nextFloat() * 0.5f + 0.1f) * g;
        float i = (RANDOM.nextFloat() * 0.5f + 0.4f) * g;
        float j = (RANDOM.nextFloat() * 0.5f + 0.5f) * g;
        this.drawEndLayerFace(endPortalBlockEntity, matrix4f, vertexConsumer, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, h, i, j, Direction.SOUTH);
        this.drawEndLayerFace(endPortalBlockEntity, matrix4f, vertexConsumer, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, h, i, j, Direction.NORTH);
        this.drawEndLayerFace(endPortalBlockEntity, matrix4f, vertexConsumer, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, h, i, j, Direction.EAST);
        this.drawEndLayerFace(endPortalBlockEntity, matrix4f, vertexConsumer, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, h, i, j, Direction.WEST);
        this.drawEndLayerFace(endPortalBlockEntity, matrix4f, vertexConsumer, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, h, i, j, Direction.DOWN);
    }

    private void drawEndLayerFace(InfinityDoorBlockEntity endPortalBlockEntity, Matrix4f matrix4f, IVertexBuilder vertexConsumer, float f, float g, float h, float i, float j, float k, float l, float m, float n, float o, float p, Direction direction) {
        if (direction == ((Direction)endPortalBlockEntity.func_195044_w().func_177229_b((IProperty)InfinityDoorBlock.FACING)).func_176734_d()) {
            vertexConsumer.func_227888_a_(matrix4f, f, h, j).func_227885_a_(n, o, p, 1.0f).func_181675_d();
            vertexConsumer.func_227888_a_(matrix4f, g, h, k).func_227885_a_(n, o, p, 1.0f).func_181675_d();
            vertexConsumer.func_227888_a_(matrix4f, g, i, l).func_227885_a_(n, o, p, 1.0f).func_181675_d();
            vertexConsumer.func_227888_a_(matrix4f, f, i, m).func_227885_a_(n, o, p, 1.0f).func_181675_d();
        }
    }

    protected int getLayersToRender(double d) {
        if (d > 36864.0) {
            return 1;
        }
        if (d > 25600.0) {
            return 3;
        }
        if (d > 16384.0) {
            return 5;
        }
        if (d > 9216.0) {
            return 7;
        }
        if (d > 4096.0) {
            return 9;
        }
        if (d > 1024.0) {
            return 11;
        }
        if (d > 576.0) {
            return 13;
        }
        return d > 256.0 ? 14 : 15;
    }
}

