/*
 * Decompiled with CFR 0.152.
 */
package me.benfah.doorsofinfinity.dimension;

import java.util.function.Function;
import java.util.function.IntPredicate;
import me.benfah.doorsofinfinity.block.InfinityBlock;
import me.benfah.doorsofinfinity.block.entity.InfinityDoorBlockEntity;
import me.benfah.doorsofinfinity.config.DOFConfig;
import me.benfah.doorsofinfinity.init.DOFBlocks;
import me.benfah.doorsofinfinity.init.DOFDimensions;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class InfinityDimHelper {
    public static PersonalDimension getEmptyPersonalDimension(MinecraftServer server) {
        ServerWorld infinityDim = server.func_71218_a(DOFDimensions.INFINITY_DIM);
        BlockPos basePos = new BlockPos(0, 3, 0);
        int offset = 0;
        while (!infinityDim.func_180495_p(basePos.func_177982_a(offset * 200, 0, 0)).func_196958_f()) {
            ++offset;
        }
        return new PersonalDimension(offset, infinityDim);
    }

    public static PersonalDimension getPersonalDimension(int id, int upgrades, MinecraftServer server) {
        ServerWorld infinityDim = server.func_71218_a(DOFDimensions.INFINITY_DIM);
        return new PersonalDimension(id, upgrades, infinityDim);
    }

    public PersonalDimension getPersonalDimensionAt(BlockPos pos, MinecraftServer server) {
        return new PersonalDimension(pos.func_177958_n() / 200, server.func_71218_a(DOFDimensions.INFINITY_DIM));
    }

    public static ServerWorld getInfinityDimension(MinecraftServer server) {
        return server.func_71218_a(DOFDimensions.INFINITY_DIM);
    }

    public static class PersonalDimension {
        private static int INNER_SIZE = (Integer)DOFConfig.getInstance().dimensionSize.get();
        private static int WALL_THICKNESS = 2;
        private static int UPGRADE_MULTIPLIER = 8;
        private int dimId;
        private ServerWorld world;
        private int upgrades = 0;

        public PersonalDimension(int dimOffset, int upgrades, ServerWorld world) {
            this(dimOffset, world);
            this.upgrades = upgrades;
        }

        public PersonalDimension(int dimOffset, ServerWorld world) {
            this.dimId = dimOffset;
            this.world = world;
        }

        public Vec3d getBasePosition() {
            return new Vec3d((double)(200 * this.dimId), 3.0, 0.0);
        }

        public int getDimensionOffset() {
            return this.dimId;
        }

        public Vec3d getPlayerPosCentered() {
            return new Vec3d((Vec3i)this.getPlayerPos()).func_72441_c(0.5, 0.0, 0.5);
        }

        public int getInnerSize() {
            return INNER_SIZE + this.getUpgrades() * UPGRADE_MULTIPLIER;
        }

        public int getUpgrades() {
            return this.upgrades;
        }

        public boolean upgrade() {
            if (this.upgrades >= (Integer)DOFConfig.getInstance().maxUpgrades.get()) {
                return false;
            }
            int prevInnerSize = this.getInnerSize();
            InfinityDoorBlockEntity linkedBlockEntity = this.getBlockEntity().getSyncEntity();
            linkedBlockEntity.deleteLocalPortal();
            linkedBlockEntity.deleteSyncPortal();
            ++linkedBlockEntity.installedUpgrades;
            this.upgrades = linkedBlockEntity.installedUpgrades;
            this.generateCube(this.getBasePosition(), prevInnerSize, WALL_THICKNESS, vec -> {
                if (vec.func_177956_o() >= WALL_THICKNESS) {
                    return Blocks.field_150350_a.func_176223_P();
                }
                return (BlockState)((Block)DOFBlocks.GENERATED_BLOCK_OF_INFINITY.get()).func_176223_P().func_206870_a(InfinityBlock.COLOR, (Comparable)((Object)InfinityBlock.Color.WHITE));
            });
            this.generateCube(this.getBasePosition(), this.getInnerSize(), WALL_THICKNESS, vec -> {
                if (vec.func_177956_o() >= WALL_THICKNESS) {
                    return ((Block)DOFBlocks.GENERATED_BLOCK_OF_INFINITY.get()).func_176223_P();
                }
                return (BlockState)((Block)DOFBlocks.GENERATED_BLOCK_OF_INFINITY.get()).func_176223_P().func_206870_a(InfinityBlock.COLOR, (Comparable)((Object)InfinityBlock.Color.WHITE));
            });
            linkedBlockEntity.placeSyncedDoor((World)this.world, this.getPlayerPos());
            return true;
        }

        private InfinityDoorBlockEntity getBlockEntity() {
            return (InfinityDoorBlockEntity)this.world.func_175625_s(this.getPlayerPos());
        }

        public BlockPos getPlayerPos() {
            return new BlockPos(this.getBasePosition().func_72441_c(Math.floor(this.getInnerSize() / 2) + (double)WALL_THICKNESS, 3.0, (double)(this.getInnerSize() + WALL_THICKNESS)));
        }

        public void generate() {
            this.generateCube(this.getBasePosition(), this.getInnerSize(), WALL_THICKNESS, vec -> {
                if (vec.func_177956_o() >= WALL_THICKNESS) {
                    return ((Block)DOFBlocks.GENERATED_BLOCK_OF_INFINITY.get()).func_176223_P();
                }
                return (BlockState)((Block)DOFBlocks.GENERATED_BLOCK_OF_INFINITY.get()).func_176223_P().func_206870_a(InfinityBlock.COLOR, (Comparable)((Object)InfinityBlock.Color.WHITE));
            });
            this.resetDoor();
        }

        private void resetDoor() {
            BlockPos spawnPos = this.getPlayerPos();
            this.world.func_175656_a(spawnPos, Blocks.field_150350_a.func_176223_P());
            this.world.func_175656_a(spawnPos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
        }

        public void generateCube(Vec3d basePosition, int innerSize, int wallThickness, Function<Vec3i, BlockState> stateFunction) {
            for (int i = 0; i < innerSize + wallThickness * 2; ++i) {
                for (int j = 0; j < innerSize + wallThickness * 2; ++j) {
                    for (int k = 0; k < innerSize + wallThickness * 2; ++k) {
                        BlockState state;
                        BlockPos pos = new BlockPos(basePosition.field_72450_a + (double)i, basePosition.field_72448_b + (double)j, basePosition.field_72449_c + (double)k);
                        IntPredicate allowed = a -> a <= wallThickness - 1 || a >= innerSize + wallThickness;
                        if (!allowed.test(i) && !allowed.test(j) && !allowed.test(k) || (state = stateFunction.apply(new Vec3i(i, j, k))) == null) continue;
                        this.world.func_175656_a(pos, state);
                    }
                }
            }
        }
    }
}

