/*
 * Decompiled with CFR 0.152.
 */
package me.benfah.doorsofinfinity.utils;

import com.mojang.datafixers.util.Pair;
import com.qouteall.immersive_portals.my_util.IntBox;
import java.util.Comparator;
import java.util.IntSummaryStatistics;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class BoxUtils {
    public static AxisAlignedBB getBoxInclusive(BlockPos pos1, BlockPos pos2) {
        return new AxisAlignedBB(new Vec3d((double)pos1.func_177958_n(), (double)pos1.func_177956_o(), (double)pos1.func_177952_p()), new Vec3d((double)(pos2.func_177958_n() + 1), (double)(pos2.func_177956_o() + 1), (double)(pos2.func_177952_p() + 1)));
    }

    public static Pair<BlockPos, BlockPos> getAnchors(IntBox box) {
        BlockPos lowAnchorPos = box.stream().min(Comparator.comparingInt(Vec3i::func_177958_n).thenComparingInt(Vec3i::func_177956_o).thenComparingInt(Vec3i::func_177952_p)).get();
        BlockPos highAnchorPos = box.stream().min(Comparator.comparingInt(Vec3i::func_177958_n).thenComparingInt(Vec3i::func_177956_o).thenComparingInt(Vec3i::func_177952_p)).get();
        return new Pair((Object)lowAnchorPos, (Object)highAnchorPos);
    }

    public static CompoundNBT vecToTag(Vec3i vec3i) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("PosX", vec3i.func_177958_n());
        tag.func_74768_a("PosY", vec3i.func_177956_o());
        tag.func_74768_a("PosZ", vec3i.func_177952_p());
        return tag;
    }

    public static Vec3i vecFromTag(CompoundNBT vec3i) {
        int x = vec3i.func_74762_e("PosX");
        int y = vec3i.func_74762_e("PosY");
        int z = vec3i.func_74762_e("PosZ");
        return new Vec3i(x, y, z);
    }

    public static PlaneInfo getPlaneFromIntBox(IntBox box, Direction direction) {
        Direction rightDirection = Direction.func_176731_b((int)BoxUtils.getAbsoluteHorizontal(direction.func_176736_b() - 1));
        Vec3i axisH = Direction.UP.func_176730_m();
        Vec3i axisW = rightDirection.func_176730_m();
        Vec3i axisL = direction.func_176730_m();
        int height = box.stream().mapToInt(Vec3i::func_177956_o).max().getAsInt() - box.stream().mapToInt(Vec3i::func_177956_o).min().getAsInt() + 1;
        IntSummaryStatistics widthStream = box.stream().mapToInt(pos -> rightDirection.func_176740_k().func_196052_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())).summaryStatistics();
        int width = widthStream.getMax() - widthStream.getMin() + 1;
        int x = box.stream().map(Vec3i::func_177958_n).min((i1, i2) -> axisW.func_177958_n() == 0 ? Integer.compare(i1 * axisL.func_177958_n(), i2 * axisL.func_177958_n()) : Integer.compare(i1 * axisW.func_177958_n(), i2 * axisW.func_177958_n())).get();
        int y = box.stream().mapToInt(Vec3i::func_177956_o).min().getAsInt();
        int z = box.stream().map(Vec3i::func_177952_p).min((i1, i2) -> axisW.func_177952_p() == 0 ? Integer.compare(i1 * axisL.func_177952_p(), i2 * axisL.func_177952_p()) : Integer.compare(i1 * axisW.func_177952_p(), i2 * axisW.func_177952_p())).get();
        return new PlaneInfo(axisW, axisH, width, height, new BlockPos(x, y, z));
    }

    public static <T extends Comparable<T>> boolean hasSamePropertyValue(IProperty<T> property, BlockState toCompare, T value) {
        Optional<IProperty> optional = toCompare.func_206869_a().stream().filter(compProp -> compProp.equals(property)).findAny();
        if (optional.isPresent()) {
            return optional.get().equals(property) && toCompare.func_177229_b(property).equals(value);
        }
        return false;
    }

    public static int getAbsoluteHorizontal(int horizontal) {
        return horizontal < 0 ? horizontal + 4 : horizontal;
    }

    public static class PlaneInfo {
        public Vec3i axisW;
        public Vec3i axisH;
        public int width;
        public int height;
        public BlockPos pos;

        public PlaneInfo(Vec3i axisW, Vec3i axisH, int width, int height, BlockPos pos) {
            this.axisW = axisW;
            this.axisH = axisH;
            this.width = width;
            this.height = height;
            this.pos = pos;
        }

        public PlaneInfo(CompoundNBT tag) {
            this.axisW = BoxUtils.vecFromTag(tag.func_74775_l("AxisW"));
            this.axisH = BoxUtils.vecFromTag(tag.func_74775_l("AxisH"));
            this.width = tag.func_74762_e("Width");
            this.height = tag.func_74762_e("Height");
            this.pos = new BlockPos(BoxUtils.vecFromTag(tag.func_74775_l("StartPos")));
        }

        public CompoundNBT toCompound(CompoundNBT tag) {
            tag.func_218657_a("AxisW", (INBT)BoxUtils.vecToTag(this.axisW));
            tag.func_218657_a("AxisH", (INBT)BoxUtils.vecToTag(this.axisH));
            tag.func_74768_a("Width", this.width);
            tag.func_74768_a("Height", this.height);
            tag.func_218657_a("StartPos", (INBT)BoxUtils.vecToTag((Vec3i)this.pos));
            return tag;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PlaneInfo) {
                PlaneInfo toCompare = (PlaneInfo)obj;
                return toCompare.height == this.height && toCompare.width == this.width;
            }
            return false;
        }
    }
}

