/*
 * Decompiled with CFR 0.152.
 */
package me.benfah.doorsofinfinity.utils;

import com.qouteall.immersive_portals.my_util.IntBox;
import com.qouteall.immersive_portals.portal.Portal;
import com.qouteall.immersive_portals.portal.PortalManipulation;
import me.benfah.doorsofinfinity.entity.BreakablePortal;
import me.benfah.doorsofinfinity.init.DOFEntities;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;

public class PortalCreationHelper {
    public static Portal spawn(World world, Vec3d pos, double width, double height, Vec3i axisW, Vec3i axisH, DimensionType dimensionTo, Vec3d dest, boolean teleportable, Quaternion rot, boolean biWay) {
        Portal portal = new Portal(Portal.entityType, world);
        portal.width = width;
        portal.height = height;
        portal.axisH = new Vec3d(axisH);
        portal.axisW = new Vec3d(axisW);
        portal.dimensionTo = dimensionTo;
        portal.destination = dest;
        portal.teleportable = teleportable;
        portal.cullableXEnd = 0.0;
        portal.cullableYEnd = 0.0;
        portal.cullableXStart = 0.0;
        portal.cullableYStart = 0.0;
        if (rot != null) {
            portal.rotation = rot;
        }
        portal.func_70107_b(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c());
        world.func_217376_c((Entity)portal);
        if (biWay) {
            PortalManipulation.completeBiWayPortal((Portal)portal, (EntityType)Portal.entityType);
        }
        return portal;
    }

    public static BreakablePortal spawnBreakable(World world, Vec3d pos, double width, double height, Vec3i axisW, Vec3i axisH, DimensionType dimensionTo, Vec3d dest, boolean teleportable, Quaternion rot, boolean biWay, IntBox transmitterBox, IntBox glassBox, World transmitterWorld) {
        BreakablePortal portal = new BreakablePortal((EntityType<BreakablePortal>)((EntityType)DOFEntities.BREAKABLE_PORTAL.get()), world);
        portal.width = width;
        portal.height = height;
        portal.axisH = new Vec3d(axisH);
        portal.axisW = new Vec3d(axisW);
        portal.dimensionTo = dimensionTo;
        portal.destination = dest;
        portal.teleportable = teleportable;
        portal.cullableXEnd = 0.0;
        portal.cullableYEnd = 0.0;
        portal.cullableXStart = 0.0;
        portal.cullableYStart = 0.0;
        portal.transmitterArea = transmitterBox;
        portal.transmitterWorld = transmitterWorld;
        portal.glassArea = glassBox;
        if (rot != null) {
            portal.rotation = rot;
        }
        portal.func_70107_b(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c());
        world.func_217376_c((Entity)portal);
        if (biWay) {
            PortalManipulation.completeBiWayPortal((Portal)portal, (EntityType)Portal.entityType);
        }
        return portal;
    }

    public static Portal spawn(World world, Vec3d pos, double width, double height, Direction axisW, DimensionType dimensionTo, Vec3d dest, boolean teleportable, Quaternion rot, boolean biWay) {
        return PortalCreationHelper.spawn(world, pos, width, height, axisW.func_176730_m(), Direction.UP.func_176730_m(), dimensionTo, dest, teleportable, rot, biWay);
    }

    public static Portal spawn(World world, Vec3d pos, double width, double height, Direction axisW, DimensionType dimensionTo, Vec3d dest, boolean teleportable, Quaternion rot) {
        return PortalCreationHelper.spawn(world, pos, width, height, axisW.func_176730_m(), Direction.UP.func_176730_m(), dimensionTo, dest, teleportable, rot, true);
    }
}

