/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api;

import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.api.support.ISlabSupport;
import cjminecraft.doubleslabs.api.support.IVerticalSlabSupport;
import cjminecraft.doubleslabs.api.support.SlabSupportProvider;
import cjminecraft.doubleslabs.common.DoubleSlabs;
import cjminecraft.doubleslabs.common.config.DSConfig;
import cjminecraft.doubleslabs.common.util.AnnotationUtil;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SlabSupport {
    private static List<IVerticalSlabSupport> verticalSlabSupports;
    private static List<IHorizontalSlabSupport> horizontalSlabSupports;

    public static void load() {
        verticalSlabSupports = AnnotationUtil.getClassInstances(SlabSupportProvider.class, IVerticalSlabSupport.class, AnnotationUtil.MODID_PREDICATE, Comparator.comparingInt(a -> a.getAnnotationData().getOrDefault("priority", 1000)));
        horizontalSlabSupports = AnnotationUtil.getClassInstances(SlabSupportProvider.class, IHorizontalSlabSupport.class, AnnotationUtil.MODID_PREDICATE, Comparator.comparingInt(a -> a.getAnnotationData().getOrDefault("priority", 1000)));
        DoubleSlabs.LOGGER.info("Loaded %s vertical slab support classes", (Object)verticalSlabSupports.size());
        DoubleSlabs.LOGGER.info("Loaded %s horizontal slab support classes", (Object)horizontalSlabSupports.size());
    }

    @Nullable
    public static IVerticalSlabSupport getVerticalSlabSupport(IBlockReader world, BlockPos pos, BlockState state) {
        if (state == null) {
            return null;
        }
        if (state.func_177230_c() instanceof IVerticalSlabSupport && ((IVerticalSlabSupport)state.func_177230_c()).isVerticalSlab(world, pos, state)) {
            return (IVerticalSlabSupport)state.func_177230_c();
        }
        for (IVerticalSlabSupport support : verticalSlabSupports) {
            if (!support.isVerticalSlab(world, pos, state)) continue;
            return support;
        }
        return null;
    }

    @Nullable
    public static IVerticalSlabSupport getVerticalSlabSupport(ItemStack stack, PlayerEntity player, Hand hand) {
        if (stack.func_77973_b() instanceof IVerticalSlabSupport && ((IVerticalSlabSupport)stack.func_77973_b()).isVerticalSlab(stack, player, hand)) {
            return (IVerticalSlabSupport)stack.func_77973_b();
        }
        if (stack.func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d() instanceof IVerticalSlabSupport && ((IVerticalSlabSupport)((BlockItem)stack.func_77973_b()).func_179223_d()).isVerticalSlab(stack, player, hand)) {
            return (IVerticalSlabSupport)((BlockItem)stack.func_77973_b()).func_179223_d();
        }
        for (IVerticalSlabSupport support : verticalSlabSupports) {
            if (!support.isVerticalSlab(stack, player, hand)) continue;
            return support;
        }
        return null;
    }

    @Nullable
    public static IHorizontalSlabSupport getHorizontalSlabSupport(IBlockReader world, BlockPos pos, BlockState state) {
        if (state == null) {
            return null;
        }
        if (state.func_177230_c() instanceof IHorizontalSlabSupport && ((IHorizontalSlabSupport)state.func_177230_c()).isHorizontalSlab(world, pos, state)) {
            return (IHorizontalSlabSupport)state.func_177230_c();
        }
        for (IHorizontalSlabSupport support : horizontalSlabSupports) {
            if (!support.isHorizontalSlab(world, pos, state)) continue;
            return support;
        }
        return null;
    }

    @Nullable
    public static IHorizontalSlabSupport getHorizontalSlabSupport(ItemStack stack, PlayerEntity player, Hand hand) {
        if (stack.func_77973_b() instanceof IHorizontalSlabSupport && ((IHorizontalSlabSupport)stack.func_77973_b()).isHorizontalSlab(stack, player, hand)) {
            return (IHorizontalSlabSupport)stack.func_77973_b();
        }
        if (stack.func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d() instanceof IHorizontalSlabSupport && ((IHorizontalSlabSupport)((BlockItem)stack.func_77973_b()).func_179223_d()).isHorizontalSlab(stack, player, hand)) {
            return (IHorizontalSlabSupport)((BlockItem)stack.func_77973_b()).func_179223_d();
        }
        for (IHorizontalSlabSupport support : horizontalSlabSupports) {
            if (!support.isHorizontalSlab(stack, player, hand)) continue;
            return support;
        }
        return null;
    }

    public static boolean isHorizontalSlab(Item item) {
        if (item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof IHorizontalSlabSupport) {
            return ((IHorizontalSlabSupport)((BlockItem)item).func_179223_d()).isHorizontalSlab(item);
        }
        for (IHorizontalSlabSupport support : horizontalSlabSupports) {
            if (!support.isHorizontalSlab(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHorizontalSlab(Block block) {
        if (DSConfig.SERVER.isBlacklistedHorizontalSlab(block)) {
            return false;
        }
        if (block instanceof IHorizontalSlabSupport) {
            return true;
        }
        for (IHorizontalSlabSupport support : horizontalSlabSupports) {
            if (!support.isHorizontalSlab(block)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static IHorizontalSlabSupport getHorizontalSlabSupport(Block block) {
        if (DSConfig.SERVER.isBlacklistedHorizontalSlab(block)) {
            return null;
        }
        if (block instanceof IHorizontalSlabSupport) {
            return (IHorizontalSlabSupport)block;
        }
        for (IHorizontalSlabSupport support : horizontalSlabSupports) {
            if (!support.isHorizontalSlab(block)) continue;
            return support;
        }
        return null;
    }

    @Nullable
    public static ISlabSupport getSlabSupport(IBlockReader world, BlockPos pos, BlockState state) {
        IHorizontalSlabSupport horizontalSlabSupport = SlabSupport.getHorizontalSlabSupport(world, pos, state);
        return horizontalSlabSupport != null ? horizontalSlabSupport : SlabSupport.getVerticalSlabSupport(world, pos, state);
    }

    @Nullable
    public static ISlabSupport getSlabSupport(ItemStack stack, PlayerEntity player, Hand hand) {
        IHorizontalSlabSupport horizontalSlabSupport = SlabSupport.getHorizontalSlabSupport(stack, player, hand);
        return horizontalSlabSupport != null ? horizontalSlabSupport : SlabSupport.getVerticalSlabSupport(stack, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BlockState getSlabForType(BlockState state, IBlockReader world, BlockPos pos, SlabType type) {
        IHorizontalSlabSupport horizontalSupport = SlabSupport.getHorizontalSlabSupport(world, pos, state);
        if (horizontalSupport != null) {
            return horizontalSupport.getStateForHalf((IBlockReader)Minecraft.func_71410_x().field_71441_e, pos, state, type);
        }
        return state;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BlockState matchState(BlockState state1, BlockState state2, IBlockReader world, BlockPos pos1, BlockPos pos2) {
        IHorizontalSlabSupport horizontalSupport = SlabSupport.getHorizontalSlabSupport(world, pos1, state1);
        if (horizontalSupport != null) {
            IHorizontalSlabSupport otherSupport = SlabSupport.getHorizontalSlabSupport(world, pos2, state2);
            if (otherSupport != null) {
                return otherSupport.getStateForHalf(world, pos2, state2, horizontalSupport.getHalf(world, pos1, state1));
            }
        } else {
            IVerticalSlabSupport otherSupport;
            IVerticalSlabSupport verticalSupport = SlabSupport.getVerticalSlabSupport(world, pos1, state1);
            if (verticalSupport != null && (otherSupport = SlabSupport.getVerticalSlabSupport(world, pos2, state2)) != null) {
                return otherSupport.getStateForDirection(world, pos2, state2, verticalSupport.getDirection(world, pos1, state1));
            }
        }
        return state2;
    }
}

