/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api.support;

import cjminecraft.doubleslabs.api.support.IVerticalSlabSupport;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class VerticalSlabSupport<T extends Enum<T>>
implements IVerticalSlabSupport {
    protected final Class<?> verticalSlab;
    protected final EnumProperty<T> verticalSlabTypeProperty;
    protected final T[] verticalSlabTypes;

    public VerticalSlabSupport(String verticalSlabClassName, String verticalSlabPropertyName, String verticalSlabTypeEnumClassName) {
        Enum[] verticalSlabTypes;
        EnumProperty verticalSlabTypeProperty;
        Class<?> verticalSlab;
        try {
            verticalSlab = Class.forName(verticalSlabClassName);
            verticalSlabTypeProperty = (EnumProperty)verticalSlab.getField(verticalSlabPropertyName).get(null);
            Class<?> verticalSlabType = Class.forName(verticalSlabTypeEnumClassName);
            verticalSlabTypes = (Enum[])verticalSlabType.getEnumConstants();
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException ignored) {
            verticalSlab = null;
            verticalSlabTypeProperty = null;
            verticalSlabTypes = null;
        }
        this.verticalSlab = verticalSlab;
        this.verticalSlabTypeProperty = verticalSlabTypeProperty;
        this.verticalSlabTypes = verticalSlabTypes;
    }

    @Override
    public boolean isVerticalSlab(IBlockReader world, BlockPos pos, BlockState state) {
        return this.verticalSlab != null && this.verticalSlab.isAssignableFrom(state.func_177230_c().getClass()) && !((Enum)((Object)state.func_177229_b(this.verticalSlabTypeProperty))).equals(this.verticalSlabTypes[4]);
    }

    @Override
    public boolean isVerticalSlab(ItemStack stack, PlayerEntity player, Hand hand) {
        return this.verticalSlab != null && stack.func_77973_b() instanceof BlockItem && this.verticalSlab.isAssignableFrom(((BlockItem)stack.func_77973_b()).func_179223_d().getClass());
    }

    @Override
    public BlockState getStateForDirection(IBlockReader world, BlockPos pos, BlockState state, Direction direction) {
        return this.verticalSlab == null ? state : (BlockState)state.func_206870_a(this.verticalSlabTypeProperty, this.verticalSlabTypes[direction.func_176745_a() - 2]);
    }

    @Override
    public Direction getDirection(IBlockReader world, BlockPos pos, BlockState state) {
        if (this.verticalSlab == null) {
            return null;
        }
        Enum type = (Enum)((Object)state.func_177229_b(this.verticalSlabTypeProperty));
        if (type.equals(this.verticalSlabTypes[0])) {
            return Direction.NORTH;
        }
        if (type.equals(this.verticalSlabTypes[1])) {
            return Direction.SOUTH;
        }
        if (type.equals(this.verticalSlabTypes[2])) {
            return Direction.WEST;
        }
        return Direction.EAST;
    }
}

