/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api.support.lotr;

import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.api.support.IVerticalSlabSupport;
import cjminecraft.doubleslabs.api.support.SlabSupportProvider;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

@SlabSupportProvider(modid="lotr", priority=1)
public class LotrSlabSupport
implements IHorizontalSlabSupport,
IVerticalSlabSupport {
    private final Class<?> slab;
    private final EnumProperty<Direction.Axis> slabAxisProperty;

    public LotrSlabSupport() {
        EnumProperty slabAxisProperty;
        Class<?> slab;
        try {
            slab = Class.forName("lotr.common.block.AxialSlabBlock");
            slabAxisProperty = (EnumProperty)Class.forName("lotr.common.block.LOTRBlockStates").getField("SLAB_AXIS").get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException ignored) {
            slab = null;
            slabAxisProperty = null;
        }
        this.slab = slab;
        this.slabAxisProperty = slabAxisProperty;
    }

    @Override
    public boolean isHorizontalSlab(Item item) {
        return this.slab != null && item instanceof BlockItem && this.slab.isAssignableFrom(((BlockItem)item).func_179223_d().getClass());
    }

    @Override
    public boolean isHorizontalSlab(Block block) {
        return false;
    }

    @Override
    public SlabType getHalf(IBlockReader world, BlockPos pos, BlockState state) {
        return this.slab != null ? null : (SlabType)state.func_177229_b((Property)BlockStateProperties.field_208145_at);
    }

    @Override
    public BlockState getStateForHalf(BlockState state, SlabType half) {
        return (BlockState)((BlockState)state.func_206870_a(this.slabAxisProperty, (Comparable)Direction.Axis.Y)).func_206870_a((Property)BlockStateProperties.field_208145_at, (Comparable)half);
    }

    @Override
    public boolean isVerticalSlab(IBlockReader world, BlockPos pos, BlockState state) {
        return this.slab != null && this.slab.isAssignableFrom(state.func_177230_c().getClass()) && state.func_177229_b((Property)BlockStateProperties.field_208145_at) != SlabType.DOUBLE && state.func_177229_b(this.slabAxisProperty) != Direction.Axis.Y;
    }

    @Override
    public boolean isVerticalSlab(ItemStack stack, PlayerEntity player, Hand hand) {
        return false;
    }

    @Override
    public Direction getDirection(IBlockReader world, BlockPos pos, BlockState state) {
        Direction.Axis axis = (Direction.Axis)state.func_177229_b(this.slabAxisProperty);
        SlabType type = (SlabType)state.func_177229_b((Property)BlockStateProperties.field_208145_at);
        switch (axis) {
            case X: {
                return type == SlabType.BOTTOM ? Direction.NORTH : Direction.SOUTH;
            }
            case Z: {
                return type == SlabType.BOTTOM ? Direction.EAST : Direction.WEST;
            }
        }
        return null;
    }

    @Override
    public BlockState getStateForDirection(IBlockReader world, BlockPos pos, BlockState state, Direction direction) {
        switch (direction.func_176740_k()) {
            case X: {
                return (BlockState)((BlockState)state.func_206870_a(this.slabAxisProperty, (Comparable)Direction.Axis.X)).func_206870_a((Property)BlockStateProperties.field_208145_at, (Comparable)(direction.func_176743_c() == Direction.AxisDirection.POSITIVE ? SlabType.BOTTOM : SlabType.TOP));
            }
            case Z: {
                return (BlockState)((BlockState)state.func_206870_a(this.slabAxisProperty, (Comparable)Direction.Axis.Z)).func_206870_a((Property)BlockStateProperties.field_208145_at, (Comparable)(direction.func_176743_c() == Direction.AxisDirection.POSITIVE ? SlabType.TOP : SlabType.BOTTOM));
            }
        }
        return state;
    }
}

