/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client;

import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.client.proxy.ClientProxy;
import cjminecraft.doubleslabs.common.DoubleSlabs;
import cjminecraft.doubleslabs.common.blocks.RaisedCampfireBlock;
import cjminecraft.doubleslabs.common.config.DSConfig;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.Variant;
import net.minecraft.client.renderer.model.VariantList;
import net.minecraft.client.renderer.model.WeightedBakedModel;
import net.minecraft.client.renderer.texture.SpriteMap;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientConstants {
    private static final Map<BlockState, Map<Direction, IBakedModel>> VERTICAL_SLAB_MODELS = Maps.newIdentityHashMap();
    private static final Map<Item, IBakedModel> VERTICAL_SLAB_ITEM_MODELS = Maps.newIdentityHashMap();
    private static final TransformationMatrix TRANSFORMATION_2D = new TransformationMatrix(null, Vector3f.field_229182_e_.func_229187_a_(90.0f), null, null);
    public static final int TINT_OFFSET = 1000;

    public static boolean isTransparent(BlockState state) {
        return !state.func_185904_a().func_76218_k() || !state.func_200132_m();
    }

    public static IBakedModel getFallbackModel() {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
    }

    public static IBakedModel getVerticalModel(BlockState state, Direction direction) {
        Map<Direction, IBakedModel> map = VERTICAL_SLAB_MODELS.get(state);
        if (map != null) {
            return map.getOrDefault(direction, ClientConstants.getFallbackModel());
        }
        return ClientConstants.getFallbackModel();
    }

    public static IBakedModel getVerticalModel(Item item) {
        return VERTICAL_SLAB_ITEM_MODELS.getOrDefault(item, ClientConstants.getFallbackModel());
    }

    public static IBakedModel bake(ModelLoader modelLoader, IUnbakedModel baseModel, ResourceLocation location, boolean uvlock, IModelTransform transform) {
        if (baseModel instanceof VariantList) {
            VariantList model = (VariantList)baseModel;
            if (model.func_188114_a().isEmpty()) {
                return null;
            }
            WeightedBakedModel.Builder builder = new WeightedBakedModel.Builder();
            for (Variant variant : model.func_188114_a()) {
                IBakedModel ibakedmodel = modelLoader.getBakedModel(variant.func_188046_a(), transform, arg_0 -> ((SpriteMap)modelLoader.getSpriteMap()).func_229151_a_(arg_0));
                builder.func_177677_a(ibakedmodel, variant.func_188047_d());
            }
            return builder.func_209614_a();
        }
        return baseModel.func_225613_a_((ModelBakery)modelLoader, arg_0 -> ((SpriteMap)modelLoader.getSpriteMap()).func_229151_a_(arg_0), transform, location);
    }

    public static void bakeVerticalSlabModels(ModelLoader modelLoader) {
        VERTICAL_SLAB_MODELS.clear();
        VERTICAL_SLAB_ITEM_MODELS.clear();
        ForgeRegistries.BLOCKS.forEach(block -> {
            IHorizontalSlabSupport support = SlabSupport.getHorizontalSlabSupport(block);
            if (support != null) {
                boolean uvlock;
                boolean raisedCampfire = block instanceof RaisedCampfireBlock;
                boolean bl = uvlock = support.uvlock((Block)block) && DSConfig.CLIENT.uvlock((Block)block);
                if (uvlock && !raisedCampfire) {
                    BlockState doubleState = support.getStateForHalf(block.func_176223_P(), SlabType.DOUBLE);
                    BlockState topState = support.getStateForHalf(block.func_176223_P(), SlabType.TOP);
                    BlockState bottomState = support.getStateForHalf(block.func_176223_P(), SlabType.BOTTOM);
                    ModelResourceLocation doubleLocation = BlockModelShapes.func_209554_c((BlockState)doubleState);
                    ModelResourceLocation halfLocation = BlockModelShapes.func_209554_c((BlockState)topState);
                    IUnbakedModel doubleModel = modelLoader.func_209597_a((ResourceLocation)doubleLocation);
                    IUnbakedModel halfModel = modelLoader.func_209597_a((ResourceLocation)halfLocation);
                    EnumMap doubleMap = Maps.newEnumMap(Direction.class);
                    EnumMap topHalfMap = Maps.newEnumMap(Direction.class);
                    EnumMap bottomHalfMap = Maps.newEnumMap(Direction.class);
                    IBakedModel doubleBaked = ClientConstants.bake(modelLoader, doubleModel, (ResourceLocation)doubleLocation, true, (IModelTransform)new Variant((ResourceLocation)doubleLocation, ModelRotation.X90_Y0.func_225615_b_(), true, 1));
                    doubleMap.put(Direction.NORTH, doubleBaked);
                    doubleMap.put(Direction.EAST, doubleBaked);
                    doubleMap.put(Direction.SOUTH, doubleBaked);
                    doubleMap.put(Direction.WEST, doubleBaked);
                    IBakedModel northBaked = ClientConstants.bake(modelLoader, halfModel, (ResourceLocation)halfLocation, true, (IModelTransform)new Variant((ResourceLocation)halfLocation, ModelRotation.X90_Y180.func_225615_b_(), true, 1));
                    IBakedModel eastBaked = ClientConstants.bake(modelLoader, halfModel, (ResourceLocation)halfLocation, true, (IModelTransform)new Variant((ResourceLocation)halfLocation, ModelRotation.X90_Y270.func_225615_b_(), true, 1));
                    IBakedModel southBaked = ClientConstants.bake(modelLoader, halfModel, (ResourceLocation)halfLocation, true, (IModelTransform)new Variant((ResourceLocation)halfLocation, ModelRotation.X90_Y0.func_225615_b_(), true, 1));
                    IBakedModel westBaked = ClientConstants.bake(modelLoader, halfModel, (ResourceLocation)halfLocation, true, (IModelTransform)new Variant((ResourceLocation)halfLocation, ModelRotation.X90_Y90.func_225615_b_(), true, 1));
                    if (support.flipModelWhenVertical()) {
                        IBakedModel temp = northBaked;
                        northBaked = southBaked;
                        southBaked = temp;
                        temp = eastBaked;
                        eastBaked = westBaked;
                        westBaked = temp;
                    }
                    topHalfMap.put(Direction.NORTH, northBaked);
                    topHalfMap.put(Direction.EAST, eastBaked);
                    topHalfMap.put(Direction.SOUTH, southBaked);
                    topHalfMap.put(Direction.WEST, westBaked);
                    bottomHalfMap.put(Direction.NORTH, southBaked);
                    bottomHalfMap.put(Direction.EAST, westBaked);
                    bottomHalfMap.put(Direction.SOUTH, northBaked);
                    bottomHalfMap.put(Direction.WEST, eastBaked);
                    VERTICAL_SLAB_MODELS.put(doubleState, doubleMap);
                    VERTICAL_SLAB_MODELS.put(topState, topHalfMap);
                    VERTICAL_SLAB_MODELS.put(bottomState, bottomHalfMap);
                } else {
                    block.func_176194_O().func_177619_a().forEach(state -> {
                        ModelResourceLocation resourceLocation = BlockModelShapes.func_209554_c((BlockState)state);
                        try {
                            EnumMap map = Maps.newEnumMap(Direction.class);
                            IUnbakedModel model = modelLoader.func_209597_a((ResourceLocation)resourceLocation);
                            if (raisedCampfire) {
                                map.put(Direction.NORTH, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, uvlock, (IModelTransform)new Variant((ResourceLocation)resourceLocation, ModelRotation.X90_Y180.func_225615_b_().compose(ClientProxy.RAISED_CAMPFIRE_TRANSFORM), uvlock, 1)));
                                map.put(Direction.EAST, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, uvlock, (IModelTransform)new Variant((ResourceLocation)resourceLocation, ModelRotation.X90_Y270.func_225615_b_().compose(ClientProxy.RAISED_CAMPFIRE_TRANSFORM), uvlock, 1)));
                                map.put(Direction.SOUTH, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, uvlock, (IModelTransform)new Variant((ResourceLocation)resourceLocation, ModelRotation.X90_Y0.func_225615_b_().compose(ClientProxy.RAISED_CAMPFIRE_TRANSFORM), uvlock, 1)));
                                map.put(Direction.WEST, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, uvlock, (IModelTransform)new Variant((ResourceLocation)resourceLocation, ModelRotation.X90_Y90.func_225615_b_().compose(ClientProxy.RAISED_CAMPFIRE_TRANSFORM), uvlock, 1)));
                            } else {
                                map.put(Direction.NORTH, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, false, (IModelTransform)new Variant((ResourceLocation)resourceLocation, ModelRotation.X90_Y180.func_225615_b_(), false, 1)));
                                map.put(Direction.EAST, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, false, (IModelTransform)new Variant((ResourceLocation)resourceLocation, ModelRotation.X90_Y270.func_225615_b_(), false, 1)));
                                map.put(Direction.SOUTH, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, false, (IModelTransform)new Variant((ResourceLocation)resourceLocation, ModelRotation.X90_Y0.func_225615_b_(), false, 1)));
                                map.put(Direction.WEST, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, false, (IModelTransform)new Variant((ResourceLocation)resourceLocation, ModelRotation.X90_Y90.func_225615_b_(), false, 1)));
                            }
                            VERTICAL_SLAB_MODELS.put((BlockState)state, map);
                        }
                        catch (Exception e) {
                            DoubleSlabs.LOGGER.warn("Failed to generate vertical slab model for: {}", (Object)resourceLocation.toString());
                            DoubleSlabs.LOGGER.catching((Throwable)e);
                        }
                    });
                }
            }
        });
        ForgeRegistries.ITEMS.forEach(item -> {
            if (SlabSupport.isHorizontalSlab(item)) {
                boolean uvlock = item instanceof BlockItem ? DSConfig.CLIENT.uvlock(((BlockItem)item).func_179223_d()) : DSConfig.CLIENT.uvlock((Item)item);
                ModelResourceLocation resourceLocation = new ModelResourceLocation(Objects.requireNonNull(item.getRegistryName()), "inventory");
                try {
                    boolean is3d;
                    IUnbakedModel model = modelLoader.func_209597_a((ResourceLocation)resourceLocation);
                    boolean bl = is3d = model instanceof BlockModel && ((BlockModel)model).func_230176_c_().func_230178_a_();
                    if (is3d) {
                        VERTICAL_SLAB_ITEM_MODELS.put((Item)item, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, uvlock, (IModelTransform)new Variant((ResourceLocation)resourceLocation, ModelRotation.X90_Y0.func_225615_b_(), uvlock, 1)));
                    } else {
                        VERTICAL_SLAB_ITEM_MODELS.put((Item)item, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, uvlock, (IModelTransform)new Variant((ResourceLocation)resourceLocation, TRANSFORMATION_2D, uvlock, 1)));
                    }
                }
                catch (Exception e) {
                    DoubleSlabs.LOGGER.warn("Failed to generate vertical slab item model for: {}", (Object)resourceLocation.toString());
                    DoubleSlabs.LOGGER.catching((Throwable)e);
                }
            }
        });
        DoubleSlabs.LOGGER.debug("Loaded vertical slab models!");
    }
}

