/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.model;

import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.client.ClientConstants;
import cjminecraft.doubleslabs.common.config.DSConfig;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public abstract class DynamicSlabBakedModel
implements IDynamicBakedModel {
    public static final ModelProperty<IBlockInfo> NEGATIVE_BLOCK = new ModelProperty();
    public static final ModelProperty<IBlockInfo> POSITIVE_BLOCK = new ModelProperty();
    public static final ModelProperty<Boolean> RENDER_POSITIVE = new ModelProperty();

    public boolean func_177555_b() {
        return ClientConstants.getFallbackModel().func_177555_b();
    }

    public boolean func_177556_c() {
        return ClientConstants.getFallbackModel().func_177556_c();
    }

    public boolean func_230044_c_() {
        return ClientConstants.getFallbackModel().func_230044_c_();
    }

    public boolean func_188618_c() {
        return ClientConstants.getFallbackModel().func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return ClientConstants.getFallbackModel().func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return ClientConstants.getFallbackModel().func_188617_f();
    }

    public TextureAtlasSprite getParticleTexture(@Nonnull IModelData data) {
        if (data.hasProperty(POSITIVE_BLOCK) && data.getData(POSITIVE_BLOCK) != null && ((IBlockInfo)data.getData(POSITIVE_BLOCK)).getBlockState() != null) {
            return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(((IBlockInfo)data.getData(POSITIVE_BLOCK)).getBlockState()).getParticleTexture((IModelData)EmptyModelData.INSTANCE);
        }
        return ClientConstants.getFallbackModel().getParticleTexture((IModelData)EmptyModelData.INSTANCE);
    }

    protected boolean shouldCull(BlockState state, BlockState neighbour, Direction direction) {
        if (state == null || neighbour == null) {
            return false;
        }
        return state.func_200017_a(neighbour, direction) || !ClientConstants.isTransparent(state) && !ClientConstants.isTransparent(neighbour);
    }

    public static boolean useDoubleSlabModel(BlockState state1, BlockState state2) {
        return state1.func_177230_c() == state2.func_177230_c() && state2.getBlockState().func_203425_a(state2.func_177230_c()) && DSConfig.CLIENT.useDoubleSlabModel(state1.func_177230_c());
    }

    protected List<BakedQuad> getQuadsForState(IBlockInfo block, Direction side, Random rand) {
        BlockState state = block.getBlockState();
        if (state == null) {
            return Lists.newArrayList();
        }
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        return this.getQuadsForState(block, model, side, rand);
    }

    protected List<BakedQuad> getQuadsForState(IBlockInfo block, IBakedModel model, Direction side, Random rand) {
        BlockState state = block.getBlockState();
        if (state == null) {
            return Lists.newArrayList();
        }
        EmptyModelData tileData = block.getTileEntity() != null ? block.getTileEntity().getModelData() : EmptyModelData.INSTANCE;
        IModelData modelData = model.getModelData((IBlockDisplayReader)block.getWorld(), block.getPos(), state, (IModelData)tileData);
        return this.getQuadsForModel(model, state, side, rand, modelData, block.isPositive());
    }

    protected List<BakedQuad> getQuadsForModel(IBakedModel model, BlockState state, Direction side, Random rand, IModelData modelData, boolean positive) {
        return model.getQuads(state, side, rand, modelData).stream().map(quad -> new BakedQuad(quad.func_178209_a(), quad.func_178212_b() ? quad.func_178211_c() + (positive ? 1000 : 0) : -1, quad.func_178210_d(), quad.func_187508_a(), quad.func_239287_f_())).collect(Collectors.toList());
    }
}

