/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.render;

import cjminecraft.doubleslabs.common.blocks.VerticalSlabBlock;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.chunk.ChunkRenderCache;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;

public class SlabTileEntityRenderer
extends TileEntityRenderer<SlabTileEntity> {
    private static final Quaternion NORTH_ROTATION = Vector3f.field_229179_b_.func_229187_a_(90.0f);
    private static final Quaternion SOUTH_ROTATION = Vector3f.field_229178_a_.func_229187_a_(90.0f);
    private static final Quaternion WEST_ROTATION = Vector3f.field_229182_e_.func_229187_a_(90.0f);
    private static final Quaternion EAST_ROTATION = Vector3f.field_229183_f_.func_229187_a_(90.0f);

    public SlabTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(SlabTileEntity tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        BlockPos pos = tile.func_174877_v();
        ChunkRenderCache world = MinecraftForgeClient.getRegionRenderCache((World)tile.func_145831_w(), (BlockPos)pos);
        if (world == null) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        if (tile.getPositiveBlockInfo().getTileEntity() == null && tile.getNegativeBlockInfo().getTileEntity() == null) {
            return;
        }
        if (tile.getPositiveBlockInfo().getTileEntity() != null) {
            tile.getPositiveBlockInfo().getTileEntity().func_226984_a_(tile.getPositiveBlockInfo().getWorld(), tile.getPositiveBlockInfo().getPos());
        }
        if (tile.getNegativeBlockInfo().getTileEntity() != null) {
            tile.getNegativeBlockInfo().getTileEntity().func_226984_a_(tile.getNegativeBlockInfo().getWorld(), tile.getNegativeBlockInfo().getPos());
        }
        if (state.func_177230_c() == DSBlocks.DOUBLE_SLAB.get()) {
            if (tile.getPositiveBlockInfo().getTileEntity() != null) {
                TileEntityRendererDispatcher.field_147556_a.func_228850_a_(tile.getPositiveBlockInfo().getTileEntity(), partialTicks, matrixStack, buffer);
            }
            if (tile.getNegativeBlockInfo().getTileEntity() != null) {
                TileEntityRendererDispatcher.field_147556_a.func_228850_a_(tile.getNegativeBlockInfo().getTileEntity(), partialTicks, matrixStack, buffer);
            }
        } else if (state.func_177230_c() == DSBlocks.VERTICAL_SLAB.get()) {
            Direction facing = (Direction)world.func_180495_p(pos).func_177229_b((Property)VerticalSlabBlock.FACING);
            matrixStack.func_227860_a_();
            switch (facing) {
                case NORTH: {
                    matrixStack.func_227863_a_(NORTH_ROTATION);
                    matrixStack.func_227861_a_(0.0, 0.0, -1.0);
                    break;
                }
                case SOUTH: {
                    matrixStack.func_227863_a_(SOUTH_ROTATION);
                    matrixStack.func_227861_a_(0.0, -1.0, 0.0);
                    break;
                }
                case WEST: {
                    matrixStack.func_227863_a_(WEST_ROTATION);
                    matrixStack.func_227861_a_(-1.0, 0.0, 0.0);
                    break;
                }
                case EAST: {
                    matrixStack.func_227863_a_(EAST_ROTATION);
                    matrixStack.func_227861_a_(0.0, -1.0, 0.0);
                }
            }
            if (tile.getNegativeBlockInfo().getTileEntity() != null) {
                TileEntityRendererDispatcher.field_147556_a.func_228850_a_(tile.getNegativeBlockInfo().getTileEntity(), partialTicks, matrixStack, buffer);
            }
            if (tile.getPositiveBlockInfo().getTileEntity() != null) {
                TileEntityRendererDispatcher.field_147556_a.func_228850_a_(tile.getPositiveBlockInfo().getTileEntity(), partialTicks, matrixStack, buffer);
            }
            matrixStack.func_227865_b_();
        }
    }
}

