/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.blocks;

import cjminecraft.doubleslabs.api.ContainerSupport;
import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.containers.IContainerSupport;
import cjminecraft.doubleslabs.api.support.ISlabSupport;
import cjminecraft.doubleslabs.common.blocks.DynamicSlabBlock;
import cjminecraft.doubleslabs.common.container.WrappedContainer;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import cjminecraft.doubleslabs.common.util.RayTraceUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class DoubleSlabBlock
extends DynamicSlabBlock {
    public static Optional<IBlockInfo> getHalfState(IBlockReader world, BlockPos pos, double y) {
        return DoubleSlabBlock.getTile(world, pos).flatMap(tile -> tile.getNegativeBlockInfo().getBlockState() == null && tile.getPositiveBlockInfo().getBlockState() == null ? Optional.empty() : ((y > 0.5 || tile.getNegativeBlockInfo().getBlockState() == null) && tile.getPositiveBlockInfo().getBlockState() != null ? Optional.of(tile.getPositiveBlockInfo()) : Optional.of(tile.getNegativeBlockInfo())));
    }

    public boolean func_200123_i(BlockState state, IBlockReader world, BlockPos pos) {
        return DoubleSlabBlock.both(world, pos, i -> i.getBlockState().func_200131_a((IBlockReader)i.getWorld(), pos));
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader world, BlockPos pos) {
        Vector3d hitVec;
        BlockRayTraceResult rayTraceResult = RayTraceUtil.rayTrace(player);
        Vector3d vector3d = hitVec = rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK ? rayTraceResult.func_216347_e() : null;
        if (hitVec == null) {
            return DoubleSlabBlock.minFloat(world, pos, i -> i.getBlockState().func_185903_a(player, (IBlockReader)i.getWorld(), pos));
        }
        return DoubleSlabBlock.getHalfState(world, pos, hitVec.field_72448_b - (double)pos.func_177956_o()).map(i -> Float.valueOf(i.getBlockState().func_185903_a(player, (IBlockReader)i.getWorld(), pos))).orElse(Float.valueOf(super.func_180647_a(state, player, world, pos))).floatValue();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return DoubleSlabBlock.getHalfState(world, pos, target.func_216347_e().field_72448_b - (double)pos.func_177956_o()).map(i -> i.getBlockState().getPickBlock(target, (IBlockReader)i.getWorld(), pos, player)).orElse(ItemStack.field_190927_a);
    }

    public boolean canHarvestBlock(BlockState state, IBlockReader world, BlockPos pos, PlayerEntity player) {
        BlockRayTraceResult rayTraceResult = RayTraceUtil.rayTrace(player);
        Vector3d hitVec = rayTraceResult.func_216347_e();
        return DoubleSlabBlock.getHalfState(world, pos, hitVec.field_72448_b - (double)pos.func_177956_o()).map(i -> i.getBlockState().canHarvestBlock((IBlockReader)i.getWorld(), i.getPos(), player)).orElse(false);
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        Vector3d hitVec;
        BlockRayTraceResult rayTraceResult = RayTraceUtil.rayTrace(player);
        Vector3d vector3d = hitVec = rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK ? rayTraceResult.func_216347_e() : null;
        if (hitVec == null || te == null) {
            super.func_180657_a(world, player, pos, state, te, stack);
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            world.func_175713_t(pos);
        } else {
            SlabTileEntity tile = (SlabTileEntity)te;
            double y = hitVec.field_72448_b - (double)pos.func_177956_o();
            IBlockInfo remainingBlock = y > 0.5 ? tile.getNegativeBlockInfo() : tile.getPositiveBlockInfo();
            IBlockInfo blockToRemove = y > 0.5 ? tile.getPositiveBlockInfo() : tile.getNegativeBlockInfo();
            player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)blockToRemove.getBlockState().func_177230_c()));
            world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)blockToRemove.getBlockState()));
            player.func_71020_j(0.005f);
            if (!player.field_71075_bZ.field_75098_d) {
                DoubleSlabBlock.func_220054_a((BlockState)blockToRemove.getBlockState(), (World)world, (BlockPos)pos, null, (Entity)player, (ItemStack)stack);
            }
            blockToRemove.getBlockState().func_196947_b(blockToRemove.getWorld(), pos, Blocks.field_150350_a.func_176223_P(), false);
            world.func_180501_a(pos, remainingBlock.getBlockState(), 3);
            world.func_175690_a(pos, remainingBlock.getTileEntity());
        }
    }

    public boolean addLandingEffects(BlockState state1, ServerWorld worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return DoubleSlabBlock.getTile((IBlockReader)worldserver, pos).map(tile -> {
            float f = MathHelper.func_76123_f((float)(entity.field_70143_R - 3.0f));
            double d0 = Math.min((double)(0.2f + f / 15.0f), 2.5);
            int numOfParticles = (int)(150.0 * d0);
            worldserver.func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, tile.getPositiveBlockInfo().getBlockState()), entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), numOfParticles, 0.0, 0.0, 0.0, (double)0.15f);
            return true;
        }).orElse(false);
    }

    public boolean addRunningEffects(BlockState state, World world, BlockPos pos, Entity entity) {
        if (world.field_72995_K) {
            DoubleSlabBlock.getTile((IBlockReader)world, pos).ifPresent(tile -> world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, tile.getPositiveBlockInfo().getBlockState()), entity.func_226277_ct_() + ((double)world.field_73012_v.nextFloat() - 0.5) * (double)entity.func_213311_cf(), entity.func_174813_aQ().field_72338_b + 0.1, entity.func_226281_cx_() + ((double)world.field_73012_v.nextFloat() - 0.5) * (double)entity.func_213311_cf(), -entity.func_213322_ci().field_72450_a * 4.0, 1.5, -entity.func_213322_ci().field_72449_c * 4.0));
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addHitEffects(BlockState state, World world, RayTraceResult target, ParticleManager manager) {
        if (target.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult result = (BlockRayTraceResult)target;
            return DoubleSlabBlock.getHalfState((IBlockReader)world, result.func_216350_a(), target.func_216347_e().field_72448_b).map(info -> {
                BlockPos pos = result.func_216350_a();
                Direction side = result.func_216354_b();
                int i = pos.func_177958_n();
                int j = pos.func_177956_o();
                int k = pos.func_177952_p();
                AxisAlignedBB axisalignedbb = state.func_196952_d((IBlockReader)world, pos).func_197752_a();
                double d0 = (double)i + world.field_73012_v.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
                double d1 = (double)j + world.field_73012_v.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
                double d2 = (double)k + world.field_73012_v.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
                switch (side) {
                    case DOWN: {
                        d1 = (double)j + axisalignedbb.field_72338_b - (double)0.1f;
                        break;
                    }
                    case UP: {
                        d1 = (double)j + axisalignedbb.field_72337_e + (double)0.1f;
                        break;
                    }
                    case NORTH: {
                        d2 = (double)k + axisalignedbb.field_72339_c - (double)0.1f;
                        break;
                    }
                    case SOUTH: {
                        d2 = (double)k + axisalignedbb.field_72334_f + (double)0.1f;
                        break;
                    }
                    case WEST: {
                        d0 = (double)i + axisalignedbb.field_72340_a - (double)0.1f;
                        break;
                    }
                    case EAST: {
                        d0 = (double)i + axisalignedbb.field_72336_d + (double)0.1f;
                    }
                }
                DiggingParticle.Factory factory = new DiggingParticle.Factory();
                Particle particle = factory.func_199234_a(new BlockParticleData(ParticleTypes.field_197611_d, info.getBlockState()), (ClientWorld)world, d0, d1, d2, 0.0, 0.0, 0.0);
                if (particle != null) {
                    ((DiggingParticle)particle).func_174846_a(pos);
                    particle = particle.func_70543_e(0.2f).func_70541_f(0.6f);
                    manager.func_78873_a(particle);
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        return DoubleSlabBlock.getTile((IBlockReader)world, pos).map(tile -> {
            DiggingParticle.Factory factory = new DiggingParticle.Factory();
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        double d0 = ((double)j + 0.5) / 4.0 + (double)pos.func_177958_n();
                        double d1 = ((double)k + 0.5) / 4.0 + (double)pos.func_177956_o();
                        double d2 = ((double)l + 0.5) / 4.0 + (double)pos.func_177952_p();
                        DoubleSlabBlock.runIfAvailable((IBlockReader)world, pos, i -> {
                            Particle particle = factory.func_199234_a(new BlockParticleData(ParticleTypes.field_197611_d, i.getBlockState()), (ClientWorld)world, d0, d1, d2, 0.0, 0.0, 0.0);
                            if (particle != null) {
                                manager.func_78873_a(particle);
                            }
                        });
                    }
                }
            }
            return true;
        }).orElse(false);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (state.func_177230_c() != this) {
            return ActionResultType.PASS;
        }
        return DoubleSlabBlock.getHalfState((IBlockReader)world, pos, hit.func_216347_e().field_72448_b - (double)pos.func_177956_o()).map(i -> {
            IContainerSupport containerSupport = ContainerSupport.getSupport(i.getWorld(), pos, i.getBlockState());
            ISlabSupport slabSupport = SlabSupport.getSlabSupport((IBlockReader)world, pos, i.getBlockState());
            if (containerSupport != null) {
                if (!world.field_72995_K) {
                    final INamedContainerProvider provider = containerSupport.getNamedContainerProvider(i.getWorld(), pos, state, player, hand, hit);
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider((IBlockInfo)i){
                        final /* synthetic */ IBlockInfo val$i;
                        {
                            this.val$i = iBlockInfo;
                        }

                        public ITextComponent func_145748_c_() {
                            return provider.func_145748_c_();
                        }

                        public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
                            return new WrappedContainer(windowId, playerInventory, player, provider, this.val$i);
                        }
                    }, buffer -> {
                        buffer.func_179255_a(i.getPos());
                        buffer.writeBoolean(i.isPositive());
                        buffer.func_192572_a(containerSupport.getContainer(i.getWorld(), pos, state).getRegistryName());
                        containerSupport.writeExtraData(world, pos, state).accept((PacketBuffer)buffer);
                    });
                }
                return ActionResultType.SUCCESS;
            }
            try {
                return slabSupport == null ? i.getBlockState().func_227031_a_(i.getWorld(), player, hand, hit) : slabSupport.onBlockActivated(i.getBlockState(), i.getWorld(), pos, player, hand, hit);
            }
            catch (Exception e) {
                return ActionResultType.PASS;
            }
        }).orElse(ActionResultType.PASS);
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        BlockRayTraceResult result = RayTraceUtil.rayTrace(player);
        if (result.func_216347_e() != null) {
            DoubleSlabBlock.getHalfState((IBlockReader)world, pos, result.func_216347_e().field_72448_b - (double)pos.func_177956_o()).ifPresent(pair -> pair.getBlockState().func_196942_a(pair.getWorld(), pos, player));
        }
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (!DoubleSlabBlock.getTile((IBlockReader)world, pos).map(tile -> {
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                tile.getPositiveBlockInfo().getBlockState().func_177230_c().func_180658_a(tile.getPositiveBlockInfo().getWorld(), pos, entity, fallDistance);
                return true;
            }
            return false;
        }).orElse(false).booleanValue()) {
            super.func_180658_a(world, pos, entity, fallDistance);
        }
    }

    public void func_176216_a(IBlockReader world, Entity entity) {
        BlockPos pos = new BlockPos(entity.func_213303_ch()).func_177977_b();
        if (world.func_180495_p(pos).func_177230_c() == this && !DoubleSlabBlock.getTile(world, pos).map(tile -> {
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                tile.getPositiveBlockInfo().getBlockState().func_177230_c().func_176216_a((IBlockReader)tile.getPositiveBlockInfo().getWorld(), entity);
                return true;
            }
            return false;
        }).orElse(false).booleanValue()) {
            super.func_176216_a(world, entity);
        }
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        DoubleSlabBlock.getTile((IBlockReader)world, pos).ifPresent(tile -> {
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                tile.getPositiveBlockInfo().getBlockState().func_177230_c().func_176199_a(tile.getPositiveBlockInfo().getWorld(), pos, entity);
            }
        });
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, IBlockDisplayReader world, BlockPos pos, FluidState fluidState) {
        return true;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        DoubleSlabBlock.getTile((IBlockReader)world, pos).ifPresent(tile -> {
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                tile.getPositiveBlockInfo().getBlockState().func_196950_a(world, pos, entity);
            }
            if (tile.getNegativeBlockInfo().getBlockState() != null) {
                tile.getNegativeBlockInfo().getBlockState().func_196950_a(world, pos, entity);
            }
        });
    }

    public void func_220066_a(World world, BlockState state, BlockRayTraceResult hit, ProjectileEntity projectile) {
        DoubleSlabBlock.getHalfState((IBlockReader)world, hit.func_216350_a(), hit.func_216347_e().field_72448_b).ifPresent(i -> i.getBlockState().func_215690_a(i.getWorld(), i.getBlockState(), hit, projectile));
    }

    @Override
    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        return DoubleSlabBlock.getTile((IBlockReader)world, pos).filter(tile -> tile.getPositiveBlockInfo().getBlockState() != null).map(tile -> tile.getPositiveBlockInfo().getBlockState().getSoundType((IWorldReader)tile.getPositiveBlockInfo().getWorld(), pos, entity)).orElse(super.getSoundType(state, world, pos, entity));
    }
}

