/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.blocks;

import cjminecraft.doubleslabs.api.ContainerSupport;
import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.containers.IContainerSupport;
import cjminecraft.doubleslabs.api.support.ISlabSupport;
import cjminecraft.doubleslabs.common.blocks.DynamicSlabBlock;
import cjminecraft.doubleslabs.common.container.WrappedContainer;
import cjminecraft.doubleslabs.common.init.DSItems;
import cjminecraft.doubleslabs.common.items.VerticalSlabItem;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import cjminecraft.doubleslabs.common.util.RayTraceUtil;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.network.NetworkHooks;

public class VerticalSlabBlock
extends DynamicSlabBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty DOUBLE = BooleanProperty.func_177716_a((String)"double");

    public VerticalSlabBlock() {
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOUBLE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static Optional<IBlockInfo> getHalfState(IBlockReader world, BlockPos pos, double x, double z) {
        BlockState state = world.func_180495_p(pos);
        return VerticalSlabBlock.getTile(world, pos).map(tile -> {
            IBlockInfo iBlockInfo;
            block8: {
                block7: {
                    block6: {
                        block5: {
                            if (tile.getPositiveBlockInfo().getBlockState() == null && tile.getNegativeBlockInfo().getBlockState() == null) {
                                return null;
                            }
                            if (((Direction)state.func_177229_b((Property)FACING)).func_176743_c() != Direction.AxisDirection.POSITIVE) break block5;
                            double d = ((Direction)state.func_177229_b((Property)FACING)).func_176740_k() == Direction.Axis.X ? x : z;
                            if (!(d > 0.5)) break block6;
                            break block7;
                        }
                        if ((((Direction)state.func_177229_b((Property)FACING)).func_176740_k() == Direction.Axis.X ? x : z) < 0.5) break block7;
                    }
                    if (tile.getNegativeBlockInfo().getBlockState() != null) break block8;
                }
                if (tile.getPositiveBlockInfo().getBlockState() != null) {
                    iBlockInfo = tile.getPositiveBlockInfo();
                    return iBlockInfo;
                }
            }
            iBlockInfo = tile.getNegativeBlockInfo();
            return iBlockInfo;
        }).flatMap(block -> block == null || block.getBlockState() == null ? Optional.empty() : Optional.of(block));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING, DOUBLE});
    }

    @Override
    public boolean func_204510_a(IBlockReader world, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.func_177229_b((Property)DOUBLE) == false || super.func_204510_a(world, pos, state, fluid);
    }

    @Override
    @Nonnull
    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean positive;
        double value;
        BlockPos pos = context.func_195995_a();
        BlockState state = context.func_195991_k().func_180495_p(pos);
        if (state.func_203425_a((Block)this)) {
            if (this.func_196253_a(state, context)) {
                FluidState fluidstate = context.func_195991_k().func_204610_c(pos);
                return (BlockState)((BlockState)state.func_206870_a((Property)DOUBLE, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a && VerticalSlabBlock.either((IBlockReader)context.func_195991_k(), pos, i -> i.getSupport() != null && i.getSupport().waterloggableWhenDouble(i.getWorld(), i.getPos(), i.getBlockState()))));
            }
            return state;
        }
        BlockState newState = super.func_196258_a(context);
        if (context.func_196000_l().func_176740_k().func_200128_b()) {
            Vector3d vec = context.func_221532_j().func_178788_d(Vector3d.func_237491_b_((Vector3i)context.func_195995_a())).func_178786_a(0.5, 0.0, 0.5);
            double angle = Math.atan2(vec.field_72450_a, vec.field_72449_c) * -180.0 / Math.PI;
            Direction direction = Direction.func_176733_a((double)angle);
            return (BlockState)newState.func_206870_a((Property)FACING, (Comparable)direction);
        }
        double d = value = context.func_195992_f().func_176740_k() == Direction.Axis.Z ? context.func_221532_j().field_72450_a - (double)context.func_195995_a().func_177958_n() : context.func_221532_j().field_72449_c - (double)context.func_195995_a().func_177952_p();
        if (value > 0.25 && value < 0.75) {
            return (BlockState)newState.func_206870_a((Property)FACING, (Comparable)context.func_195992_f());
        }
        boolean bl = context.func_195992_f().func_176743_c() == Direction.AxisDirection.POSITIVE ? value > 0.5 : (positive = value < 0.5);
        if (context.func_195992_f().func_176740_k() == Direction.Axis.Z) {
            positive = !positive;
        }
        return (BlockState)newState.func_206870_a((Property)FACING, (Comparable)(positive ? context.func_195992_f().func_176746_e() : context.func_195992_f().func_176735_f()));
    }

    public Item func_199767_j() {
        return (Item)DSItems.VERTICAL_SLAB.get();
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        ItemStack stack = useContext.func_195996_i();
        if (!((Boolean)state.func_177229_b((Property)DOUBLE)).booleanValue() && stack.func_77973_b() == this.func_199767_j()) {
            if (useContext.func_196012_c()) {
                Direction direction = (Direction)state.func_177229_b((Property)FACING);
                return VerticalSlabBlock.getTile((IBlockReader)useContext.func_195991_k(), useContext.func_195995_a()).map(tile -> {
                    boolean positive = tile.getPositiveBlockInfo().getBlockState() != null;
                    return useContext.func_196000_l() == direction.func_176734_d() && positive || useContext.func_196000_l() == direction && !positive;
                }).orElse(false);
            }
            return true;
        }
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        TileEntity tileEntity;
        if (((Boolean)state.func_177229_b((Property)DOUBLE)).booleanValue()) {
            return VoxelShapes.func_197868_b();
        }
        double min = 0.0;
        double max = 8.0;
        if (((Direction)state.func_177229_b((Property)FACING)).func_176743_c() == Direction.AxisDirection.POSITIVE) {
            min = 8.0;
            max = 16.0;
        }
        if ((tileEntity = world.func_175625_s(pos)) instanceof SlabTileEntity) {
            boolean negative;
            SlabTileEntity tile = (SlabTileEntity)tileEntity;
            boolean positive = tile.getPositiveBlockInfo().getBlockState() != null;
            boolean bl = negative = tile.getNegativeBlockInfo().getBlockState() != null;
            if (((Direction)state.func_177229_b((Property)FACING)).func_176743_c() == Direction.AxisDirection.POSITIVE && positive || ((Direction)state.func_177229_b((Property)FACING)).func_176743_c() == Direction.AxisDirection.NEGATIVE && negative) {
                min = 8.0;
                max = 16.0;
            } else {
                min = 0.0;
                max = 8.0;
            }
        }
        if (((Direction)state.func_177229_b((Property)FACING)).func_176740_k() == Direction.Axis.X) {
            return Block.func_208617_a((double)min, (double)0.0, (double)0.0, (double)max, (double)16.0, (double)16.0);
        }
        return Block.func_208617_a((double)0.0, (double)0.0, (double)min, (double)16.0, (double)16.0, (double)max);
    }

    public boolean func_200123_i(BlockState state, IBlockReader world, BlockPos pos) {
        return VerticalSlabBlock.getTile(world, pos).map(tile -> tile.getPositiveBlockInfo().getBlockState() == null || tile.getPositiveBlockInfo().getBlockState().func_200131_a((IBlockReader)tile.getPositiveBlockInfo().getWorld(), pos) || tile.getNegativeBlockInfo().getBlockState() == null || tile.getNegativeBlockInfo().getBlockState().func_200131_a((IBlockReader)tile.getNegativeBlockInfo().getWorld(), pos)).orElse(false);
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader world, BlockPos pos) {
        Vector3d hitVec;
        BlockRayTraceResult rayTraceResult = RayTraceUtil.rayTrace(player);
        Vector3d vector3d = hitVec = rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK ? rayTraceResult.func_216347_e() : null;
        if (hitVec == null) {
            return VerticalSlabBlock.minFloat(world, pos, i -> i.getBlockState().func_185903_a(player, (IBlockReader)i.getWorld(), pos));
        }
        return VerticalSlabBlock.getHalfState(world, pos, hitVec.field_72450_a - (double)pos.func_177958_n(), hitVec.field_72449_c - (double)pos.func_177952_p()).map(i -> Float.valueOf(i.getBlockState().func_185903_a(player, (IBlockReader)i.getWorld(), pos))).orElse(Float.valueOf(super.func_180647_a(state, player, world, pos))).floatValue();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return VerticalSlabBlock.getHalfState(world, pos, target.func_216347_e().field_72450_a - (double)pos.func_177958_n(), target.func_216347_e().field_72449_c - (double)pos.func_177952_p()).map(i -> {
            ItemStack stack = i.getBlockState().getPickBlock(target, (IBlockReader)i.getWorld(), pos, player);
            if (SlabSupport.isHorizontalSlab(stack.func_77973_b())) {
                return VerticalSlabItem.setStack(new ItemStack((IItemProvider)DSItems.VERTICAL_SLAB.get()), stack);
            }
            return stack;
        }).orElse(ItemStack.field_190927_a);
    }

    @Override
    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (willHarvest) {
            return true;
        }
        if (player.func_184812_l_() && player.func_225608_bj_() && ((Boolean)state.func_177229_b((Property)DOUBLE)).booleanValue()) {
            this.func_180657_a(world, player, pos, state, world.func_175625_s(pos), ItemStack.field_190927_a);
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, false, fluid);
    }

    public boolean canHarvestBlock(BlockState state, IBlockReader world, BlockPos pos, PlayerEntity player) {
        BlockRayTraceResult rayTraceResult = RayTraceUtil.rayTrace(player);
        Vector3d hitVec = rayTraceResult.func_216347_e();
        return VerticalSlabBlock.getHalfState(world, pos, hitVec.field_72450_a - (double)pos.func_177958_n(), hitVec.field_72449_c - (double)pos.func_177952_p()).map(i -> i.getBlockState().canHarvestBlock((IBlockReader)i.getWorld(), i.getPos(), player)).orElse(false);
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        Vector3d hitVec;
        BlockRayTraceResult rayTraceResult = RayTraceUtil.rayTrace(player);
        Vector3d vector3d = hitVec = rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK ? rayTraceResult.func_216347_e() : null;
        if (hitVec == null || te == null) {
            super.func_180657_a(world, player, pos, state, te, stack);
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            world.func_175713_t(pos);
        } else if (((Boolean)state.func_177229_b((Property)DOUBLE)).booleanValue()) {
            double distance;
            SlabTileEntity tile = (SlabTileEntity)te;
            double d = distance = ((Direction)state.func_177229_b((Property)FACING)).func_176740_k() == Direction.Axis.X ? hitVec.field_72450_a - (double)pos.func_177958_n() : hitVec.field_72449_c - (double)pos.func_177952_p();
            boolean positive = ((Direction)state.func_177229_b((Property)FACING)).func_176743_c() == Direction.AxisDirection.POSITIVE ? distance > 0.5 : distance < 0.5;
            IBlockInfo blockToRemove = positive ? tile.getPositiveBlockInfo() : tile.getNegativeBlockInfo();
            player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)blockToRemove.getBlockState().func_177230_c()));
            world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)blockToRemove.getBlockState()));
            player.func_71020_j(0.005f);
            if (!player.field_71075_bZ.field_75098_d) {
                VerticalSlabBlock.func_220054_a((BlockState)blockToRemove.getBlockState(), (World)world, (BlockPos)pos, null, (Entity)player, (ItemStack)stack);
            }
            blockToRemove.getBlockState().func_196947_b(blockToRemove.getWorld(), pos, Blocks.field_150350_a.func_176223_P(), false);
            blockToRemove.setBlockState(null);
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)DOUBLE, (Comparable)Boolean.valueOf(false)), 3);
        } else {
            SlabTileEntity tile = (SlabTileEntity)te;
            boolean positive = tile.getPositiveBlockInfo().getBlockState() != null;
            IBlockInfo blockToRemove = positive ? tile.getPositiveBlockInfo() : tile.getNegativeBlockInfo();
            player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)blockToRemove.getBlockState().func_177230_c()));
            world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)blockToRemove.getBlockState()));
            player.func_71020_j(0.005f);
            if (!player.field_71075_bZ.field_75098_d) {
                VerticalSlabBlock.func_220054_a((BlockState)blockToRemove.getBlockState(), (World)world, (BlockPos)pos, (TileEntity)blockToRemove.getTileEntity(), (Entity)player, (ItemStack)stack);
            }
            blockToRemove.getBlockState().func_196947_b(blockToRemove.getWorld(), pos, Blocks.field_150350_a.func_176223_P(), false);
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            world.func_175713_t(pos);
        }
    }

    public boolean addLandingEffects(BlockState state1, ServerWorld worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        float f = MathHelper.func_76123_f((float)(entity.field_70143_R - 3.0f));
        double d0 = Math.min((double)(0.2f + f / 15.0f), 2.5);
        int numOfParticles = (Boolean)state1.func_177229_b((Property)DOUBLE) != false ? (int)(75.0 * d0) : (int)(150.0 * d0);
        VerticalSlabBlock.runIfAvailable((IBlockReader)worldserver, pos, i -> worldserver.func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, i.getBlockState()), entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), numOfParticles, 0.0, 0.0, 0.0, (double)0.15f));
        return true;
    }

    public boolean addRunningEffects(BlockState state, World world, BlockPos pos, Entity entity) {
        if (world.field_72995_K) {
            VerticalSlabBlock.runIfAvailable((IBlockReader)world, pos, i -> world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, i.getBlockState()), entity.func_226277_ct_() + ((double)world.field_73012_v.nextFloat() - 0.5) * (double)entity.func_213311_cf(), entity.func_174813_aQ().field_72338_b + 0.1, entity.func_226281_cx_() + ((double)world.field_73012_v.nextFloat() - 0.5) * (double)entity.func_213311_cf(), -entity.func_213322_ci().field_72450_a * 4.0, 1.5, -entity.func_213322_ci().field_72449_c * 4.0));
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addHitEffects(BlockState state, World world, RayTraceResult target, ParticleManager manager) {
        if (target.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult result = (BlockRayTraceResult)target;
            return VerticalSlabBlock.getHalfState((IBlockReader)world, result.func_216350_a(), target.func_216347_e().field_72450_a - (double)result.func_216350_a().func_177958_n(), target.func_216347_e().field_72449_c - (double)result.func_216350_a().func_177952_p()).map(info -> {
                boolean flag;
                BlockPos pos = result.func_216350_a();
                Direction side = result.func_216354_b();
                Direction facing = (Direction)state.func_177229_b((Property)FACING);
                boolean bl = flag = (Boolean)state.func_177229_b((Property)DOUBLE) == false && !info.isPositive();
                double i = flag && facing.func_176740_k().equals((Object)Direction.Axis.X) ? (double)pos.func_177958_n() + (facing.func_176743_c().equals((Object)Direction.AxisDirection.POSITIVE) ? -0.5 : 0.5) : (double)pos.func_177958_n();
                double j = pos.func_177956_o();
                double k = flag && facing.func_176740_k().equals((Object)Direction.Axis.Z) ? (double)pos.func_177952_p() + (facing.func_176743_c().equals((Object)Direction.AxisDirection.POSITIVE) ? -0.5 : 0.5) : (double)pos.func_177952_p();
                AxisAlignedBB axisalignedbb = state.func_196952_d((IBlockReader)world, pos).func_197752_a();
                double d0 = i + world.field_73012_v.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
                double d1 = j + world.field_73012_v.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
                double d2 = k + world.field_73012_v.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
                switch (side) {
                    case DOWN: {
                        d1 = j + axisalignedbb.field_72338_b - (double)0.1f;
                        break;
                    }
                    case UP: {
                        d1 = j + axisalignedbb.field_72337_e + (double)0.1f;
                        break;
                    }
                    case NORTH: {
                        d2 = k + axisalignedbb.field_72339_c - (double)0.1f;
                        break;
                    }
                    case SOUTH: {
                        d2 = k + axisalignedbb.field_72334_f + (double)0.1f;
                        break;
                    }
                    case WEST: {
                        d0 = i + axisalignedbb.field_72340_a - (double)0.1f;
                        break;
                    }
                    case EAST: {
                        d0 = i + axisalignedbb.field_72336_d + (double)0.1f;
                    }
                }
                DiggingParticle.Factory factory = new DiggingParticle.Factory();
                Particle particle = factory.func_199234_a(new BlockParticleData(ParticleTypes.field_197611_d, info.getBlockState()), (ClientWorld)world, d0, d1, d2, 0.0, 0.0, 0.0);
                if (particle != null) {
                    ((DiggingParticle)particle).func_174846_a(pos);
                    particle = particle.func_70543_e(0.2f).func_70541_f(0.6f);
                    manager.func_78873_a(particle);
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        return VerticalSlabBlock.getTile((IBlockReader)world, pos).map(tile -> {
            DiggingParticle.Factory factory = new DiggingParticle.Factory();
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        double d0 = ((double)j + 0.5) / 4.0 + (double)pos.func_177958_n();
                        double d1 = ((double)k + 0.5) / 4.0 + (double)pos.func_177956_o();
                        double d2 = ((double)l + 0.5) / 4.0 + (double)pos.func_177952_p();
                        VerticalSlabBlock.runIfAvailable((IBlockReader)world, pos, i -> {
                            Particle particle = factory.func_199234_a(new BlockParticleData(ParticleTypes.field_197611_d, i.getBlockState()), (ClientWorld)world, d0, d1, d2, 0.0, 0.0, 0.0);
                            if (particle != null) {
                                manager.func_78873_a(particle);
                            }
                        });
                    }
                }
            }
            return true;
        }).orElse(false);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (state.func_177230_c() != this) {
            return ActionResultType.PASS;
        }
        return VerticalSlabBlock.getHalfState((IBlockReader)world, pos, hit.func_216347_e().field_72450_a - (double)pos.func_177958_n(), hit.func_216347_e().field_72449_c - (double)pos.func_177952_p()).map(i -> {
            IContainerSupport containerSupport = ContainerSupport.getSupport(i.getWorld(), pos, i.getBlockState());
            ISlabSupport slabSupport = SlabSupport.getSlabSupport((IBlockReader)world, pos, i.getBlockState());
            if (containerSupport != null) {
                if (!world.field_72995_K) {
                    final INamedContainerProvider provider = containerSupport.getNamedContainerProvider(i.getWorld(), pos, state, player, hand, hit);
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider((IBlockInfo)i){
                        final /* synthetic */ IBlockInfo val$i;
                        {
                            this.val$i = iBlockInfo;
                        }

                        public ITextComponent func_145748_c_() {
                            return provider.func_145748_c_();
                        }

                        public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
                            return new WrappedContainer(windowId, playerInventory, player, provider, this.val$i);
                        }
                    }, buffer -> {
                        buffer.func_179255_a(i.getPos());
                        buffer.writeBoolean(i.isPositive());
                        buffer.func_192572_a(containerSupport.getContainer(i.getWorld(), pos, state).getRegistryName());
                        containerSupport.writeExtraData(world, pos, state).accept((PacketBuffer)buffer);
                    });
                }
                return ActionResultType.SUCCESS;
            }
            try {
                return slabSupport == null ? i.getBlockState().func_227031_a_(i.getWorld(), player, hand, hit) : slabSupport.onBlockActivated(i.getBlockState(), i.getWorld(), pos, player, hand, hit);
            }
            catch (Exception e) {
                return ActionResultType.PASS;
            }
        }).orElse(ActionResultType.PASS);
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        BlockRayTraceResult result = RayTraceUtil.rayTrace(player);
        if (result.func_216347_e() != null) {
            VerticalSlabBlock.getHalfState((IBlockReader)world, pos, result.func_216347_e().field_72450_a - (double)pos.func_177958_n(), result.func_216347_e().field_72449_c - (double)pos.func_177952_p()).ifPresent(i -> i.getBlockState().func_196942_a(i.getWorld(), pos, player));
        }
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (!VerticalSlabBlock.getHalfState((IBlockReader)world, pos, entity.func_226277_ct_() - (double)pos.func_177958_n(), entity.func_226281_cx_() - (double)pos.func_177952_p()).map(i -> {
            i.getBlockState().func_177230_c().func_180658_a(i.getWorld(), pos, entity, fallDistance);
            return true;
        }).orElse(false).booleanValue()) {
            super.func_180658_a(world, pos, entity, fallDistance);
        }
    }

    public void func_176216_a(IBlockReader world, Entity entity) {
        BlockPos pos = new BlockPos(entity.func_213303_ch()).func_177977_b();
        if (world.func_180495_p(pos).func_177230_c() == this && !VerticalSlabBlock.getHalfState(world, pos, entity.func_226277_ct_() - (double)pos.func_177958_n(), entity.func_226281_cx_() - (double)pos.func_177952_p()).map(i -> {
            i.getBlockState().func_177230_c().func_176216_a((IBlockReader)i.getWorld(), entity);
            return true;
        }).orElse(false).booleanValue()) {
            super.func_176216_a(world, entity);
        }
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (!VerticalSlabBlock.getHalfState((IBlockReader)world, pos, entity.func_226277_ct_() - (double)pos.func_177958_n(), entity.func_226281_cx_() - (double)pos.func_177952_p()).map(i -> {
            i.getBlockState().func_177230_c().func_176199_a(i.getWorld(), pos, entity);
            return true;
        }).orElse(false).booleanValue()) {
            super.func_176199_a(world, pos, entity);
        }
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, IBlockDisplayReader world, BlockPos pos, FluidState fluidState) {
        return (Boolean)state.func_177229_b((Property)DOUBLE);
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        VerticalSlabBlock.getHalfState((IBlockReader)world, pos, entity.func_226277_ct_() - (double)pos.func_177958_n(), entity.func_226281_cx_() - (double)pos.func_177952_p()).ifPresent(i -> i.getBlockState().func_196950_a(i.getWorld(), pos, entity));
    }

    public void func_220066_a(World world, BlockState state, BlockRayTraceResult hit, ProjectileEntity projectile) {
        VerticalSlabBlock.getHalfState((IBlockReader)world, hit.func_216350_a(), hit.func_216347_e().field_72450_a, hit.func_216347_e().field_72449_c).ifPresent(i -> i.getBlockState().func_215690_a(i.getWorld(), i.getBlockState(), hit, projectile));
    }

    @Override
    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        if (entity != null) {
            return VerticalSlabBlock.getHalfState((IBlockReader)world, pos, entity.func_226277_ct_() - (double)pos.func_177958_n(), entity.func_226281_cx_() - (double)pos.func_177952_p()).map(i -> i.getBlockState().getSoundType((IWorldReader)i.getWorld(), pos, entity)).orElseGet(() -> super.getSoundType(state, world, pos, entity));
        }
        return VerticalSlabBlock.getAvailable((IBlockReader)world, pos).map(i -> i.getBlockState().getSoundType((IWorldReader)i.getWorld(), pos, null)).orElseGet(() -> super.getSoundType(state, world, pos, null));
    }

    @Override
    public void func_176224_k(World world, BlockPos pos) {
        VerticalSlabBlock.runIfAvailable((IBlockReader)world, pos, i -> i.getBlockState().func_177230_c().func_176224_k(i.getWorld(), i.getPos()));
    }

    @Override
    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        return VerticalSlabBlock.both(world, pos, i -> i.getBlockState().canSustainPlant((IBlockReader)i.getWorld(), pos, facing, plantable));
    }
}

