/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.network.packet.config;

import cjminecraft.doubleslabs.common.DoubleSlabs;
import cjminecraft.doubleslabs.common.capability.config.IPlayerConfig;
import cjminecraft.doubleslabs.common.capability.config.PlayerConfig;
import cjminecraft.doubleslabs.common.capability.config.PlayerConfigCapability;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateServerPlayerConfigPacket {
    private final IPlayerConfig config;

    public UpdateServerPlayerConfigPacket(IPlayerConfig config) {
        this.config = config;
    }

    public static UpdateServerPlayerConfigPacket decode(PacketBuffer buf) {
        PlayerConfig config = new PlayerConfig();
        config.deserializeNBT(buf.func_150793_b());
        return new UpdateServerPlayerConfigPacket(config);
    }

    public static void handle(UpdateServerPlayerConfigPacket message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ctx.getSender().getCapability(PlayerConfigCapability.PLAYER_CONFIG).ifPresent(config -> {
                config.setVerticalSlabPlacementMethod(message.config.getVerticalSlabPlacementMethod());
                config.setPlaceVerticalSlabs(message.config.placeVerticalSlabs());
            });
            DoubleSlabs.LOGGER.debug("Received config update message from player %s: Placement Method - %s, Place Vertical Slab Keybinding Down - %s", (Object)ctx.getSender().func_195047_I_(), (Object)message.config.getVerticalSlabPlacementMethod(), (Object)message.config.placeVerticalSlabs());
        });
        ctx.setPacketHandled(true);
    }

    public void encode(PacketBuffer buf) {
        buf.func_150786_a((CompoundNBT)this.config.serializeNBT());
    }
}

