/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.mixin;

import cjminecraft.doubleslabs.client.model.DynamicSlabBakedModel;
import cjminecraft.doubleslabs.client.model.VerticalSlabBakedModel;
import cjminecraft.doubleslabs.client.util.AmbientOcclusionFace;
import cjminecraft.doubleslabs.client.util.DoubleSlabCulling;
import cjminecraft.doubleslabs.common.blocks.VerticalSlabBlock;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.IModelData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={BlockModelRenderer.class})
public abstract class BlockModelRendererMixin {
    @Mutable
    @Final
    @Shadow
    private final BlockColors field_187499_a;

    protected BlockModelRendererMixin(BlockColors blockColors) {
        this.field_187499_a = blockColors;
    }

    @Inject(at={@At(value="HEAD")}, remap=false, method={"renderModelSmooth(Lnet/minecraft/world/IBlockDisplayReader;Lnet/minecraft/client/renderer/model/IBakedModel;Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;Lcom/mojang/blaze3d/matrix/MatrixStack;Lcom/mojang/blaze3d/vertex/IVertexBuilder;ZLjava/util/Random;JILnet/minecraftforge/client/model/data/IModelData;)Z"}, cancellable=true)
    private void renderModelSmooth(IBlockDisplayReader world, IBakedModel model, BlockState state, BlockPos pos, MatrixStack matrixStack, IVertexBuilder buffer, boolean checkSides, Random random, long rand, int combinedOverlay, IModelData modelData, CallbackInfoReturnable<Boolean> callback) {
        if (model instanceof DynamicSlabBakedModel) {
            boolean flag = false;
            float[] afloat = new float[Direction.values().length * 2];
            BitSet bitset = new BitSet(3);
            AmbientOcclusionFace blockmodelrenderer$ambientocclusionface = new AmbientOcclusionFace();
            boolean doubleSlab = false;
            boolean renderNegative = true;
            boolean renderPositive = true;
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof SlabTileEntity) {
                SlabTileEntity slab = (SlabTileEntity)tile;
                doubleSlab = slab.getPositiveBlockInfo().getBlockState() != null && slab.getNegativeBlockInfo().getBlockState() != null && DynamicSlabBakedModel.useDoubleSlabModel(slab.getPositiveBlockInfo().getBlockState(), slab.getNegativeBlockInfo().getBlockState());
                renderNegative = slab.getNegativeBlockInfo().getBlockState() != null;
                renderPositive = slab.getPositiveBlockInfo().getBlockState() != null;
            }
            for (Direction direction : Direction.values()) {
                List quads;
                random.setSeed(rand);
                if (doubleSlab) {
                    quads = model.getQuads(state, direction, random, modelData);
                    if (quads.isEmpty() || checkSides && !DoubleSlabCulling.shouldDoubleSlabSideBeRendered(state, world, pos, direction)) continue;
                    this.renderQuadsSmooth(world, state, pos, matrixStack, buffer, quads, afloat, bitset, blockmodelrenderer$ambientocclusionface, combinedOverlay);
                    flag = true;
                    continue;
                }
                if (renderPositive) {
                    modelData.setData(DynamicSlabBakedModel.RENDER_POSITIVE, (Object)true);
                    quads = model.getQuads(state, direction, random, modelData);
                    if (!(quads.isEmpty() || checkSides && !DoubleSlabCulling.shouldSideBeRendered(state, world, pos, direction, true))) {
                        this.renderQuadsSmooth(world, state, pos, matrixStack, buffer, quads, afloat, bitset, blockmodelrenderer$ambientocclusionface, combinedOverlay);
                        flag = true;
                    }
                }
                if (!renderNegative) continue;
                if (MinecraftForgeClient.getRenderLayer() == null && model instanceof VerticalSlabBakedModel) {
                    BlockState newState = (BlockState)state.func_206870_a((Property)VerticalSlabBlock.FACING, (Comparable)((Direction)state.func_177229_b((Property)VerticalSlabBlock.FACING)).func_176734_d());
                    quads = ((VerticalSlabBakedModel)model).getModel(newState).getQuads(newState, direction, random, modelData);
                } else {
                    modelData.setData(DynamicSlabBakedModel.RENDER_POSITIVE, (Object)false);
                    quads = model.getQuads(state, direction, random, modelData);
                }
                if (quads.isEmpty() || checkSides && !DoubleSlabCulling.shouldSideBeRendered(state, world, pos, direction, false)) continue;
                this.renderQuadsSmooth(world, state, pos, matrixStack, buffer, quads, afloat, bitset, blockmodelrenderer$ambientocclusionface, combinedOverlay);
                flag = true;
            }
            modelData.setData(DynamicSlabBakedModel.RENDER_POSITIVE, null);
            random.setSeed(rand);
            List list1 = model.getQuads(state, null, random, modelData);
            if (!list1.isEmpty()) {
                this.renderQuadsSmooth(world, state, pos, matrixStack, buffer, list1, afloat, bitset, blockmodelrenderer$ambientocclusionface, combinedOverlay);
                flag = true;
            }
            callback.setReturnValue((Object)flag);
        }
    }

    @Inject(at={@At(value="HEAD")}, remap=false, method={"renderModelFlat(Lnet/minecraft/world/IBlockDisplayReader;Lnet/minecraft/client/renderer/model/IBakedModel;Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;Lcom/mojang/blaze3d/matrix/MatrixStack;Lcom/mojang/blaze3d/vertex/IVertexBuilder;ZLjava/util/Random;JILnet/minecraftforge/client/model/data/IModelData;)Z"}, cancellable=true)
    private void renderModelFlat(IBlockDisplayReader world, IBakedModel model, BlockState state, BlockPos pos, MatrixStack matrixStack, IVertexBuilder buffer, boolean checkSides, Random random, long rand, int combinedOverlay, IModelData modelData, CallbackInfoReturnable<Boolean> callback) {
        if (model instanceof DynamicSlabBakedModel) {
            boolean flag = false;
            BitSet bitset = new BitSet(3);
            boolean doubleSlab = false;
            boolean renderNegative = true;
            boolean renderPositive = true;
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof SlabTileEntity) {
                SlabTileEntity slab = (SlabTileEntity)tile;
                doubleSlab = slab.getPositiveBlockInfo().getBlockState() != null && slab.getNegativeBlockInfo().getBlockState() != null && DynamicSlabBakedModel.useDoubleSlabModel(slab.getPositiveBlockInfo().getBlockState(), slab.getNegativeBlockInfo().getBlockState());
                renderNegative = slab.getNegativeBlockInfo().getBlockState() != null;
                renderPositive = slab.getPositiveBlockInfo().getBlockState() != null;
            }
            for (Direction direction : Direction.values()) {
                List list;
                random.setSeed(rand);
                if (doubleSlab) {
                    list = model.getQuads(state, direction, random, modelData);
                    if (list.isEmpty() || checkSides && !DoubleSlabCulling.shouldDoubleSlabSideBeRendered(state, world, pos, direction)) continue;
                    int i = WorldRenderer.func_228420_a_((IBlockDisplayReader)world, (BlockState)state, (BlockPos)pos.func_177972_a(direction));
                    this.renderQuadsFlat(world, state, pos, i, combinedOverlay, false, matrixStack, buffer, list, bitset);
                    flag = true;
                    continue;
                }
                if (renderPositive) {
                    modelData.setData(DynamicSlabBakedModel.RENDER_POSITIVE, (Object)true);
                    list = model.getQuads(state, direction, random, modelData);
                    if (!(list.isEmpty() || checkSides && !DoubleSlabCulling.shouldSideBeRendered(state, world, pos, direction, true))) {
                        int i = WorldRenderer.func_228420_a_((IBlockDisplayReader)world, (BlockState)state, (BlockPos)pos.func_177972_a(direction));
                        this.renderQuadsFlat(world, state, pos, i, combinedOverlay, false, matrixStack, buffer, list, bitset);
                        flag = true;
                    }
                }
                if (!renderNegative) continue;
                modelData.setData(DynamicSlabBakedModel.RENDER_POSITIVE, (Object)false);
                if (MinecraftForgeClient.getRenderLayer() == null && model instanceof VerticalSlabBakedModel) {
                    BlockState newState = (BlockState)state.func_206870_a((Property)VerticalSlabBlock.FACING, (Comparable)((Direction)state.func_177229_b((Property)VerticalSlabBlock.FACING)).func_176734_d());
                    list = ((VerticalSlabBakedModel)model).getModel(newState).getQuads(newState, direction, random, modelData);
                } else {
                    modelData.setData(DynamicSlabBakedModel.RENDER_POSITIVE, (Object)false);
                    list = model.getQuads(state, direction, random, modelData);
                }
                if (list.isEmpty() || checkSides && !DoubleSlabCulling.shouldSideBeRendered(state, world, pos, direction, false)) continue;
                int i = WorldRenderer.func_228420_a_((IBlockDisplayReader)world, (BlockState)state, (BlockPos)pos.func_177972_a(direction));
                this.renderQuadsFlat(world, state, pos, i, combinedOverlay, false, matrixStack, buffer, list, bitset);
                flag = true;
            }
            modelData.setData(DynamicSlabBakedModel.RENDER_POSITIVE, null);
            random.setSeed(rand);
            List list1 = model.getQuads(state, (Direction)null, random, modelData);
            if (!list1.isEmpty()) {
                this.renderQuadsFlat(world, state, pos, -1, combinedOverlay, true, matrixStack, buffer, list1, bitset);
                flag = true;
            }
            callback.setReturnValue((Object)flag);
        }
    }

    private void renderQuadsSmooth(IBlockDisplayReader blockAccessIn, BlockState stateIn, BlockPos posIn, MatrixStack matrixStackIn, IVertexBuilder buffer, List<BakedQuad> list, float[] quadBounds, BitSet bitSet, AmbientOcclusionFace aoFace, int combinedOverlayIn) {
        for (BakedQuad bakedquad : list) {
            this.func_228801_a_(blockAccessIn, stateIn, posIn, bakedquad.func_178209_a(), bakedquad.func_178210_d(), quadBounds, bitSet);
            aoFace.func_239285_a_(blockAccessIn, stateIn, posIn, bakedquad.func_178210_d(), quadBounds, bitSet, bakedquad.func_239287_f_());
            this.renderQuadSmooth(blockAccessIn, stateIn, posIn, buffer, matrixStackIn.func_227866_c_(), bakedquad, aoFace.vertexColorMultiplier[0], aoFace.vertexColorMultiplier[1], aoFace.vertexColorMultiplier[2], aoFace.vertexColorMultiplier[3], aoFace.vertexBrightness[0], aoFace.vertexBrightness[1], aoFace.vertexBrightness[2], aoFace.vertexBrightness[3], combinedOverlayIn);
        }
    }

    @Shadow
    private void func_228801_a_(IBlockDisplayReader blockReaderIn, BlockState stateIn, BlockPos posIn, int[] vertexData, Direction face, @Nullable float[] quadBounds, BitSet boundsFlags) {
    }

    private void renderQuadSmooth(IBlockDisplayReader blockAccessIn, BlockState stateIn, BlockPos posIn, IVertexBuilder buffer, MatrixStack.Entry matrixEntry, BakedQuad quadIn, float colorMul0, float colorMul1, float colorMul2, float colorMul3, int brightness0, int brightness1, int brightness2, int brightness3, int combinedOverlayIn) {
        float f2;
        float f1;
        float f;
        if (quadIn.func_178212_b()) {
            int i = this.field_187499_a.func_228054_a_(stateIn, blockAccessIn, posIn, quadIn.func_178211_c());
            f = (float)(i >> 16 & 0xFF) / 255.0f;
            f1 = (float)(i >> 8 & 0xFF) / 255.0f;
            f2 = (float)(i & 0xFF) / 255.0f;
        } else {
            f = 1.0f;
            f1 = 1.0f;
            f2 = 1.0f;
        }
        buffer.func_227890_a_(matrixEntry, quadIn, new float[]{colorMul0, colorMul1, colorMul2, colorMul3}, f, f1, f2, new int[]{brightness0, brightness1, brightness2, brightness3}, combinedOverlayIn, true);
    }

    private void renderQuadsFlat(IBlockDisplayReader blockAccessIn, BlockState stateIn, BlockPos posIn, int brightnessIn, int combinedOverlayIn, boolean ownBrightness, MatrixStack matrixStackIn, IVertexBuilder buffer, List<BakedQuad> list, BitSet bitSet) {
        for (BakedQuad bakedquad : list) {
            if (ownBrightness) {
                this.func_228801_a_(blockAccessIn, stateIn, posIn, bakedquad.func_178209_a(), bakedquad.func_178210_d(), null, bitSet);
                BlockPos blockpos = bitSet.get(0) ? posIn.func_177972_a(bakedquad.func_178210_d()) : posIn;
                brightnessIn = WorldRenderer.func_228420_a_((IBlockDisplayReader)blockAccessIn, (BlockState)stateIn, (BlockPos)blockpos);
            }
            float f = blockAccessIn.func_230487_a_(bakedquad.func_178210_d(), bakedquad.func_239287_f_());
            this.renderQuadSmooth(blockAccessIn, stateIn, posIn, buffer, matrixStackIn.func_227866_c_(), bakedquad, f, f, f, f, brightnessIn, brightnessIn, brightnessIn, brightnessIn, combinedOverlayIn);
        }
    }
}

