/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api;

import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.IWorldWrapper;
import cjminecraft.doubleslabs.api.ServerWorldWrapper;
import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.WorldWrapper;
import cjminecraft.doubleslabs.api.support.ISlabSupport;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class BlockInfo
implements IBlockInfo,
INBTSerializable<CompoundTag>,
ICapabilityProvider {
    private ISlabSupport support;
    private BlockState state;
    private BlockEntity tile;
    private Level world;
    private final SlabTileEntity slab;
    private final boolean positive;

    public BlockInfo(SlabTileEntity slab, boolean positive) {
        this.slab = slab;
        this.positive = positive;
    }

    @Override
    @Nullable
    public BlockState getBlockState() {
        return this.state;
    }

    @Override
    @Nullable
    public BlockEntity getBlockEntity() {
        return this.tile;
    }

    @Override
    @Nonnull
    public Level getWorld() {
        return this.world;
    }

    @Override
    public boolean isPositive() {
        return this.positive;
    }

    @Override
    public BlockPos getPos() {
        return this.slab.m_58899_();
    }

    @Override
    @Nullable
    public ISlabSupport getSupport() {
        return this.support;
    }

    @Override
    public void setBlockState(@Nullable BlockState state) {
        if (this.state != null && this.state.m_155947_() && this.tile != null) {
            this.tile.m_155250_(this.state);
        }
        if (this.state != null && state != null && (this.state.m_60734_() != state.m_60734_() || !state.m_155947_()) && this.state.m_155947_()) {
            this.setBlockEntity(null);
        }
        if (this.state == null) {
            this.setBlockEntity(null);
        }
        this.state = state;
        ISlabSupport iSlabSupport = this.support = state == null ? null : SlabSupport.getSlabSupport((BlockGetter)this.getWorld(), this.getPos(), this.state);
        if (state != null && this.support != null && this.support.requiresWrappedWorld(this.state)) {
            if (!(this.world instanceof IWorldWrapper)) {
                this.wrapWorld(this.world);
            }
            if (state.m_155947_() && this.tile == null) {
                this.setBlockEntity(((EntityBlock)state.m_60734_()).m_142194_(this.slab.m_58899_(), this.state));
            } else if (this.tile != null) {
                this.tile.m_155250_(this.state);
            }
        }
        this.slab.markDirtyClient();
    }

    @Override
    public void setBlockEntity(@Nullable BlockEntity tile) {
        if (tile != null) {
            tile.m_142339_(this.slab.m_58904_());
            if (this.tile != null) {
                this.tile.m_142339_(this.slab.m_58904_());
                this.tile.m_7651_();
            }
            tile.onLoad();
            if (!(this.world instanceof IWorldWrapper)) {
                this.wrapWorld(this.world);
            }
            tile.m_142339_(this.getWorld());
        }
        this.tile = tile;
    }

    private void wrapWorld(Level world) {
        IWorldWrapper<ServerLevel> w = world instanceof ServerLevel ? new ServerWorldWrapper((ServerLevel)world) : new WorldWrapper(world);
        w.setPositive(this.positive);
        w.setBlockPos(this.slab.m_58899_());
        w.setStateContainer(this.slab);
        this.world = (Level)w;
    }

    public void setWorld(Level world) {
        if (this.world != null && this.world instanceof IWorldWrapper) {
            ((IWorldWrapper)this.world).setWorld(world);
        } else {
            this.world = this.tile != null || this.support != null && this.state != null && this.support.requiresWrappedWorld(this.state) ? (world instanceof ServerLevel ? new ServerWorldWrapper((ServerLevel)world) : new WorldWrapper(world)) : world;
        }
        if (this.world instanceof IWorldWrapper) {
            IWorldWrapper w = (IWorldWrapper)this.world;
            w.setPositive(this.positive);
            w.setBlockPos(this.slab.m_58899_());
            w.setStateContainer(this.slab);
        }
        if (this.tile != null) {
            this.tile.m_142339_(this.getWorld());
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.state != null) {
            nbt.m_128365_("state", (Tag)NbtUtils.m_129202_((BlockState)this.state));
        }
        if (this.tile != null) {
            nbt.m_128365_("tile", (Tag)this.tile.m_6945_(new CompoundTag()));
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("state")) {
            this.state = NbtUtils.m_129241_((CompoundTag)nbt.m_128469_("state"));
        }
        if (nbt.m_128441_("tile")) {
            this.tile = BlockEntity.m_155241_((BlockPos)this.slab.m_58899_(), (BlockState)this.state, (CompoundTag)nbt.m_128469_("tile"));
        }
        if ((this.tile != null || this.support != null && this.state != null && this.support.requiresWrappedWorld(this.state)) && this.world != null && !(this.world instanceof IWorldWrapper)) {
            this.wrapWorld(this.world);
        }
    }

    public void onLoad() {
        if (this.tile != null) {
            this.tile.m_142339_(this.getWorld());
            this.tile.onLoad();
        }
    }

    public void onChunkUnloaded() {
        if (this.tile != null) {
            this.tile.onChunkUnloaded();
        }
    }

    public void remove() {
        if (this.tile != null) {
            this.tile.m_142339_(this.slab.m_58904_());
            this.tile.m_7651_();
            this.tile = null;
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return this.tile != null ? this.tile.getCapability(cap, side) : LazyOptional.empty();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        return this.tile != null ? this.tile.getCapability(cap) : LazyOptional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockInfo blockInfo = (BlockInfo)o;
        return this.positive == blockInfo.positive && Objects.equals(this.state, blockInfo.state) && Objects.equals(this.tile, blockInfo.tile);
    }

    public int hashCode() {
        return Objects.hash(this.state, this.tile, this.positive);
    }

    public boolean triggerEvent(int pA, int pB) {
        return this.tile != null && this.tile.m_7531_(pA, pB);
    }
}

