/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api;

import cjminecraft.doubleslabs.api.containers.ContainerSupportProvider;
import cjminecraft.doubleslabs.api.containers.IContainerSupport;
import cjminecraft.doubleslabs.common.DoubleSlabs;
import cjminecraft.doubleslabs.common.util.AnnotationUtil;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ContainerSupport {
    private static List<IContainerSupport> containerSupports;

    public static void load() {
        containerSupports = AnnotationUtil.getClassInstances(ContainerSupportProvider.class, IContainerSupport.class, AnnotationUtil.MODID_PREDICATE, Comparator.comparingInt(a -> a.annotationData().getOrDefault("priority", 1000)));
        DoubleSlabs.LOGGER.info("Loaded %s container support classes", (Object)containerSupports.size());
    }

    public static IContainerSupport getSupport(Level world, BlockPos pos, BlockState state) {
        if (state.m_60734_() instanceof IContainerSupport && ((IContainerSupport)state.m_60734_()).hasSupport(world, pos, state)) {
            return (IContainerSupport)state.m_60734_();
        }
        for (IContainerSupport support : containerSupports) {
            if (!support.hasSupport(world, pos, state)) continue;
            return support;
        }
        return null;
    }
}

