/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.model;

import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.client.ClientConstants;
import cjminecraft.doubleslabs.common.config.DSConfig;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public abstract class DynamicSlabBakedModel
implements IDynamicBakedModel {
    public static final ModelProperty<IBlockInfo> NEGATIVE_BLOCK = new ModelProperty();
    public static final ModelProperty<IBlockInfo> POSITIVE_BLOCK = new ModelProperty();
    public static final ModelProperty<Boolean> RENDER_POSITIVE = new ModelProperty();

    public boolean m_7539_() {
        return ClientConstants.getFallbackModel().m_7539_();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return ClientConstants.getFallbackModel().m_6160_();
    }

    public ItemOverrides m_7343_() {
        return ClientConstants.getFallbackModel().m_7343_();
    }

    public TextureAtlasSprite getParticleIcon(@Nonnull IModelData data) {
        if (data.hasProperty(POSITIVE_BLOCK) && data.getData(POSITIVE_BLOCK) != null && ((IBlockInfo)data.getData(POSITIVE_BLOCK)).getBlockState() != null) {
            return Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(((IBlockInfo)data.getData(POSITIVE_BLOCK)).getBlockState()).getParticleIcon((IModelData)EmptyModelData.INSTANCE);
        }
        return ClientConstants.getFallbackModel().getParticleIcon((IModelData)EmptyModelData.INSTANCE);
    }

    protected boolean shouldCull(BlockState state, BlockState neighbour, Direction direction) {
        if (state == null || neighbour == null) {
            return false;
        }
        return state.m_60719_(neighbour, direction) || !ClientConstants.isTransparent(state) && !ClientConstants.isTransparent(neighbour);
    }

    public static boolean useDoubleSlabModel(BlockState state1, BlockState state2) {
        return state1.m_60734_() == state2.m_60734_() && state2.m_60713_(state2.m_60734_()) && DSConfig.CLIENT.useDoubleSlabModel(state1.m_60734_());
    }

    protected List<BakedQuad> getQuadsForState(IBlockInfo block, Direction side, Random rand) {
        BlockState state = block.getBlockState();
        if (state == null) {
            return Lists.newArrayList();
        }
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
        return this.getQuadsForState(block, model, side, rand);
    }

    protected List<BakedQuad> getQuadsForState(IBlockInfo block, BakedModel model, Direction side, Random rand) {
        BlockState state = block.getBlockState();
        if (state == null) {
            return Lists.newArrayList();
        }
        EmptyModelData tileData = block.getBlockEntity() != null ? block.getBlockEntity().getModelData() : EmptyModelData.INSTANCE;
        IModelData modelData = model.getModelData((BlockAndTintGetter)block.getWorld(), block.getPos(), state, (IModelData)tileData);
        return this.getQuadsForModel(model, state, side, rand, modelData, block.isPositive());
    }

    protected List<BakedQuad> getQuadsForModel(BakedModel model, BlockState state, Direction side, Random rand, IModelData modelData, boolean positive) {
        return model.getQuads(state, side, rand, modelData).stream().map(quad -> new BakedQuad(quad.m_111303_(), quad.m_111304_() ? quad.m_111305_() + (positive ? 1000 : 0) : -1, quad.m_111306_(), quad.m_173410_(), quad.m_111307_())).collect(Collectors.toList());
    }
}

