/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.model;

import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.api.support.IVerticalSlabSupport;
import cjminecraft.doubleslabs.client.ClientConstants;
import cjminecraft.doubleslabs.client.model.DynamicSlabBakedModel;
import cjminecraft.doubleslabs.common.blocks.VerticalSlabBlock;
import cjminecraft.doubleslabs.common.config.DSConfig;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class VerticalSlabBakedModel
extends DynamicSlabBakedModel {
    public static final VerticalSlabBakedModel INSTANCE = new VerticalSlabBakedModel();
    public static final ModelProperty<Boolean> ROTATE_POSITIVE = new ModelProperty();
    public static final ModelProperty<Boolean> ROTATE_NEGATIVE = new ModelProperty();
    private final Map<BlockState, BakedModel> models = new HashMap<BlockState, BakedModel>();

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BakedModel model;
        if (state != null && extraData.hasProperty(POSITIVE_BLOCK) && extraData.hasProperty(NEGATIVE_BLOCK)) {
            BakedModel model2;
            IHorizontalSlabSupport horizontalSlabSupport;
            IBlockInfo positiveBlock = (IBlockInfo)extraData.getData(POSITIVE_BLOCK);
            IBlockInfo negativeBlock = (IBlockInfo)extraData.getData(NEGATIVE_BLOCK);
            assert (positiveBlock != null);
            assert (negativeBlock != null);
            BlockState positiveState = positiveBlock.getBlockState();
            BlockState negativeState = negativeBlock.getBlockState();
            if (positiveState == null && negativeState == null) {
                return ClientConstants.getFallbackModel().getQuads(state, side, rand, extraData);
            }
            boolean positiveTransparent = positiveState == null || ClientConstants.isTransparent(positiveState);
            boolean negativeTransparent = negativeState == null || ClientConstants.isTransparent(negativeState);
            boolean shouldCull = positiveState != null && negativeState != null && DSConfig.CLIENT.shouldCull(positiveState.m_60734_()) && DSConfig.CLIENT.shouldCull(negativeState.m_60734_()) && (!positiveTransparent || !negativeTransparent || positiveState.m_60734_() == negativeState.m_60734_() && positiveState.m_60713_(negativeState.m_60734_()));
            boolean renderHalves = extraData.hasProperty(RENDER_POSITIVE) && extraData.getData(RENDER_POSITIVE) != null;
            boolean renderPositive = renderHalves && (Boolean)extraData.getData(RENDER_POSITIVE) != false;
            Direction direction = (Direction)state.m_61143_((Property)VerticalSlabBlock.FACING);
            if (positiveState != null && negativeState != null && VerticalSlabBakedModel.useDoubleSlabModel(positiveState, negativeState) && (horizontalSlabSupport = SlabSupport.getHorizontalSlabSupport((BlockGetter)positiveBlock.getWorld(), positiveBlock.getPos(), positiveState)) != null && horizontalSlabSupport.useDoubleSlabModel(positiveState)) {
                BlockState doubleState = horizontalSlabSupport.getStateForHalf((BlockGetter)positiveBlock.getWorld(), positiveBlock.getPos(), positiveState, SlabType.DOUBLE);
                if (ItemBlockRenderTypes.canRenderInLayer((BlockState)doubleState, (RenderType)MinecraftForgeClient.getRenderLayer()) || MinecraftForgeClient.getRenderLayer() == null) {
                    BakedModel model3 = ClientConstants.getVerticalModel(doubleState, direction);
                    return model3.getQuads(doubleState, side, rand, (IModelData)EmptyModelData.INSTANCE);
                }
                return Lists.newArrayList();
            }
            ArrayList quads = Lists.newArrayList();
            if (!(renderHalves && !renderPositive || positiveState == null || !ItemBlockRenderTypes.canRenderInLayer((BlockState)positiveState, (RenderType)MinecraftForgeClient.getRenderLayer()) && MinecraftForgeClient.getRenderLayer() != null)) {
                model2 = !extraData.hasProperty(ROTATE_POSITIVE) || (Boolean)extraData.getData(ROTATE_POSITIVE) != false ? ClientConstants.getVerticalModel(positiveState, direction) : Minecraft.m_91087_().m_91289_().m_110910_(positiveState);
                List<BakedQuad> positiveQuads = this.getQuadsForState(positiveBlock, model2, side, rand);
                if (shouldCull && (!negativeTransparent && !positiveTransparent || positiveTransparent && !negativeTransparent || positiveTransparent && negativeTransparent)) {
                    positiveQuads.removeIf(bakedQuad -> bakedQuad.m_111306_() == direction.m_122424_());
                }
                quads.addAll(positiveQuads);
            }
            if (!(renderHalves && renderPositive || negativeState == null || !ItemBlockRenderTypes.canRenderInLayer((BlockState)negativeState, (RenderType)MinecraftForgeClient.getRenderLayer()) && MinecraftForgeClient.getRenderLayer() != null)) {
                model2 = !extraData.hasProperty(ROTATE_NEGATIVE) || (Boolean)extraData.getData(ROTATE_NEGATIVE) != false ? ClientConstants.getVerticalModel(negativeState, direction) : Minecraft.m_91087_().m_91289_().m_110910_(negativeState);
                List<BakedQuad> negativeQuads = this.getQuadsForState(negativeBlock, model2, side, rand);
                if (shouldCull && (!positiveTransparent && !negativeTransparent || negativeTransparent && !positiveTransparent || positiveTransparent && negativeTransparent)) {
                    negativeQuads.removeIf(bakedQuad -> bakedQuad.m_111306_() == direction);
                }
                quads.addAll(negativeQuads);
            }
            return quads;
        }
        if (MinecraftForgeClient.getRenderLayer() == null && (model = this.models.get(state)) != null) {
            return model.getQuads(state, side, rand, extraData);
        }
        return ClientConstants.getFallbackModel().getQuads(state, side, rand, extraData);
    }

    public void addModel(BakedModel model, BlockState state) {
        this.models.put(state, model);
    }

    public BakedModel getModel(BlockState state) {
        return this.models.get(state);
    }

    private boolean rotateModel(IModelData modelData, ModelProperty<IBlockInfo> property, BlockAndTintGetter world, BlockPos pos) {
        IVerticalSlabSupport support;
        IBlockInfo blockInfo;
        if (modelData.hasProperty(property) && (blockInfo = (IBlockInfo)modelData.getData(property)) != null && blockInfo.getBlockState() != null && (support = SlabSupport.getVerticalSlabSupport((BlockGetter)world, pos, blockInfo.getBlockState())) != null) {
            return support.rotateModel((LevelAccessor)blockInfo.getWorld(), pos, blockInfo.getBlockState());
        }
        return true;
    }

    @Nonnull
    public IModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        IModelData modelData = super.getModelData(world, pos, state, tileData);
        modelData.setData(ROTATE_POSITIVE, (Object)this.rotateModel(modelData, (ModelProperty<IBlockInfo>)POSITIVE_BLOCK, world, pos));
        modelData.setData(ROTATE_NEGATIVE, (Object)this.rotateModel(modelData, (ModelProperty<IBlockInfo>)NEGATIVE_BLOCK, world, pos));
        return modelData;
    }
}

