/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.blocks;

import cjminecraft.doubleslabs.api.ContainerSupport;
import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.containers.IContainerSupport;
import cjminecraft.doubleslabs.api.support.ISlabSupport;
import cjminecraft.doubleslabs.common.blocks.DynamicSlabBlock;
import cjminecraft.doubleslabs.common.container.WrappedContainer;
import cjminecraft.doubleslabs.common.init.DSItems;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import cjminecraft.doubleslabs.common.util.RayTraceUtil;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IBlockRenderProperties;
import net.minecraftforge.client.RenderProperties;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class VerticalSlabBlock
extends DynamicSlabBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty DOUBLE = BooleanProperty.m_61465_((String)"double");

    public VerticalSlabBlock() {
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOUBLE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static Optional<IBlockInfo> getHalfState(BlockGetter world, BlockPos pos, double x, double z) {
        BlockState state = world.m_8055_(pos);
        return VerticalSlabBlock.getTile(world, pos).map(tile -> {
            IBlockInfo iBlockInfo;
            block8: {
                block7: {
                    block6: {
                        block5: {
                            if (tile.getPositiveBlockInfo().getBlockState() == null && tile.getNegativeBlockInfo().getBlockState() == null) {
                                return null;
                            }
                            if (((Direction)state.m_61143_((Property)FACING)).m_122421_() != Direction.AxisDirection.POSITIVE) break block5;
                            double d = ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X ? x : z;
                            if (!(d > 0.5)) break block6;
                            break block7;
                        }
                        if ((((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X ? x : z) < 0.5) break block7;
                    }
                    if (tile.getNegativeBlockInfo().getBlockState() != null) break block8;
                }
                if (tile.getPositiveBlockInfo().getBlockState() != null) {
                    iBlockInfo = tile.getPositiveBlockInfo();
                    return iBlockInfo;
                }
            }
            iBlockInfo = tile.getNegativeBlockInfo();
            return iBlockInfo;
        }).flatMap(block -> block == null || block.getBlockState() == null ? Optional.empty() : Optional.of(block));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IBlockRenderProperties> consumer) {
        consumer.accept(new IBlockRenderProperties(){

            public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine manager) {
                if (target.m_6662_() == HitResult.Type.BLOCK) {
                    BlockHitResult result = (BlockHitResult)target;
                    return VerticalSlabBlock.getHalfState((BlockGetter)level, result.m_82425_(), result.m_82450_().f_82479_ - (double)result.m_82425_().m_123341_(), result.m_82450_().f_82481_ - (double)result.m_82425_().m_123343_()).map(i -> VerticalSlabBlock.this.crack((ClientLevel)level, state, i.getBlockState(), result.m_82425_(), result.m_82434_(), manager)).orElse(false);
                }
                return false;
            }

            public boolean addDestroyEffects(BlockState state, Level level, BlockPos pos, ParticleEngine manager) {
                AtomicBoolean result = new AtomicBoolean(false);
                DynamicSlabBlock.runIfAvailable((BlockGetter)level, pos, i -> {
                    VerticalSlabBlock.this.destroy(manager, level, pos, state, i.getBlockState());
                    result.set(true);
                });
                return result.get();
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private void destroy(ParticleEngine manager, Level level, BlockPos pos, BlockState actualState, BlockState state) {
        if (!state.m_60795_() && !RenderProperties.get((BlockState)state).addDestroyEffects(state, level, pos, manager)) {
            VoxelShape voxelshape = actualState.m_60808_((BlockGetter)level, pos);
            double d0 = 0.25;
            voxelshape.m_83286_((p_172273_, p_172274_, p_172275_, p_172276_, p_172277_, p_172278_) -> {
                double d1 = Math.min(1.0, p_172276_ - p_172273_);
                double d2 = Math.min(1.0, p_172277_ - p_172274_);
                double d3 = Math.min(1.0, p_172278_ - p_172275_);
                int i = Math.max(2, Mth.m_14165_((double)(d1 / 0.25)));
                int j = Math.max(2, Mth.m_14165_((double)(d2 / 0.25)));
                int k = Math.max(2, Mth.m_14165_((double)(d3 / 0.25)));
                for (int l = 0; l < i; ++l) {
                    for (int i1 = 0; i1 < j; ++i1) {
                        for (int j1 = 0; j1 < k; ++j1) {
                            double d4 = ((double)l + 0.5) / (double)i;
                            double d5 = ((double)i1 + 0.5) / (double)j;
                            double d6 = ((double)j1 + 0.5) / (double)k;
                            double d7 = d4 * d1 + p_172273_;
                            double d8 = d5 * d2 + p_172274_;
                            double d9 = d6 * d3 + p_172275_;
                            manager.m_107344_((Particle)new TerrainParticle((ClientLevel)level, (double)pos.m_123341_() + d7, (double)pos.m_123342_() + d8, (double)pos.m_123343_() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, state, pos));
                        }
                    }
                }
            });
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, DOUBLE});
    }

    @Override
    public boolean m_6044_(BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.m_61143_((Property)DOUBLE) == false || super.m_6044_(world, pos, state, fluid);
    }

    @Override
    @Nonnull
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean positive;
        double value;
        BlockPos pos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(pos);
        if (state.m_60713_((Block)this)) {
            if (this.m_6864_(state, context)) {
                FluidState fluidstate = context.m_43725_().m_6425_(pos);
                return (BlockState)((BlockState)state.m_61124_((Property)DOUBLE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_ && VerticalSlabBlock.either((BlockGetter)context.m_43725_(), pos, i -> i.getSupport() != null && i.getSupport().waterloggableWhenDouble(i.getWorld(), i.getPos(), i.getBlockState()))));
            }
            return state;
        }
        BlockState newState = super.m_5573_(context);
        if (context.m_43719_().m_122434_().m_122478_()) {
            Vec3 vec = context.m_43720_().m_82492_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            double angle = Math.atan2(vec.f_82479_, vec.f_82481_) * -180.0 / Math.PI;
            Direction direction = Direction.m_122364_((double)angle);
            return (BlockState)newState.m_61124_((Property)FACING, (Comparable)direction);
        }
        double d = value = context.m_8125_().m_122434_() == Direction.Axis.Z ? context.m_43720_().f_82479_ - (double)pos.m_123341_() : context.m_43720_().f_82481_ - (double)pos.m_123343_();
        if (value > 0.25 && value < 0.75) {
            return (BlockState)newState.m_61124_((Property)FACING, (Comparable)context.m_8125_());
        }
        boolean bl = context.m_8125_().m_122421_() == Direction.AxisDirection.POSITIVE ? value > 0.5 : (positive = value < 0.5);
        if (context.m_8125_().m_122434_() == Direction.Axis.Z) {
            positive = !positive;
        }
        return (BlockState)newState.m_61124_((Property)FACING, (Comparable)(positive ? context.m_8125_().m_122427_() : context.m_8125_().m_122428_()));
    }

    public Item m_5456_() {
        return (Item)DSItems.VERTICAL_SLAB.get();
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        ItemStack stack = useContext.m_43722_();
        if (!((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue() && stack.m_41720_() == this.m_5456_()) {
            if (useContext.m_7058_()) {
                Direction direction = (Direction)state.m_61143_((Property)FACING);
                return VerticalSlabBlock.getTile((BlockGetter)useContext.m_43725_(), useContext.m_8083_()).map(tile -> {
                    boolean positive = tile.getPositiveBlockInfo().getBlockState() != null;
                    return useContext.m_43719_() == direction.m_122424_() && positive || useContext.m_43719_() == direction && !positive;
                }).orElse(false);
            }
            return true;
        }
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        BlockEntity entity;
        if (((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue()) {
            return Shapes.m_83144_();
        }
        double min = 0.0;
        double max = 0.5;
        if (((Direction)state.m_61143_((Property)FACING)).m_122421_() == Direction.AxisDirection.POSITIVE) {
            min = 0.5;
            max = 1.0;
        }
        if ((entity = world.m_7702_(pos)) instanceof SlabTileEntity) {
            boolean negative;
            SlabTileEntity tile = (SlabTileEntity)entity;
            boolean positive = tile.getPositiveBlockInfo().getBlockState() != null;
            boolean bl = negative = tile.getNegativeBlockInfo().getBlockState() != null;
            if (((Direction)state.m_61143_((Property)FACING)).m_122421_() == Direction.AxisDirection.POSITIVE && positive || ((Direction)state.m_61143_((Property)FACING)).m_122421_() == Direction.AxisDirection.NEGATIVE && negative) {
                min = 0.5;
                max = 1.0;
            } else {
                min = 0.0;
                max = 0.5;
            }
        }
        if (((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X) {
            return Shapes.m_83048_((double)min, (double)0.0, (double)0.0, (double)max, (double)1.0, (double)1.0);
        }
        return Shapes.m_83048_((double)0.0, (double)0.0, (double)min, (double)1.0, (double)1.0, (double)max);
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return VerticalSlabBlock.getTile(world, pos).map(tile -> tile.getPositiveBlockInfo().getBlockState() == null || tile.getPositiveBlockInfo().getBlockState().m_60631_((BlockGetter)tile.getPositiveBlockInfo().getWorld(), pos) || tile.getNegativeBlockInfo().getBlockState() == null || tile.getNegativeBlockInfo().getBlockState().m_60631_((BlockGetter)tile.getNegativeBlockInfo().getWorld(), pos)).orElse(false);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        Vec3 hitVec;
        BlockHitResult rayTraceResult = RayTraceUtil.rayTrace(player);
        Vec3 vec3 = hitVec = rayTraceResult.m_6662_() == HitResult.Type.BLOCK ? rayTraceResult.m_82450_() : null;
        if (hitVec == null) {
            return VerticalSlabBlock.minFloat(world, pos, i -> i.getBlockState().m_60625_(player, (BlockGetter)i.getWorld(), pos));
        }
        return VerticalSlabBlock.getHalfState(world, pos, hitVec.f_82479_ - (double)pos.m_123341_(), hitVec.f_82481_ - (double)pos.m_123343_()).map(i -> Float.valueOf(i.getBlockState().m_60625_(player, (BlockGetter)i.getWorld(), pos))).orElseGet(() -> Float.valueOf(super.m_5880_(state, player, world, pos))).floatValue();
    }

    public ItemStack getPickBlock(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return VerticalSlabBlock.getHalfState(world, pos, target.m_82450_().f_82479_ - (double)pos.m_123341_(), target.m_82450_().f_82481_ - (double)pos.m_123343_()).map(i -> i.getBlockState().getPickBlock(target, (BlockGetter)i.getWorld(), pos, player)).orElse(ItemStack.f_41583_);
    }

    @Override
    public boolean removedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (willHarvest) {
            return true;
        }
        if (player.m_7500_() && player.m_6047_() && ((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue()) {
            this.m_6240_(world, player, pos, state, world.m_7702_(pos), ItemStack.f_41583_);
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, false, fluid);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        BlockHitResult rayTraceResult = RayTraceUtil.rayTrace(player);
        Vec3 hitVec = rayTraceResult.m_82450_();
        return VerticalSlabBlock.getHalfState(world, pos, hitVec.f_82479_ - (double)pos.m_123341_(), hitVec.f_82481_ - (double)pos.m_123343_()).map(i -> i.getBlockState().canHarvestBlock((BlockGetter)i.getWorld(), i.getPos(), player)).orElse(false);
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        Vec3 hitVec;
        BlockHitResult rayTraceResult = RayTraceUtil.rayTrace(player);
        Vec3 vec3 = hitVec = rayTraceResult.m_6662_() == HitResult.Type.BLOCK ? rayTraceResult.m_82450_() : null;
        if (hitVec == null || te == null) {
            super.m_6240_(world, player, pos, state, te, stack);
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            world.m_46747_(pos);
        } else if (((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue()) {
            double distance;
            SlabTileEntity tile = (SlabTileEntity)te;
            double d = distance = ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X ? hitVec.f_82479_ - (double)pos.m_123341_() : hitVec.f_82481_ - (double)pos.m_123343_();
            boolean positive = ((Direction)state.m_61143_((Property)FACING)).m_122421_() == Direction.AxisDirection.POSITIVE ? distance > 0.5 : distance < 0.5;
            IBlockInfo blockToRemove = positive ? tile.getPositiveBlockInfo() : tile.getNegativeBlockInfo();
            player.m_36246_(Stats.f_12949_.m_12902_((Object)blockToRemove.getBlockState().m_60734_()));
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)blockToRemove.getBlockState()));
            player.m_36399_(0.005f);
            if (!player.m_7500_()) {
                VerticalSlabBlock.m_49881_((BlockState)blockToRemove.getBlockState(), (Level)world, (BlockPos)pos, null, (Entity)player, (ItemStack)stack);
            }
            blockToRemove.getBlockState().m_60753_(blockToRemove.getWorld(), pos, Blocks.f_50016_.m_49966_(), false);
            blockToRemove.setBlockState(null);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)DOUBLE, (Comparable)Boolean.valueOf(false)), 3);
        } else {
            SlabTileEntity tile = (SlabTileEntity)te;
            boolean positive = tile.getPositiveBlockInfo().getBlockState() != null;
            IBlockInfo blockToRemove = positive ? tile.getPositiveBlockInfo() : tile.getNegativeBlockInfo();
            player.m_36246_(Stats.f_12949_.m_12902_((Object)blockToRemove.getBlockState().m_60734_()));
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)blockToRemove.getBlockState()));
            player.m_36399_(0.005f);
            if (!player.m_7500_()) {
                VerticalSlabBlock.m_49881_((BlockState)blockToRemove.getBlockState(), (Level)world, (BlockPos)pos, (BlockEntity)blockToRemove.getBlockEntity(), (Entity)player, (ItemStack)stack);
            }
            blockToRemove.getBlockState().m_60753_(blockToRemove.getWorld(), pos, Blocks.f_50016_.m_49966_(), false);
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            world.m_46747_(pos);
        }
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        float f = (float)Math.ceil(entity.f_19789_ - 3.0f);
        double d0 = Math.min((double)(0.2f + f / 15.0f), 2.5);
        int numOfParticles = (Boolean)state1.m_61143_((Property)DOUBLE) != false ? (int)(75.0 * d0) : (int)(150.0 * d0);
        VerticalSlabBlock.runIfAvailable((BlockGetter)worldserver, pos, i -> worldserver.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, i.getBlockState()), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), numOfParticles, 0.0, 0.0, 0.0, (double)0.15f));
        return true;
    }

    public boolean addRunningEffects(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (world.m_5776_()) {
            VerticalSlabBlock.runIfAvailable((BlockGetter)world, pos, i -> world.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, i.getBlockState()), entity.m_20185_() + ((double)world.f_46441_.nextFloat() - 0.5) * (double)entity.m_20205_(), entity.m_142469_().f_82289_ + 0.1, entity.m_20189_() + ((double)world.f_46441_.nextFloat() - 0.5) * (double)entity.m_20205_(), -entity.m_20184_().f_82479_ * 4.0, 1.5, -entity.m_20184_().f_82481_ * 4.0));
        }
        return true;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (state.m_60734_() != this) {
            return InteractionResult.PASS;
        }
        return VerticalSlabBlock.getHalfState((BlockGetter)world, pos, hit.m_82450_().f_82479_ - (double)pos.m_123341_(), hit.m_82450_().f_82481_ - (double)pos.m_123343_()).map(i -> {
            IContainerSupport containerSupport = ContainerSupport.getSupport(i.getWorld(), pos, i.getBlockState());
            ISlabSupport slabSupport = SlabSupport.getSlabSupport((BlockGetter)i.getWorld(), pos, i.getBlockState());
            if (containerSupport != null) {
                if (!world.m_5776_()) {
                    final MenuProvider provider = containerSupport.getNamedContainerProvider(i.getWorld(), pos, i.getBlockState(), player, hand, hit);
                    NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){
                        final /* synthetic */ IBlockInfo val$i;
                        {
                            this.val$i = iBlockInfo;
                        }

                        public Component m_5446_() {
                            return provider.m_5446_();
                        }

                        @Nullable
                        public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                            return new WrappedContainer(windowId, inv, player, provider, this.val$i);
                        }
                    }, buffer -> {
                        buffer.m_130064_(i.getPos());
                        buffer.writeBoolean(i.isPositive());
                        buffer.m_130085_(containerSupport.getContainer(i.getWorld(), pos, state).getRegistryName());
                        containerSupport.writeExtraData(world, pos, state).accept((FriendlyByteBuf)buffer);
                    });
                }
                return InteractionResult.SUCCESS;
            }
            try {
                return slabSupport == null ? i.getBlockState().m_60664_(i.getWorld(), player, hand, hit) : slabSupport.onBlockActivated(i.getBlockState(), i.getWorld(), pos, player, hand, hit);
            }
            catch (Exception e) {
                return InteractionResult.PASS;
            }
        }).orElse(InteractionResult.PASS);
    }

    public void m_6256_(BlockState state, Level world, BlockPos pos, Player player) {
        BlockHitResult result = RayTraceUtil.rayTrace(player);
        if (result.m_82450_() != null) {
            VerticalSlabBlock.getHalfState((BlockGetter)world, pos, result.m_82450_().f_82479_ - (double)pos.m_123341_(), result.m_82450_().f_82481_ - (double)pos.m_123343_()).ifPresent(i -> i.getBlockState().m_60686_(i.getWorld(), pos, player));
        }
    }

    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!VerticalSlabBlock.getHalfState((BlockGetter)world, pos, entity.m_20185_() - (double)pos.m_123341_(), entity.m_20189_() - (double)pos.m_123343_()).map(i -> {
            i.getBlockState().m_60734_().m_142072_(i.getWorld(), i.getBlockState(), pos, entity, fallDistance);
            return true;
        }).orElse(false).booleanValue()) {
            super.m_142072_(world, state, pos, entity, fallDistance);
        }
    }

    public void m_5548_(BlockGetter world, Entity entity) {
        BlockPos pos = new BlockPos(entity.m_20182_()).m_7495_();
        if (world.m_8055_(pos).m_60734_() == this && !VerticalSlabBlock.getHalfState(world, pos, entity.m_20185_() - (double)pos.m_123341_(), entity.m_20189_() - (double)pos.m_123343_()).map(i -> {
            i.getBlockState().m_60734_().m_5548_((BlockGetter)i.getWorld(), entity);
            return true;
        }).orElse(false).booleanValue()) {
            super.m_5548_(world, entity);
        }
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        if (!VerticalSlabBlock.getHalfState((BlockGetter)world, pos, entity.m_20185_() - (double)pos.m_123341_(), entity.m_20189_() - (double)pos.m_123343_()).map(i -> {
            i.getBlockState().m_60734_().m_141947_(i.getWorld(), pos, i.getBlockState(), entity);
            return true;
        }).orElse(false).booleanValue()) {
            super.m_141947_(world, pos, state, entity);
        }
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter world, BlockPos pos, FluidState fluidState) {
        return (Boolean)state.m_61143_((Property)DOUBLE);
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        VerticalSlabBlock.getHalfState((BlockGetter)world, pos, entity.m_20185_() - (double)pos.m_123341_(), entity.m_20189_() - (double)pos.m_123343_()).ifPresent(i -> i.getBlockState().m_60682_(i.getWorld(), pos, entity));
    }

    public void m_5581_(Level world, BlockState state, BlockHitResult hit, Projectile projectile) {
        VerticalSlabBlock.getHalfState((BlockGetter)world, hit.m_82425_(), hit.m_82450_().f_82479_, hit.m_82450_().f_82481_).ifPresent(i -> i.getBlockState().m_60669_(i.getWorld(), i.getBlockState(), hit, projectile));
    }

    @Override
    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, @Nullable Entity entity) {
        BlockHitResult result;
        if (entity instanceof Player && (result = RayTraceUtil.rayTrace((Player)entity)).m_82425_().equals((Object)pos)) {
            return VerticalSlabBlock.getHalfState((BlockGetter)world, pos, result.m_82450_().f_82479_ - (double)pos.m_123341_(), result.m_82450_().f_82481_ - (double)pos.m_123343_()).map(i -> i.getBlockState().getSoundType((LevelReader)i.getWorld(), pos, entity)).orElseGet(() -> super.getSoundType(state, world, pos, entity));
        }
        return VerticalSlabBlock.getAvailable((BlockGetter)world, pos).map(i -> i.getBlockState().getSoundType((LevelReader)i.getWorld(), pos, null)).orElseGet(() -> super.getSoundType(state, world, pos, null));
    }

    @Override
    public void m_141997_(BlockState state, Level world, BlockPos pos, Biome.Precipitation precipitation) {
        VerticalSlabBlock.runIfAvailable((BlockGetter)world, pos, i -> i.getBlockState().m_60734_().m_141997_(i.getBlockState(), i.getWorld(), pos, precipitation));
    }

    @Override
    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        return VerticalSlabBlock.both(world, pos, i -> i.getBlockState().canSustainPlant((BlockGetter)i.getWorld(), pos, facing, plantable));
    }
}

