/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.config;

import cjminecraft.doubleslabs.common.capability.config.IPlayerConfig;
import cjminecraft.doubleslabs.common.capability.config.PlayerConfigCapability;
import cjminecraft.doubleslabs.common.capability.config.PlayerConfigContainer;
import cjminecraft.doubleslabs.common.config.DSConfig;
import cjminecraft.doubleslabs.common.network.PacketHandler;
import cjminecraft.doubleslabs.common.network.packet.config.RequestPlayerConfigPacket;
import cjminecraft.doubleslabs.common.network.packet.config.UpdateServerPlayerConfigPacket;
import cjminecraft.doubleslabs.common.placement.VerticalSlabPlacementMethod;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="doubleslabs")
public class ConfigEventsHandler {
    @SubscribeEvent
    public static void attachConfigCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(PlayerConfigCapability.PLAYER_CONFIG_RESOURCE_LOCATION, (ICapabilityProvider)new PlayerConfigContainer());
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        event.getPlayer().getCapability(PlayerConfigCapability.PLAYER_CONFIG).ifPresent(config -> PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new RequestPlayerConfigPacket()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onFileChange(ModConfigEvent.Reloading event) {
        if (event.getConfig().getModId().equals("doubleslabs") && event.getConfig().getType() == ModConfig.Type.CLIENT) {
            if (Minecraft.m_91087_().f_91074_ == null) {
                return;
            }
            Minecraft.m_91087_().f_91074_.getCapability(PlayerConfigCapability.PLAYER_CONFIG).ifPresent(config -> {
                if (config.getVerticalSlabPlacementMethod() != DSConfig.CLIENT.verticalSlabPlacementMethod.get()) {
                    config.setVerticalSlabPlacementMethod((VerticalSlabPlacementMethod)((Object)((Object)DSConfig.CLIENT.verticalSlabPlacementMethod.get())));
                    PacketHandler.INSTANCE.sendToServer((Object)new UpdateServerPlayerConfigPacket((IPlayerConfig)config));
                }
            });
        }
    }
}

