/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.config;

import cjminecraft.doubleslabs.common.placement.VerticalSlabPlacementMethod;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class DSConfig {
    public static final Client CLIENT;
    public static final Server SERVER;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ForgeConfigSpec SERVER_SPEC;

    private static boolean isItemPresent(ForgeConfigSpec.ConfigValue<List<String>> option, Item item) {
        if (item.getRegistryName() == null) {
            return false;
        }
        return ((List)option.get()).stream().anyMatch(entry -> {
            if (entry.startsWith("*")) {
                return true;
            }
            if (entry.startsWith("#")) {
                ResourceLocation tagLocation = new ResourceLocation(entry.substring(1));
                Tag tag = ItemTags.m_13193_().m_13404_(tagLocation);
                return tag != null && tag.m_8110_((Object)item);
            }
            return entry.equals(item.getRegistryName().toString());
        });
    }

    private static boolean isBlockPresent(ForgeConfigSpec.ConfigValue<List<String>> option, Block block) {
        if (block.getRegistryName() == null) {
            return false;
        }
        return ((List)option.get()).stream().anyMatch(entry -> {
            if (entry.startsWith("*")) {
                return true;
            }
            if (entry.startsWith("#")) {
                ResourceLocation tagLocation = new ResourceLocation(entry.substring(1));
                Tag tag = BlockTags.m_13115_().m_13404_(tagLocation);
                return tag != null && tag.m_8110_((Object)block);
            }
            return entry.equals(block.getRegistryName().toString());
        });
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<List<String>> uvlockModelBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<String>> slabCullBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<String>> useDoubleSlabModelBlacklist;
        public final ForgeConfigSpec.EnumValue<VerticalSlabPlacementMethod> verticalSlabPlacementMethod;

        Client(ForgeConfigSpec.Builder builder) {
            builder.push("Client Only Settings");
            this.uvlockModelBlacklist = builder.comment(new String[]{"The list of slabs (or tags) which should NOT have uvlock enabled when creating a vertical slab model.", "This often yields better looking results with wooden planks and does not necessarily improve the look of all vertical slabs", "Use the wildcard value * to enable this feature for all slabs"}).translation("doubleslabs.configgui.uvlockModels").define("uvlockModelBlacklist", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:smooth_stone_slab", "minecraft:sandstone_slab", "minecraft:cut_sandstone_slab", "minecraft:red_sandstone_slab", "minecraft:cut_red_sandstone_slab", "minecraft:prismarine_brick_slab", "minecraft:campfire", "minecraft:soul_campfire", "doubleslabs:raised_campfire", "doubleslabs:raised_soul_campfire", "byg:boric_campfire", "doubleslabs:raised_boric_campfire", "byg:cryptic_campfire", "doubleslabs:raised_cryptic_campfire", "endergetic:ender_campfire", "doubleslabs:raised_ender_campfire"}));
            this.slabCullBlacklist = builder.comment(new String[]{"The list of slabs (or tags) which should not be culled when combined", "Use the wildcard value * to disable this feature for all slabs"}).translation("doubleslabs.configgui.slabCullBlacklist").define("slabCullBlacklist", (Object)Lists.newArrayList((Object[])new String[]{"#minecraft:campfires"}));
            this.useDoubleSlabModelBlacklist = builder.comment(new String[]{"The list of slabs (or tags) which should not use the double variant model when two of the same slab are combined together", "Use the wildcard value * to disable this feature for all slabs"}).translation("doubleslabs.configgui.useDoubleSlabModelBlacklist").define("useDoubleSlabModelBlacklist", new ArrayList());
            builder.pop();
            builder.push("Player Settings (synced with servers)");
            this.verticalSlabPlacementMethod = builder.comment(new String[]{"Which placement method to use to place vertical slabs", "This is a per user option and can be any of the following values:", "PLACE_WHEN_SNEAKING - Only place vertical slabs when you are sneaking", "DYNAMIC - Place vertical slabs when clicking on the side of a block unless you are sneaking and place vertical slabs when sneaking when looking at the top or bottom face of a block but place regular slabs by default"}).translation("doubleslabs.configgui.verticalSlabPlacementMethod").defineEnum("verticalSlabPlacementMethod", (Enum)VerticalSlabPlacementMethod.DYNAMIC);
            builder.pop();
        }

        public boolean uvlock(Block block) {
            return !DSConfig.isBlockPresent(this.uvlockModelBlacklist, block);
        }

        public boolean uvlock(Item item) {
            return !DSConfig.isItemPresent(this.uvlockModelBlacklist, item);
        }

        public boolean shouldCull(Block block) {
            return !DSConfig.isBlockPresent(this.slabCullBlacklist, block);
        }

        public boolean useDoubleSlabModel(Block block) {
            return !DSConfig.isBlockPresent(this.useDoubleSlabModelBlacklist, block);
        }
    }

    public static class Server {
        public final ForgeConfigSpec.ConfigValue<List<String>> slabBlacklist;
        public final ForgeConfigSpec.ConfigValue<List<String>> verticalSlabBlacklist;
        public final ForgeConfigSpec.BooleanValue replaceSameSlab;
        public final ForgeConfigSpec.BooleanValue disableVerticalSlabPlacement;
        public final ForgeConfigSpec.ConfigValue<List<String>> verticalSlabCraftingBlacklist;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("General Configuration").push("general");
            this.slabBlacklist = builder.comment(new String[]{"The list of slabs (or tags) to ignore when creating double slabs", "Example: minecraft:purpur_slab"}).translation("doubleslabs.configgui.slabBlacklist").define("slabBlacklist", new ArrayList());
            this.verticalSlabBlacklist = builder.comment(new String[]{"The list of slabs (or tags) to ignore when creating vertical slabs", "Example: minecraft:purpur_slab", "Example: #minecraft:slabs"}).translation("doubleslabs.configgui.verticalSlabBlacklist").define("verticalSlabBlacklist", new ArrayList());
            this.replaceSameSlab = builder.comment("Whether to use the custom double slab when combining slabs of the same type").translation("doubleslabs.configgui.replaceSameSlab").define("replaceSameSlab", true);
            this.disableVerticalSlabPlacement = builder.comment("Whether to disable the placement of vertical slabs from regular horizontal slabs").translation("doubleslabs.configgui.disableVerticalSlabPlacement").define("disableVerticalSlabPlacement", false);
            this.verticalSlabCraftingBlacklist = builder.comment(new String[]{"The list of slabs (or tags) to ignore when trying to convert between a regular slab and a vertical slab item", "Use the wildcard value * to disable this feature for all slabs"}).translation("doubleslabs.configgui.verticalSlabCraftingBlacklist").define("verticalSlabCraftingBlacklist", new ArrayList());
            builder.pop();
        }

        public boolean isBlacklistedHorizontalSlab(Block block) {
            return DSConfig.isBlockPresent(this.slabBlacklist, block);
        }

        public boolean isBlacklistedVerticalSlab(Block block) {
            return DSConfig.isBlockPresent(this.verticalSlabBlacklist, block);
        }

        public boolean isBlacklistedCraftingItem(Item item) {
            return DSConfig.isItemPresent(this.verticalSlabCraftingBlacklist, item);
        }
    }
}

