/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.items;

import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.common.DoubleSlabs;
import cjminecraft.doubleslabs.common.blocks.VerticalSlabBlock;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import cjminecraft.doubleslabs.common.placement.PlacementHandler;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class VerticalSlabItem
extends BlockItem {
    public VerticalSlabItem() {
        super((Block)DSBlocks.VERTICAL_SLAB.get(), new Item.Properties().m_41491_(DoubleSlabs.TAB));
    }

    public static ItemStack setStack(ItemStack stack, ItemStack toSet) {
        ItemStack copy = toSet.m_41777_();
        copy.m_41764_(1);
        stack.m_41700_("item", (Tag)copy.serializeNBT());
        return stack;
    }

    public static ItemStack getStack(ItemStack stack) {
        CompoundTag nbt = stack.m_41698_("item");
        return ItemStack.m_41712_((CompoundTag)nbt);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.m_41389_(tab)) {
            ForgeRegistries.ITEMS.forEach(item -> {
                if (SlabSupport.isHorizontalSlab(item)) {
                    ItemStack stack = new ItemStack((ItemLike)this);
                    items.add((Object)VerticalSlabItem.setStack(stack, item.m_7968_()));
                }
            });
        }
    }

    protected boolean m_7429_(BlockPlaceContext context, BlockState state) {
        boolean result = super.m_7429_(context, state);
        if (context.m_43723_() != null) {
            VerticalSlabBlock.getTile((BlockGetter)context.m_43725_(), context.m_8083_()).ifPresent(tile -> {
                ItemStack slabStack = VerticalSlabItem.getStack(context.m_43722_());
                IHorizontalSlabSupport support = SlabSupport.getHorizontalSlabSupport(slabStack, context.m_43723_(), InteractionHand.MAIN_HAND);
                if (support != null) {
                    boolean positive = tile.getPositiveBlockInfo().getBlockState() == null;
                    BlockState slabState = PlacementHandler.getStateFromSupport(context.m_43725_(), context.m_8083_(), context.m_43723_(), InteractionHand.MAIN_HAND, slabStack, positive ? SlabType.BOTTOM : SlabType.TOP, support);
                    if (positive) {
                        tile.getPositiveBlockInfo().setBlockState(slabState);
                    } else {
                        tile.getNegativeBlockInfo().setBlockState(slabState);
                    }
                }
            });
        }
        return result;
    }

    public String m_5671_(ItemStack stack) {
        return VerticalSlabItem.getStack(stack).m_41778_();
    }

    public Component m_7626_(ItemStack stack) {
        return new TranslatableComponent("item.vertical_slab.prefix", new Object[]{new TranslatableComponent(this.m_5671_(stack))});
    }
}

