/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.network.packet.config;

import cjminecraft.doubleslabs.common.DoubleSlabs;
import cjminecraft.doubleslabs.common.capability.config.IPlayerConfig;
import cjminecraft.doubleslabs.common.capability.config.PlayerConfig;
import cjminecraft.doubleslabs.common.capability.config.PlayerConfigCapability;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class UpdateServerPlayerConfigPacket {
    private final IPlayerConfig config;

    public UpdateServerPlayerConfigPacket(IPlayerConfig config) {
        this.config = config;
    }

    public static UpdateServerPlayerConfigPacket decode(FriendlyByteBuf buf) {
        PlayerConfig config = new PlayerConfig();
        config.deserializeNBT(buf.m_130260_());
        return new UpdateServerPlayerConfigPacket(config);
    }

    public static void handle(UpdateServerPlayerConfigPacket message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            ctx.getSender().getCapability(PlayerConfigCapability.PLAYER_CONFIG).ifPresent(config -> {
                config.setVerticalSlabPlacementMethod(message.config.getVerticalSlabPlacementMethod());
                config.setPlaceVerticalSlabs(message.config.placeVerticalSlabs());
            });
            DoubleSlabs.LOGGER.debug("Received config update message from player %s: Placement Method - %s, Place Vertical Slab Keybinding Down - %s", (Object)ctx.getSender().m_6302_(), (Object)message.config.getVerticalSlabPlacementMethod(), (Object)message.config.placeVerticalSlabs());
        });
        ctx.setPacketHandled(true);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130079_(this.config.serializeNBT());
    }
}

