/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.network.packet.modelrefresh;

import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public record UpdateSlabPacket(BlockPos pos, boolean positive, BlockState newState) {
    public static UpdateSlabPacket decode(FriendlyByteBuf buf) {
        return new UpdateSlabPacket(buf.m_130135_(), buf.readBoolean(), NbtUtils.m_129241_((CompoundTag)Objects.requireNonNull(buf.m_130260_())));
    }

    public static void handle(UpdateSlabPacket message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            BlockEntity entity;
            if (Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91073_.m_46749_(message.pos) && (entity = Minecraft.m_91087_().f_91073_.m_7702_(message.pos)) instanceof SlabTileEntity) {
                SlabTileEntity slab = (SlabTileEntity)entity;
                if (message.positive) {
                    slab.getPositiveBlockInfo().setBlockState(message.newState);
                } else {
                    slab.getNegativeBlockInfo().setBlockState(message.newState);
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeBoolean(this.positive);
        buf.m_130079_(NbtUtils.m_129202_((BlockState)this.newState));
    }
}

