/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.placement;

import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.api.support.IVerticalSlabSupport;
import cjminecraft.doubleslabs.common.blocks.DoubleSlabBlock;
import cjminecraft.doubleslabs.common.blocks.DynamicSlabBlock;
import cjminecraft.doubleslabs.common.blocks.VerticalSlabBlock;
import cjminecraft.doubleslabs.common.capability.config.IPlayerConfig;
import cjminecraft.doubleslabs.common.capability.config.PlayerConfig;
import cjminecraft.doubleslabs.common.capability.config.PlayerConfigCapability;
import cjminecraft.doubleslabs.common.config.DSConfig;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import cjminecraft.doubleslabs.common.init.DSItems;
import cjminecraft.doubleslabs.common.items.VerticalSlabItem;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import cjminecraft.doubleslabs.common.util.DoubleSlabPlaceContext;
import cjminecraft.doubleslabs.common.util.RayTraceUtil;
import java.util.function.Consumer;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="doubleslabs")
public class PlacementHandler {
    private static boolean activateBlock(Level world, BlockPos pos, Player player, InteractionHand hand, Consumer<InteractionResult> cancelEventConsumer) {
        boolean flag;
        boolean useItem = !player.m_21205_().doesSneakBypassUse((LevelReader)world, pos, player) || !player.m_21206_().doesSneakBypassUse((LevelReader)world, pos, player);
        boolean bl = flag = player.m_36341_() && useItem;
        if (!flag) {
            InteractionResult result = world.m_8055_(pos).m_60664_(world, player, hand, RayTraceUtil.rayTrace(player).m_82430_(pos));
            if (result.m_19077_()) {
                cancelEventConsumer.accept(result);
            }
            return result.m_19077_();
        }
        return false;
    }

    private static BlockState prepareState(BlockState state) {
        if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
            return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public static BlockPlaceContext getUseContext(Player player, InteractionHand hand, ItemStack stack) {
        return new BlockPlaceContext(player, hand, stack, RayTraceUtil.rayTrace(player));
    }

    public static BlockPlaceContext getUseContext(Player player, InteractionHand hand, ItemStack stack, BlockPos pos) {
        return new DoubleSlabPlaceContext(player, hand, stack, RayTraceUtil.rayTrace(player).m_82430_(pos));
    }

    public static BlockState getStateFromSupport(Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack stack, SlabType half, IHorizontalSlabSupport support) {
        return support.getStateForHalf((BlockGetter)world, pos, support.getStateFromStack(stack, PlacementHandler.getUseContext(player, hand, stack, pos)), half);
    }

    public static BlockState getStateFromSupport(Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack stack, Direction direction, IVerticalSlabSupport support) {
        return support.getStateForDirection((BlockGetter)world, pos, support.getStateFromStack(stack, PlacementHandler.getUseContext(player, hand, stack, pos)), direction);
    }

    private static void finishBlockPlacement(Level world, BlockPos pos, BlockState state, Player player, ItemStack stack, Consumer<InteractionResult> cancel) {
        SoundType soundType = state.getSoundType((LevelReader)world, pos, (Entity)player);
        world.m_5594_(player, pos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
        cancel.accept(InteractionResult.SUCCESS);
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, pos, stack);
        }
    }

    private static boolean placeSlab(Level world, BlockPos pos, BlockState state, BlockPlaceContext context, Consumer<SlabTileEntity> setStates) {
        if (!context.m_7059_()) {
            return false;
        }
        if (world.m_7731_(pos, state, 11)) {
            BlockEntity tileEntity = world.m_7702_(pos);
            if (tileEntity instanceof SlabTileEntity) {
                SlabTileEntity tile = (SlabTileEntity)tileEntity;
                setStates.accept(tile);
            }
            return true;
        }
        return false;
    }

    private static boolean placeSlab(Level world, BlockPos pos, BlockState state, BlockPlaceContext context, BlockState negativeState, BlockState positiveState) {
        return PlacementHandler.placeSlab(world, pos, state, context, tile -> {
            tile.getNegativeBlockInfo().setBlockState(negativeState);
            tile.getPositiveBlockInfo().setBlockState(positiveState);
        });
    }

    private static boolean shouldPlaceVerticalSlab(Player player, Direction face) {
        if (((Boolean)DSConfig.SERVER.disableVerticalSlabPlacement.get()).booleanValue()) {
            return false;
        }
        IPlayerConfig config = (IPlayerConfig)player.getCapability(PlayerConfigCapability.PLAYER_CONFIG).orElse((Object)new PlayerConfig());
        return config.getVerticalSlabPlacementMethod().shouldPlace(player, face, config.placeVerticalSlabs());
    }

    @SubscribeEvent
    public static void onItemUse(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getItemStack().m_41619_()) {
            ItemStack stack = event.getItemStack();
            Level world = event.getWorld();
            Player player = event.getPlayer();
            InteractionHand hand = event.getHand();
            Direction face = event.getFace();
            BlockPos pos = event.getPos();
            if (stack.m_41720_() == DSItems.VERTICAL_SLAB.get()) {
                stack = VerticalSlabItem.getStack(stack);
            }
            IHorizontalSlabSupport horizontalSlabItemSupport = SlabSupport.getHorizontalSlabSupport(stack, player, hand);
            Consumer<InteractionResult> cancel = resultType -> {
                event.setCanceled(true);
                event.setCancellationResult(resultType);
            };
            BlockState state = world.m_8055_(pos);
            BlockPlaceContext context = PlacementHandler.getUseContext(player, hand, stack, pos);
            if (horizontalSlabItemSupport == null) {
                BlockEntity tileEntity;
                IVerticalSlabSupport verticalSlabItemSupport = SlabSupport.getVerticalSlabSupport(stack, player, hand);
                if (verticalSlabItemSupport == null) {
                    return;
                }
                boolean offset = false;
                if (state.m_60734_() != DSBlocks.VERTICAL_SLAB.get() && world.m_8055_(pos.m_142300_(face)).m_60734_() == DSBlocks.VERTICAL_SLAB.get()) {
                    pos = pos.m_142300_(face);
                    state = world.m_8055_(pos);
                    tileEntity = world.m_7702_(pos);
                    offset = true;
                    if (tileEntity instanceof SlabTileEntity) {
                        Direction direction = face = ((SlabTileEntity)tileEntity).getPositiveBlockInfo().getBlockState() != null ? ((Direction)state.m_61143_((Property)VerticalSlabBlock.FACING)).m_122424_() : (Direction)state.m_61143_((Property)VerticalSlabBlock.FACING);
                    }
                }
                if (state.m_60734_() == DSBlocks.VERTICAL_SLAB.get()) {
                    if (!(((Boolean)state.m_61143_((Property)VerticalSlabBlock.DOUBLE)).booleanValue() || face != ((Direction)state.m_61143_((Property)VerticalSlabBlock.FACING)).m_122424_() || !((tileEntity = world.m_7702_(pos)) instanceof SlabTileEntity) || event.getPlayer().m_6047_() || face == state.m_61143_((Property)VerticalSlabBlock.FACING) && ((SlabTileEntity)tileEntity).getPositiveBlockInfo().getBlockState() != null)) {
                        BlockState newState = (BlockState)state.m_61124_((Property)VerticalSlabBlock.DOUBLE, (Comparable)Boolean.valueOf(true));
                        BlockState slabState = PlacementHandler.getStateFromSupport(world, pos, player, hand, stack, ((SlabTileEntity)tileEntity).getPositiveBlockInfo().getBlockState() != null ? face.m_122424_() : face, verticalSlabItemSupport);
                        if (DSConfig.SERVER.isBlacklistedVerticalSlab(slabState.m_60734_())) {
                            return;
                        }
                        if (!offset && PlacementHandler.activateBlock(world, pos, player, hand, cancel)) {
                            return;
                        }
                        if (PlacementHandler.placeSlab(world, pos, newState, context, tile -> {
                            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                                tile.getNegativeBlockInfo().setBlockState(slabState);
                            } else {
                                tile.getPositiveBlockInfo().setBlockState(slabState);
                            }
                        })) {
                            PlacementHandler.finishBlockPlacement(world, pos, slabState, player, event.getItemStack(), cancel);
                        }
                    }
                } else {
                    IVerticalSlabSupport blockSupport = SlabSupport.getVerticalSlabSupport((BlockGetter)world, pos, state);
                    if (blockSupport == null) {
                        offset = true;
                        blockSupport = SlabSupport.getVerticalSlabSupport((BlockGetter)world, pos = pos.m_142300_(face), state = world.m_8055_(pos));
                        if (blockSupport == null) {
                            return;
                        }
                        face = blockSupport.getDirection((BlockGetter)event.getWorld(), pos, state).m_122424_();
                    }
                    if (DSConfig.SERVER.isBlacklistedVerticalSlab(state.m_60734_())) {
                        return;
                    }
                    if (!offset && PlacementHandler.activateBlock(world, pos, player, hand, cancel)) {
                        return;
                    }
                    state = PlacementHandler.prepareState(state);
                    Direction direction = blockSupport.getDirection((BlockGetter)event.getWorld(), pos, state);
                    if (face == direction.m_122424_()) {
                        BlockState finalState;
                        BlockState slabState = PlacementHandler.getStateFromSupport(world, pos, player, hand, stack, direction.m_122424_(), verticalSlabItemSupport);
                        if (DSConfig.SERVER.isBlacklistedVerticalSlab(slabState.m_60734_())) {
                            return;
                        }
                        BlockState newState = (BlockState)((BlockState)((DynamicSlabBlock)DSBlocks.VERTICAL_SLAB.get()).m_49966_().m_61124_((Property)VerticalSlabBlock.FACING, (Comparable)direction)).m_61124_((Property)VerticalSlabBlock.DOUBLE, (Comparable)Boolean.valueOf(true));
                        if (PlacementHandler.placeSlab(world, pos, newState, context, arg_0 -> PlacementHandler.lambda$onItemUse$3(slabState, finalState = state, arg_0))) {
                            PlacementHandler.finishBlockPlacement(world, pos, slabState, player, event.getItemStack(), cancel);
                        }
                    }
                }
            } else {
                FluidState fluidstate;
                IHorizontalSlabSupport horizontalSlabSupport = SlabSupport.getHorizontalSlabSupport((BlockGetter)world, pos, state);
                boolean verticalSlab = state.m_60734_() == DSBlocks.VERTICAL_SLAB.get() && (Boolean)state.m_61143_((Property)VerticalSlabBlock.DOUBLE) == false && (((SlabTileEntity)world.m_7702_(pos)).getPositiveBlockInfo().getBlockState() != null ? face == ((Direction)state.m_61143_((Property)VerticalSlabBlock.FACING)).m_122424_() : face == state.m_61143_((Property)VerticalSlabBlock.FACING));
                boolean offset = false;
                if (horizontalSlabSupport == null && !verticalSlab) {
                    IVerticalSlabSupport verticalSlabSupport = SlabSupport.getVerticalSlabSupport((BlockGetter)world, pos, state);
                    if (verticalSlabSupport != null) {
                        if (DSConfig.SERVER.isBlacklistedVerticalSlab(state.m_60734_())) {
                            return;
                        }
                        Direction direction = verticalSlabSupport.getDirection((BlockGetter)world, pos, state);
                        if (face == direction) {
                            state = PlacementHandler.prepareState(state);
                            if (PlacementHandler.activateBlock(world, pos, player, hand, cancel)) {
                                return;
                            }
                            BlockState slabState = PlacementHandler.getStateFromSupport(world, pos, player, hand, stack, SlabType.BOTTOM, horizontalSlabItemSupport);
                            BlockState newState = (BlockState)((BlockState)((DynamicSlabBlock)DSBlocks.VERTICAL_SLAB.get()).m_5573_(context).m_61124_((Property)VerticalSlabBlock.DOUBLE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)VerticalSlabBlock.FACING, (Comparable)direction);
                            if (PlacementHandler.placeSlab(world, pos, newState, context, state, slabState)) {
                                PlacementHandler.finishBlockPlacement(world, pos, slabState, player, event.getItemStack(), cancel);
                            }
                            return;
                        }
                    }
                    BlockPos newPos = pos.m_142300_(face);
                    BlockState newState = world.m_8055_(newPos);
                    offset = true;
                    verticalSlab = newState.m_60734_() == DSBlocks.VERTICAL_SLAB.get() && (Boolean)newState.m_61143_((Property)VerticalSlabBlock.DOUBLE) == false;
                    horizontalSlabSupport = SlabSupport.getHorizontalSlabSupport((BlockGetter)world, newPos, newState);
                    if (horizontalSlabSupport == null && !verticalSlab) {
                        verticalSlabSupport = SlabSupport.getVerticalSlabSupport((BlockGetter)world, newPos, newState);
                        if (verticalSlabSupport != null) {
                            if (DSConfig.SERVER.isBlacklistedVerticalSlab(newState.m_60734_())) {
                                return;
                            }
                            newState = PlacementHandler.prepareState(newState);
                            Direction direction = verticalSlabSupport.getDirection((BlockGetter)world, newPos, newState);
                            BlockState slabState = PlacementHandler.getStateFromSupport(world, newPos, player, hand, stack, SlabType.BOTTOM, horizontalSlabItemSupport);
                            BlockState verticalSlabState = (BlockState)((BlockState)((DynamicSlabBlock)DSBlocks.VERTICAL_SLAB.get()).m_5573_(context).m_61124_((Property)VerticalSlabBlock.DOUBLE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)VerticalSlabBlock.FACING, (Comparable)direction);
                            if (PlacementHandler.placeSlab(world, newPos, verticalSlabState, context, newState, slabState)) {
                                PlacementHandler.finishBlockPlacement(world, pos, slabState, player, event.getItemStack(), cancel);
                            }
                        } else if (PlacementHandler.shouldPlaceVerticalSlab(player, face)) {
                            BlockState slabState;
                            if (state.m_60629_(context)) {
                                newState = state;
                                newPos = pos;
                                if (PlacementHandler.activateBlock(world, pos, player, hand, cancel)) {
                                    return;
                                }
                            } else if (!newState.m_60629_(context)) {
                                return;
                            }
                            if (DSConfig.SERVER.isBlacklistedVerticalSlab((slabState = PlacementHandler.getStateFromSupport(world, newPos, player, hand, stack, SlabType.BOTTOM, horizontalSlabItemSupport)).m_60734_())) {
                                return;
                            }
                            if (PlacementHandler.activateBlock(world, newPos, player, hand, cancel)) {
                                return;
                            }
                            context = PlacementHandler.getUseContext(player, hand, stack, newPos);
                            BlockState verticalSlabState = ((DynamicSlabBlock)DSBlocks.VERTICAL_SLAB.get()).m_5573_(context);
                            if (PlacementHandler.placeSlab(world, newPos, verticalSlabState, context, tile -> tile.getPositiveBlockInfo().setBlockState(slabState))) {
                                PlacementHandler.finishBlockPlacement(world, newPos, slabState, player, event.getItemStack(), cancel);
                            }
                        }
                        return;
                    }
                    state = newState;
                    pos = newPos;
                    if (horizontalSlabSupport != null) {
                        Direction direction = face = horizontalSlabSupport.getHalf((BlockGetter)world, pos, newState) == SlabType.BOTTOM ? Direction.UP : Direction.DOWN;
                    }
                }
                if (verticalSlab) {
                    if (!offset && PlacementHandler.activateBlock(world, pos, player, hand, cancel)) {
                        return;
                    }
                    BlockEntity tileEntity = world.m_7702_(pos);
                    if (tileEntity instanceof SlabTileEntity && !player.m_6047_() && (face != state.m_61143_((Property)VerticalSlabBlock.FACING) || ((SlabTileEntity)tileEntity).getPositiveBlockInfo().getBlockState() == null)) {
                        SlabTileEntity tile2 = (SlabTileEntity)tileEntity;
                        fluidstate = world.m_6425_(pos);
                        BlockState newState = (BlockState)((BlockState)state.m_61124_((Property)VerticalSlabBlock.DOUBLE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)VerticalSlabBlock.WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_ && VerticalSlabBlock.either((BlockGetter)world, pos, i -> i.getSupport() != null && i.getSupport().waterloggableWhenDouble(i.getWorld(), i.getPos(), i.getBlockState()))));
                        BlockState slabState = PlacementHandler.getStateFromSupport(world, pos, player, hand, stack, tile2.getPositiveBlockInfo().getBlockState() != null ? SlabType.TOP : SlabType.BOTTOM, horizontalSlabItemSupport);
                        if (DSConfig.SERVER.isBlacklistedVerticalSlab(slabState.m_60734_())) {
                            return;
                        }
                        if (PlacementHandler.placeSlab(world, pos, newState, context, t -> {
                            if (t.getPositiveBlockInfo().getBlockState() != null) {
                                t.getNegativeBlockInfo().setBlockState(slabState);
                            } else {
                                t.getPositiveBlockInfo().setBlockState(slabState);
                            }
                        })) {
                            PlacementHandler.finishBlockPlacement(world, pos, slabState, player, event.getItemStack(), cancel);
                        }
                        return;
                    }
                }
                if (horizontalSlabSupport == null) {
                    return;
                }
                if (DSConfig.SERVER.isBlacklistedHorizontalSlab(state.m_60734_())) {
                    return;
                }
                SlabType half = horizontalSlabSupport.getHalf((BlockGetter)world, pos, state);
                if (half == SlabType.DOUBLE) {
                    return;
                }
                if (!((Boolean)DSConfig.SERVER.replaceSameSlab.get()).booleanValue() && horizontalSlabItemSupport.equals(horizontalSlabSupport) && horizontalSlabSupport.areSame(world, pos, state, stack)) {
                    return;
                }
                if (face == Direction.UP && half == SlabType.BOTTOM || face == Direction.DOWN && half == SlabType.TOP) {
                    BlockEntity tileEntity;
                    BlockState finalState1;
                    state = PlacementHandler.prepareState(state);
                    if (!offset && PlacementHandler.activateBlock(world, pos, player, hand, cancel)) {
                        return;
                    }
                    BlockState slabState = PlacementHandler.getStateFromSupport(world, pos, player, hand, stack, half == SlabType.BOTTOM ? SlabType.TOP : SlabType.BOTTOM, horizontalSlabItemSupport);
                    if (DSConfig.SERVER.isBlacklistedHorizontalSlab(slabState.m_60734_())) {
                        return;
                    }
                    fluidstate = world.m_6425_(pos);
                    BlockState newState = (BlockState)((DynamicSlabBlock)DSBlocks.DOUBLE_SLAB.get()).m_5573_(context).m_61124_((Property)DoubleSlabBlock.WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_ && (horizontalSlabItemSupport.waterloggableWhenDouble(world, pos, slabState) || horizontalSlabSupport.waterloggableWhenDouble(world, pos, state))));
                    if (PlacementHandler.placeSlab(world, pos, newState, offset ? context : PlacementHandler.getUseContext(player, hand, stack, pos), arg_0 -> PlacementHandler.lambda$onItemUse$7(half, finalState1 = state, tileEntity = world.m_7702_(pos), slabState, arg_0))) {
                        PlacementHandler.finishBlockPlacement(world, pos, slabState, player, event.getItemStack(), cancel);
                    }
                }
            }
        }
    }

    private static /* synthetic */ void lambda$onItemUse$7(SlabType half, BlockState finalState1, BlockEntity tileEntity, BlockState slabState, SlabTileEntity tile) {
        if (half == SlabType.BOTTOM) {
            tile.getNegativeBlockInfo().setBlockState(finalState1);
            tile.getNegativeBlockInfo().setBlockEntity(tileEntity);
            tile.getPositiveBlockInfo().setBlockState(slabState);
        } else {
            tile.getNegativeBlockInfo().setBlockState(slabState);
            tile.getPositiveBlockInfo().setBlockState(finalState1);
            tile.getPositiveBlockInfo().setBlockEntity(tileEntity);
        }
    }

    private static /* synthetic */ void lambda$onItemUse$3(BlockState slabState, BlockState finalState, SlabTileEntity tile) {
        tile.getPositiveBlockInfo().setBlockState(slabState);
        tile.getNegativeBlockInfo().setBlockState(finalState);
    }
}

