/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.mixin;

import cjminecraft.doubleslabs.client.model.DynamicSlabBakedModel;
import cjminecraft.doubleslabs.client.model.VerticalSlabBakedModel;
import cjminecraft.doubleslabs.client.util.AmbientOcclusionFace;
import cjminecraft.doubleslabs.client.util.DoubleSlabCulling;
import cjminecraft.doubleslabs.common.blocks.VerticalSlabBlock;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class ModelBlockRendererMixin {
    private static final Direction[] DIRECTIONS = Direction.values();

    public static boolean tesselateWithAO(ModelBlockRenderer renderer, BlockAndTintGetter world, BakedModel model, BlockState state, BlockPos pos, PoseStack stack, VertexConsumer buffer, boolean checkSides, Random random, long rand, int combinedOverlay, IModelData modelData) {
        if (model instanceof DynamicSlabBakedModel) {
            boolean flag = false;
            float[] afloat = new float[DIRECTIONS.length * 2];
            BitSet bitset = new BitSet(3);
            AmbientOcclusionFace modelblockrenderer$ambientocclusionface = new AmbientOcclusionFace();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_();
            boolean doubleSlab = false;
            boolean renderNegative = true;
            boolean renderPositive = true;
            BlockEntity entity = world.m_7702_(pos);
            if (entity instanceof SlabTileEntity) {
                SlabTileEntity slab = (SlabTileEntity)entity;
                doubleSlab = slab.getPositiveBlockInfo().getBlockState() != null && slab.getNegativeBlockInfo().getBlockState() != null && DynamicSlabBakedModel.useDoubleSlabModel(slab.getPositiveBlockInfo().getBlockState(), slab.getNegativeBlockInfo().getBlockState());
                renderNegative = slab.getNegativeBlockInfo().getBlockState() != null;
                renderPositive = slab.getPositiveBlockInfo().getBlockState() != null;
            }
            for (Direction direction : DIRECTIONS) {
                List list;
                random.setSeed(rand);
                if (doubleSlab) {
                    list = model.getQuads(state, direction, random, modelData);
                    if (list.isEmpty()) continue;
                    blockpos$mutableblockpos.m_122159_((Vec3i)pos, direction);
                    if (checkSides && !DoubleSlabCulling.shouldDoubleSlabSideBeRendered(state, world, pos, direction)) continue;
                    ModelBlockRendererMixin.renderModelFaceAO(renderer, world, state, pos, stack, buffer, list, afloat, bitset, modelblockrenderer$ambientocclusionface, combinedOverlay);
                    flag = true;
                    continue;
                }
                if (renderPositive) {
                    modelData.setData(DynamicSlabBakedModel.RENDER_POSITIVE, (Object)true);
                    list = model.getQuads(state, direction, random, modelData);
                    if (!list.isEmpty()) {
                        blockpos$mutableblockpos.m_122159_((Vec3i)pos, direction);
                        if (!checkSides || DoubleSlabCulling.shouldSideBeRendered(state, world, pos, direction, true)) {
                            ModelBlockRendererMixin.renderModelFaceAO(renderer, world, state, pos, stack, buffer, list, afloat, bitset, modelblockrenderer$ambientocclusionface, combinedOverlay);
                            flag = true;
                        }
                    }
                }
                if (!renderNegative) continue;
                if (MinecraftForgeClient.getRenderLayer() == null && model instanceof VerticalSlabBakedModel) {
                    BlockState newState = (BlockState)state.m_61124_((Property)VerticalSlabBlock.FACING, (Comparable)((Direction)state.m_61143_((Property)VerticalSlabBlock.FACING)).m_122424_());
                    list = ((VerticalSlabBakedModel)model).getModel(newState).getQuads(newState, direction, random, modelData);
                } else {
                    modelData.setData(DynamicSlabBakedModel.RENDER_POSITIVE, (Object)false);
                    list = model.getQuads(state, direction, random, modelData);
                }
                if (list.isEmpty()) continue;
                blockpos$mutableblockpos.m_122159_((Vec3i)pos, direction);
                if (checkSides && !DoubleSlabCulling.shouldSideBeRendered(state, world, pos, direction, false)) continue;
                ModelBlockRendererMixin.renderModelFaceAO(renderer, world, state, pos, stack, buffer, list, afloat, bitset, modelblockrenderer$ambientocclusionface, combinedOverlay);
                flag = true;
            }
            modelData.setData(DynamicSlabBakedModel.RENDER_POSITIVE, null);
            random.setSeed(rand);
            List list1 = model.getQuads(state, null, random, modelData);
            if (!list1.isEmpty()) {
                ModelBlockRendererMixin.renderModelFaceAO(renderer, world, state, pos, stack, buffer, list1, afloat, bitset, modelblockrenderer$ambientocclusionface, combinedOverlay);
                flag = true;
            }
            return flag;
        }
        return false;
    }

    public static boolean tesselateWithoutAO(ModelBlockRenderer renderer, BlockAndTintGetter world, BakedModel model, BlockState state, BlockPos pos, PoseStack stack, VertexConsumer buffer, boolean checkSides, Random random, long rand, int combinedLight, IModelData modelData) {
        if (model instanceof DynamicSlabBakedModel) {
            boolean flag = false;
            BitSet bitset = new BitSet(3);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_();
            boolean doubleSlab = false;
            boolean renderNegative = true;
            boolean renderPositive = true;
            BlockEntity entity = world.m_7702_(pos);
            if (entity instanceof SlabTileEntity) {
                SlabTileEntity slab = (SlabTileEntity)entity;
                doubleSlab = slab.getPositiveBlockInfo().getBlockState() != null && slab.getNegativeBlockInfo().getBlockState() != null && DynamicSlabBakedModel.useDoubleSlabModel(slab.getPositiveBlockInfo().getBlockState(), slab.getNegativeBlockInfo().getBlockState());
                renderNegative = slab.getNegativeBlockInfo().getBlockState() != null;
                renderPositive = slab.getPositiveBlockInfo().getBlockState() != null;
            }
            for (Direction direction : DIRECTIONS) {
                List list;
                random.setSeed(rand);
                if (doubleSlab) {
                    list = model.getQuads(state, direction, random, modelData);
                    if (list.isEmpty()) continue;
                    blockpos$mutableblockpos.m_122159_((Vec3i)pos, direction);
                    if (checkSides && !DoubleSlabCulling.shouldDoubleSlabSideBeRendered(state, world, pos, direction)) continue;
                    int i = LevelRenderer.m_109537_((BlockAndTintGetter)world, (BlockState)state, (BlockPos)blockpos$mutableblockpos);
                    ModelBlockRendererMixin.renderModelFaceFlat(renderer, world, state, pos, i, combinedLight, false, stack, buffer, list, bitset);
                    flag = true;
                    continue;
                }
                if (renderPositive) {
                    modelData.setData(DynamicSlabBakedModel.RENDER_POSITIVE, (Object)true);
                    list = model.getQuads(state, direction, random, modelData);
                    if (!list.isEmpty()) {
                        blockpos$mutableblockpos.m_122159_((Vec3i)pos, direction);
                        if (!checkSides || DoubleSlabCulling.shouldSideBeRendered(state, world, pos, direction, true)) {
                            int i = LevelRenderer.m_109537_((BlockAndTintGetter)world, (BlockState)state, (BlockPos)blockpos$mutableblockpos);
                            ModelBlockRendererMixin.renderModelFaceFlat(renderer, world, state, pos, i, combinedLight, false, stack, buffer, list, bitset);
                            flag = true;
                        }
                    }
                }
                if (!renderNegative) continue;
                modelData.setData(DynamicSlabBakedModel.RENDER_POSITIVE, (Object)false);
                if (MinecraftForgeClient.getRenderLayer() == null && model instanceof VerticalSlabBakedModel) {
                    BlockState newState = (BlockState)state.m_61124_((Property)VerticalSlabBlock.FACING, (Comparable)((Direction)state.m_61143_((Property)VerticalSlabBlock.FACING)).m_122424_());
                    list = ((VerticalSlabBakedModel)model).getModel(newState).getQuads(newState, direction, random, modelData);
                } else {
                    modelData.setData(DynamicSlabBakedModel.RENDER_POSITIVE, (Object)false);
                    list = model.getQuads(state, direction, random, modelData);
                }
                if (list.isEmpty()) continue;
                blockpos$mutableblockpos.m_122159_((Vec3i)pos, direction);
                if (checkSides && !DoubleSlabCulling.shouldSideBeRendered(state, world, pos, direction, false)) continue;
                int i = LevelRenderer.m_109537_((BlockAndTintGetter)world, (BlockState)state, (BlockPos)blockpos$mutableblockpos);
                ModelBlockRendererMixin.renderModelFaceFlat(renderer, world, state, pos, i, combinedLight, false, stack, buffer, list, bitset);
                flag = true;
            }
            modelData.setData(DynamicSlabBakedModel.RENDER_POSITIVE, null);
            random.setSeed(rand);
            List list1 = model.getQuads(state, null, random, modelData);
            if (!list1.isEmpty()) {
                ModelBlockRendererMixin.renderModelFaceFlat(renderer, world, state, pos, -1, combinedLight, true, stack, buffer, list1, bitset);
                flag = true;
            }
            return flag;
        }
        return false;
    }

    private static void renderModelFaceAO(ModelBlockRenderer renderer, BlockAndTintGetter world, BlockState state, BlockPos pos, PoseStack stack, VertexConsumer buffer, List<BakedQuad> quads, float[] quadBounds, BitSet bitSet, AmbientOcclusionFace aoFace, int combinedOverlay) {
        for (BakedQuad bakedquad : quads) {
            ModelBlockRendererMixin.calculateShape(world, state, pos, bakedquad.m_111303_(), bakedquad.m_111306_(), quadBounds, bitSet);
            aoFace.calculate(world, state, pos, bakedquad.m_111306_(), quadBounds, bitSet, bakedquad.m_111307_());
            ModelBlockRendererMixin.putQuadData(renderer, world, state, pos, buffer, stack.m_85850_(), bakedquad, aoFace.brightness[0], aoFace.brightness[1], aoFace.brightness[2], aoFace.brightness[3], aoFace.lightmap[0], aoFace.lightmap[1], aoFace.lightmap[2], aoFace.lightmap[3], combinedOverlay);
        }
    }

    private static void renderModelFaceFlat(ModelBlockRenderer renderer, BlockAndTintGetter world, BlockState state, BlockPos pos, int lightmap1, int lightmap2, boolean colored, PoseStack stack, VertexConsumer buffer, List<BakedQuad> quads, BitSet bitSet) {
        for (BakedQuad bakedquad : quads) {
            if (colored) {
                ModelBlockRendererMixin.calculateShape(world, state, pos, bakedquad.m_111303_(), bakedquad.m_111306_(), null, bitSet);
                BlockPos blockpos = bitSet.get(0) ? pos.m_142300_(bakedquad.m_111306_()) : pos;
                lightmap1 = LevelRenderer.m_109537_((BlockAndTintGetter)world, (BlockState)state, (BlockPos)blockpos);
            }
            float f = world.m_7717_(bakedquad.m_111306_(), bakedquad.m_111307_());
            ModelBlockRendererMixin.putQuadData(renderer, world, state, pos, buffer, stack.m_85850_(), bakedquad, f, f, f, f, lightmap1, lightmap1, lightmap1, lightmap1, lightmap2);
        }
    }

    private static void putQuadData(ModelBlockRenderer renderer, BlockAndTintGetter p_111024_, BlockState p_111025_, BlockPos p_111026_, VertexConsumer p_111027_, PoseStack.Pose p_111028_, BakedQuad p_111029_, float p_111030_, float p_111031_, float p_111032_, float p_111033_, int p_111034_, int p_111035_, int p_111036_, int p_111037_, int p_111038_) {
        float f2;
        float f1;
        float f;
        if (p_111029_.m_111304_()) {
            int i = renderer.f_110995_.m_92577_(p_111025_, p_111024_, p_111026_, p_111029_.m_111305_());
            f = (float)(i >> 16 & 0xFF) / 255.0f;
            f1 = (float)(i >> 8 & 0xFF) / 255.0f;
            f2 = (float)(i & 0xFF) / 255.0f;
        } else {
            f = 1.0f;
            f1 = 1.0f;
            f2 = 1.0f;
        }
        p_111027_.m_85995_(p_111028_, p_111029_, new float[]{p_111030_, p_111031_, p_111032_, p_111033_}, f, f1, f2, new int[]{p_111034_, p_111035_, p_111036_, p_111037_}, p_111038_, true);
    }

    private static void calculateShape(BlockAndTintGetter p_111040_, BlockState p_111041_, BlockPos p_111042_, int[] p_111043_, Direction p_111044_, @Nullable float[] p_111045_, BitSet p_111046_) {
        float f = 32.0f;
        float f1 = 32.0f;
        float f2 = 32.0f;
        float f3 = -32.0f;
        float f4 = -32.0f;
        float f5 = -32.0f;
        for (int i = 0; i < 4; ++i) {
            float f6 = Float.intBitsToFloat(p_111043_[i * 8]);
            float f7 = Float.intBitsToFloat(p_111043_[i * 8 + 1]);
            float f8 = Float.intBitsToFloat(p_111043_[i * 8 + 2]);
            f = Math.min(f, f6);
            f1 = Math.min(f1, f7);
            f2 = Math.min(f2, f8);
            f3 = Math.max(f3, f6);
            f4 = Math.max(f4, f7);
            f5 = Math.max(f5, f8);
        }
        if (p_111045_ != null) {
            p_111045_[Direction.WEST.m_122411_()] = f;
            p_111045_[Direction.EAST.m_122411_()] = f3;
            p_111045_[Direction.DOWN.m_122411_()] = f1;
            p_111045_[Direction.UP.m_122411_()] = f4;
            p_111045_[Direction.NORTH.m_122411_()] = f2;
            p_111045_[Direction.SOUTH.m_122411_()] = f5;
            int j = DIRECTIONS.length;
            p_111045_[Direction.WEST.m_122411_() + j] = 1.0f - f;
            p_111045_[Direction.EAST.m_122411_() + j] = 1.0f - f3;
            p_111045_[Direction.DOWN.m_122411_() + j] = 1.0f - f1;
            p_111045_[Direction.UP.m_122411_() + j] = 1.0f - f4;
            p_111045_[Direction.NORTH.m_122411_() + j] = 1.0f - f2;
            p_111045_[Direction.SOUTH.m_122411_() + j] = 1.0f - f5;
        }
        float f9 = 1.0E-4f;
        float f10 = 0.9999f;
        switch (p_111044_) {
            case DOWN: {
                p_111046_.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                p_111046_.set(0, f1 == f4 && (f1 < 1.0E-4f || p_111041_.m_60838_((BlockGetter)p_111040_, p_111042_)));
                break;
            }
            case UP: {
                p_111046_.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                p_111046_.set(0, f1 == f4 && (f4 > 0.9999f || p_111041_.m_60838_((BlockGetter)p_111040_, p_111042_)));
                break;
            }
            case NORTH: {
                p_111046_.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                p_111046_.set(0, f2 == f5 && (f2 < 1.0E-4f || p_111041_.m_60838_((BlockGetter)p_111040_, p_111042_)));
                break;
            }
            case SOUTH: {
                p_111046_.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                p_111046_.set(0, f2 == f5 && (f5 > 0.9999f || p_111041_.m_60838_((BlockGetter)p_111040_, p_111042_)));
                break;
            }
            case WEST: {
                p_111046_.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                p_111046_.set(0, f == f3 && (f < 1.0E-4f || p_111041_.m_60838_((BlockGetter)p_111040_, p_111042_)));
                break;
            }
            case EAST: {
                p_111046_.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                p_111046_.set(0, f == f3 && (f3 > 0.9999f || p_111041_.m_60838_((BlockGetter)p_111040_, p_111042_)));
            }
        }
    }
}

