/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api;

import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.api.support.ISlabSupport;
import cjminecraft.doubleslabs.api.support.IVerticalSlabSupport;
import cjminecraft.doubleslabs.api.support.SlabSupportProvider;
import cjminecraft.doubleslabs.common.DoubleSlabs;
import cjminecraft.doubleslabs.common.config.DSConfig;
import cjminecraft.doubleslabs.common.util.AnnotationUtil;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class SlabSupport {
    private static List<IVerticalSlabSupport> verticalSlabSupports;
    private static List<IHorizontalSlabSupport> horizontalSlabSupports;

    public static void load() {
        verticalSlabSupports = AnnotationUtil.getClassInstances(SlabSupportProvider.class, IVerticalSlabSupport.class, AnnotationUtil.MODID_PREDICATE, Comparator.comparingInt(a -> a.annotationData().getOrDefault("priority", 1000)));
        horizontalSlabSupports = AnnotationUtil.getClassInstances(SlabSupportProvider.class, IHorizontalSlabSupport.class, AnnotationUtil.MODID_PREDICATE, Comparator.comparingInt(a -> a.annotationData().getOrDefault("priority", 1000)));
        DoubleSlabs.LOGGER.info("Loaded %s vertical slab support classes", (Object)verticalSlabSupports.size());
        DoubleSlabs.LOGGER.info("Loaded %s horizontal slab support classes", (Object)horizontalSlabSupports.size());
    }

    @Nullable
    public static IVerticalSlabSupport getVerticalSlabSupport(BlockGetter world, BlockPos pos, BlockState state) {
        if (state.m_60734_() instanceof IVerticalSlabSupport && ((IVerticalSlabSupport)state.m_60734_()).isVerticalSlab(world, pos, state)) {
            return (IVerticalSlabSupport)state.m_60734_();
        }
        for (IVerticalSlabSupport support : verticalSlabSupports) {
            if (!support.isVerticalSlab(world, pos, state)) continue;
            return support;
        }
        return null;
    }

    @Nullable
    public static IVerticalSlabSupport getVerticalSlabSupport(ItemStack stack, Player player, InteractionHand hand) {
        if (stack.m_41720_() instanceof IVerticalSlabSupport && ((IVerticalSlabSupport)stack.m_41720_()).isVerticalSlab(stack, player, hand)) {
            return (IVerticalSlabSupport)stack.m_41720_();
        }
        if (stack.m_41720_() instanceof BlockItem && ((BlockItem)stack.m_41720_()).m_40614_() instanceof IVerticalSlabSupport && ((IVerticalSlabSupport)((BlockItem)stack.m_41720_()).m_40614_()).isVerticalSlab(stack, player, hand)) {
            return (IVerticalSlabSupport)((BlockItem)stack.m_41720_()).m_40614_();
        }
        for (IVerticalSlabSupport support : verticalSlabSupports) {
            if (!support.isVerticalSlab(stack, player, hand)) continue;
            return support;
        }
        return null;
    }

    @Nullable
    public static IHorizontalSlabSupport getHorizontalSlabSupport(BlockGetter world, BlockPos pos, BlockState state) {
        if (state.m_60734_() instanceof IHorizontalSlabSupport && ((IHorizontalSlabSupport)state.m_60734_()).isHorizontalSlab(world, pos, state)) {
            return (IHorizontalSlabSupport)state.m_60734_();
        }
        for (IHorizontalSlabSupport support : horizontalSlabSupports) {
            if (!support.isHorizontalSlab(world, pos, state)) continue;
            return support;
        }
        return null;
    }

    @Nullable
    public static IHorizontalSlabSupport getHorizontalSlabSupport(ItemStack stack, Player player, InteractionHand hand) {
        if (stack.m_41720_() instanceof IHorizontalSlabSupport && ((IHorizontalSlabSupport)stack.m_41720_()).isHorizontalSlab(stack, player, hand)) {
            return (IHorizontalSlabSupport)stack.m_41720_();
        }
        if (stack.m_41720_() instanceof BlockItem && ((BlockItem)stack.m_41720_()).m_40614_() instanceof IHorizontalSlabSupport && ((IHorizontalSlabSupport)((BlockItem)stack.m_41720_()).m_40614_()).isHorizontalSlab(stack, player, hand)) {
            return (IHorizontalSlabSupport)((BlockItem)stack.m_41720_()).m_40614_();
        }
        for (IHorizontalSlabSupport support : horizontalSlabSupports) {
            if (!support.isHorizontalSlab(stack, player, hand)) continue;
            return support;
        }
        return null;
    }

    public static boolean isHorizontalSlab(Item item) {
        if (item instanceof BlockItem && ((BlockItem)item).m_40614_() instanceof IHorizontalSlabSupport) {
            return ((IHorizontalSlabSupport)((BlockItem)item).m_40614_()).isHorizontalSlab(item);
        }
        for (IHorizontalSlabSupport support : horizontalSlabSupports) {
            if (!support.isHorizontalSlab(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHorizontalSlab(Block block) {
        if (DSConfig.SERVER.isBlacklistedHorizontalSlab(block)) {
            return false;
        }
        if (block instanceof IHorizontalSlabSupport) {
            return true;
        }
        for (IHorizontalSlabSupport support : horizontalSlabSupports) {
            if (!support.isHorizontalSlab(block)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static IHorizontalSlabSupport getHorizontalSlabSupport(Block block) {
        if (DSConfig.SERVER.isBlacklistedHorizontalSlab(block)) {
            return null;
        }
        if (block instanceof IHorizontalSlabSupport) {
            return (IHorizontalSlabSupport)block;
        }
        for (IHorizontalSlabSupport support : horizontalSlabSupports) {
            if (!support.isHorizontalSlab(block)) continue;
            return support;
        }
        return null;
    }

    @Nullable
    public static IHorizontalSlabSupport getHorizontalSlabSupport(Item item) {
        if (item instanceof BlockItem && ((BlockItem)item).m_40614_() instanceof IHorizontalSlabSupport) {
            return (IHorizontalSlabSupport)((BlockItem)item).m_40614_();
        }
        for (IHorizontalSlabSupport support : horizontalSlabSupports) {
            if (!support.isHorizontalSlab(item)) continue;
            return support;
        }
        return null;
    }

    @Nullable
    public static ISlabSupport getSlabSupport(BlockGetter world, BlockPos pos, BlockState state) {
        IHorizontalSlabSupport horizontalSlabSupport = SlabSupport.getHorizontalSlabSupport(world, pos, state);
        return horizontalSlabSupport != null ? horizontalSlabSupport : SlabSupport.getVerticalSlabSupport(world, pos, state);
    }

    @Nullable
    public static ISlabSupport getSlabSupport(ItemStack stack, Player player, InteractionHand hand) {
        IHorizontalSlabSupport horizontalSlabSupport = SlabSupport.getHorizontalSlabSupport(stack, player, hand);
        return horizontalSlabSupport != null ? horizontalSlabSupport : SlabSupport.getVerticalSlabSupport(stack, player, hand);
    }
}

