/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.blocks;

import cjminecraft.doubleslabs.api.ContainerSupport;
import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.containers.IContainerSupport;
import cjminecraft.doubleslabs.api.support.ISlabSupport;
import cjminecraft.doubleslabs.common.blocks.DynamicSlabBlock;
import cjminecraft.doubleslabs.common.container.WrappedContainer;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import cjminecraft.doubleslabs.common.util.RayTraceUtil;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IBlockRenderProperties;
import net.minecraftforge.network.NetworkHooks;

public class DoubleSlabBlock
extends DynamicSlabBlock {
    public static Optional<IBlockInfo> getHalfState(BlockGetter world, BlockPos pos, double y) {
        return DoubleSlabBlock.getTile(world, pos).flatMap(tile -> tile.getNegativeBlockInfo().getBlockState() == null && tile.getPositiveBlockInfo().getBlockState() == null ? Optional.empty() : ((y > 0.5 || tile.getNegativeBlockInfo().getBlockState() == null) && tile.getPositiveBlockInfo().getBlockState() != null ? Optional.of(tile.getPositiveBlockInfo()) : Optional.of(tile.getNegativeBlockInfo())));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IBlockRenderProperties> consumer) {
        consumer.accept(new IBlockRenderProperties(){

            public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine manager) {
                if (target.m_6662_() == HitResult.Type.BLOCK) {
                    BlockHitResult result = (BlockHitResult)target;
                    return DoubleSlabBlock.getHalfState((BlockGetter)level, result.m_82425_(), result.m_82450_().f_82480_ - (double)result.m_82425_().m_123342_()).map(i -> DoubleSlabBlock.this.crack((ClientLevel)level, state, i.getBlockState(), result.m_82425_(), result.m_82434_(), manager)).orElse(false);
                }
                return false;
            }

            public boolean addDestroyEffects(BlockState state, Level level, BlockPos pos, ParticleEngine manager) {
                AtomicBoolean result = new AtomicBoolean(false);
                DynamicSlabBlock.runIfAvailable((BlockGetter)level, pos, i -> {
                    manager.m_107355_(pos, i.getBlockState());
                    result.set(true);
                });
                return result.get();
            }
        });
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        BlockHitResult result = RayTraceUtil.rayTrace(player);
        Vec3 hitVec = result.m_82450_();
        return DoubleSlabBlock.getHalfState(world, pos, hitVec.f_82480_ - (double)pos.m_123342_()).map(i -> i.getBlockState().canHarvestBlock((BlockGetter)i.getWorld(), pos, player)).orElseGet(() -> super.canHarvestBlock(state, world, pos, player));
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return DoubleSlabBlock.both(world, pos, i -> i.getBlockState().m_60631_((BlockGetter)i.getWorld(), pos));
    }

    public float m_5880_(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        Vec3 hitVec;
        BlockHitResult result = RayTraceUtil.rayTrace(player);
        Vec3 vec3 = hitVec = result.m_6662_() == HitResult.Type.BLOCK ? result.m_82450_() : null;
        if (hitVec == null) {
            return DoubleSlabBlock.minFloat(world, pos, i -> i.getBlockState().m_60625_(player, (BlockGetter)i.getWorld(), pos));
        }
        return DoubleSlabBlock.getHalfState(world, pos, hitVec.f_82480_ - (double)pos.m_123342_()).map(i -> Float.valueOf(i.getBlockState().m_60625_(player, (BlockGetter)i.getWorld(), pos))).orElseGet(() -> Float.valueOf(super.m_5880_(state, player, world, pos))).floatValue();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return DoubleSlabBlock.getHalfState(level, pos, target.m_82450_().f_82480_ - (double)pos.m_123342_()).map(i -> i.getBlockState().getCloneItemStack(target, level, pos, player)).orElse(ItemStack.f_41583_);
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity entity, ItemStack stack) {
        Vec3 hitVec;
        BlockHitResult result = RayTraceUtil.rayTrace(player);
        Vec3 vec3 = hitVec = result.m_6662_() == HitResult.Type.BLOCK ? result.m_82450_() : null;
        if (hitVec == null || entity == null) {
            super.m_6240_(world, player, pos, state, entity, stack);
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
            world.m_46747_(pos);
        } else {
            SlabTileEntity tile = (SlabTileEntity)entity;
            double y = hitVec.f_82480_ - (double)pos.m_123342_();
            IBlockInfo remainingBlock = y > 0.5 ? tile.getNegativeBlockInfo() : tile.getPositiveBlockInfo();
            IBlockInfo blockToRemove = y > 0.5 ? tile.getPositiveBlockInfo() : tile.getNegativeBlockInfo();
            player.m_36246_(Stats.f_12949_.m_12902_((Object)blockToRemove.getBlockState().m_60734_()));
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)blockToRemove.getBlockState()));
            player.m_36399_(0.005f);
            if (!player.m_7500_()) {
                DoubleSlabBlock.m_49881_((BlockState)blockToRemove.getBlockState(), (Level)world, (BlockPos)pos, null, (Entity)player, (ItemStack)stack);
            }
            blockToRemove.getBlockState().m_60753_(blockToRemove.getWorld(), pos, Blocks.f_50016_.m_49966_(), false);
            world.m_7731_(pos, remainingBlock.getBlockState(), 3);
            if (remainingBlock.getBlockEntity() != null) {
                world.m_151523_(remainingBlock.getBlockEntity());
            } else {
                world.m_46747_(pos);
            }
        }
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return DoubleSlabBlock.getTile((BlockGetter)worldserver, pos).map(tile -> {
            float f = (float)Math.ceil(entity.f_19789_ - 3.0f);
            double d0 = Math.min((double)(0.2f + f / 15.0f), 2.5);
            int numOfParticles = (int)(150.0 * d0);
            worldserver.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, tile.getPositiveBlockInfo().getBlockState()), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), numOfParticles, 0.0, 0.0, 0.0, (double)0.15f);
            return true;
        }).orElse(false);
    }

    public boolean addRunningEffects(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (world.m_5776_()) {
            DoubleSlabBlock.getTile((BlockGetter)world, pos).ifPresent(tile -> world.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, tile.getPositiveBlockInfo().getBlockState()), entity.m_20185_() + ((double)world.f_46441_.nextFloat() - 0.5) * (double)entity.m_20205_(), entity.m_142469_().f_82289_ + 0.1, entity.m_20189_() + ((double)world.f_46441_.nextFloat() - 0.5) * (double)entity.m_20205_(), -entity.m_20184_().f_82479_ * 4.0, 1.5, -entity.m_20184_().f_82481_ * 4.0));
        }
        return true;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (state.m_60734_() != this) {
            return InteractionResult.PASS;
        }
        return DoubleSlabBlock.getHalfState((BlockGetter)world, pos, hit.m_82450_().f_82480_ - (double)pos.m_123342_()).map(i -> {
            IContainerSupport containerSupport = ContainerSupport.getSupport(i.getWorld(), pos, i.getBlockState());
            ISlabSupport slabSupport = SlabSupport.getSlabSupport((BlockGetter)i.getWorld(), pos, i.getBlockState());
            if (containerSupport != null) {
                if (!world.m_5776_()) {
                    final MenuProvider provider = containerSupport.getNamedContainerProvider(i.getWorld(), pos, i.getBlockState(), player, hand, hit);
                    NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){
                        final /* synthetic */ IBlockInfo val$i;
                        {
                            this.val$i = iBlockInfo;
                        }

                        public Component m_5446_() {
                            return provider.m_5446_();
                        }

                        @Nullable
                        public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                            return new WrappedContainer(windowId, inv, player, provider, this.val$i);
                        }
                    }, buffer -> {
                        buffer.m_130064_(i.getPos());
                        buffer.writeBoolean(i.isPositive());
                        buffer.m_130085_(containerSupport.getContainer(i.getWorld(), pos, state).getRegistryName());
                        containerSupport.writeExtraData(world, pos, state).accept((FriendlyByteBuf)buffer);
                    });
                }
                return InteractionResult.SUCCESS;
            }
            try {
                return slabSupport == null ? i.getBlockState().m_60664_(i.getWorld(), player, hand, hit) : slabSupport.onBlockActivated(i.getBlockState(), i.getWorld(), pos, player, hand, hit);
            }
            catch (Exception e) {
                return InteractionResult.PASS;
            }
        }).orElse(InteractionResult.PASS);
    }

    public void m_6256_(BlockState state, Level world, BlockPos pos, Player player) {
        BlockHitResult result = RayTraceUtil.rayTrace(player);
        if (result.m_82450_() != null) {
            DoubleSlabBlock.getHalfState((BlockGetter)world, pos, result.m_82450_().f_82480_ - (double)pos.m_123342_()).ifPresent(i -> i.getBlockState().m_60686_(i.getWorld(), pos, player));
        }
    }

    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!DoubleSlabBlock.getTile((BlockGetter)world, pos).map(tile -> {
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                tile.getPositiveBlockInfo().getBlockState().m_60734_().m_142072_(tile.getPositiveBlockInfo().getWorld(), tile.getPositiveBlockInfo().getBlockState(), pos, entity, fallDistance);
                return true;
            }
            return false;
        }).orElse(false).booleanValue()) {
            super.m_142072_(world, state, pos, entity, fallDistance);
        }
    }

    public void m_5548_(BlockGetter world, Entity entity) {
        BlockPos pos = new BlockPos(entity.m_20182_()).m_7495_();
        if (world.m_8055_(pos).m_60734_() == this && !DoubleSlabBlock.getTile(world, pos).map(tile -> {
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                tile.getPositiveBlockInfo().getBlockState().m_60734_().m_5548_((BlockGetter)tile.getPositiveBlockInfo().getWorld(), entity);
                return true;
            }
            return false;
        }).orElse(false).booleanValue()) {
            super.m_5548_(world, entity);
        }
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        DoubleSlabBlock.getTile((BlockGetter)world, pos).ifPresent(tile -> {
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                tile.getPositiveBlockInfo().getBlockState().m_60734_().m_141947_(tile.getPositiveBlockInfo().getWorld(), pos, tile.getPositiveBlockInfo().getBlockState(), entity);
            }
        });
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter world, BlockPos pos, FluidState fluidState) {
        return true;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        DoubleSlabBlock.getTile((BlockGetter)world, pos).ifPresent(tile -> {
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                tile.getPositiveBlockInfo().getBlockState().m_60682_(world, pos, entity);
            }
            if (tile.getNegativeBlockInfo().getBlockState() != null) {
                tile.getNegativeBlockInfo().getBlockState().m_60682_(world, pos, entity);
            }
        });
    }

    public void m_5581_(Level world, BlockState state, BlockHitResult hit, Projectile projectile) {
        DoubleSlabBlock.getHalfState((BlockGetter)world, hit.m_82425_(), hit.m_82450_().f_82480_).ifPresent(i -> i.getBlockState().m_60669_(i.getWorld(), i.getBlockState(), hit, projectile));
    }

    @Override
    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, @Nullable Entity entity) {
        BlockHitResult result;
        if (entity instanceof Player && (result = RayTraceUtil.rayTrace((Player)entity)).m_82425_().equals((Object)pos)) {
            return DoubleSlabBlock.getHalfState((BlockGetter)world, pos, result.m_82450_().f_82480_ - (double)pos.m_123342_()).map(i -> i.getBlockState().getSoundType((LevelReader)i.getWorld(), pos, entity)).orElseGet(() -> super.getSoundType(state, world, pos, entity));
        }
        return DoubleSlabBlock.getAvailable((BlockGetter)world, pos).map(i -> i.getBlockState().getSoundType((LevelReader)i.getWorld(), pos, entity)).orElseGet(() -> super.getSoundType(state, world, pos, entity));
    }
}

