/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.blocks;

import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.common.init.DSTiles;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;

public class DynamicSlabBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public DynamicSlabBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60955_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean crack(ClientLevel level, BlockState actualState, BlockState state, BlockPos pos, Direction direction, ParticleEngine manager) {
        if (state.m_60799_() != RenderShape.INVISIBLE) {
            Particle particle;
            int i = pos.m_123341_();
            int j = pos.m_123342_();
            int k = pos.m_123343_();
            float f = 0.1f;
            AABB aabb = actualState.m_60808_((BlockGetter)level, pos).m_83215_();
            double d0 = (double)i + level.f_46441_.nextDouble() * (aabb.f_82291_ - aabb.f_82288_ - (double)0.2f) + (double)0.1f + aabb.f_82288_;
            double d1 = (double)j + level.f_46441_.nextDouble() * (aabb.f_82292_ - aabb.f_82289_ - (double)0.2f) + (double)0.1f + aabb.f_82289_;
            double d2 = (double)k + level.f_46441_.nextDouble() * (aabb.f_82293_ - aabb.f_82290_ - (double)0.2f) + (double)0.1f + aabb.f_82290_;
            if (direction == Direction.DOWN) {
                d1 = (double)j + aabb.f_82289_ - (double)0.1f;
            }
            if (direction == Direction.UP) {
                d1 = (double)j + aabb.f_82292_ + (double)0.1f;
            }
            if (direction == Direction.NORTH) {
                d2 = (double)k + aabb.f_82290_ - (double)0.1f;
            }
            if (direction == Direction.SOUTH) {
                d2 = (double)k + aabb.f_82293_ + (double)0.1f;
            }
            if (direction == Direction.WEST) {
                d0 = (double)i + aabb.f_82288_ - (double)0.1f;
            }
            if (direction == Direction.EAST) {
                d0 = (double)i + aabb.f_82291_ + (double)0.1f;
            }
            if ((particle = manager.m_107370_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), d0, d1, d2, 0.0, 0.0, 0.0)) != null) {
                particle = particle.m_107268_(0.2f).m_6569_(0.6f);
                manager.m_107344_(particle);
                return true;
            }
        }
        return false;
    }

    public static Optional<SlabTileEntity> getTile(BlockGetter world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        return tile instanceof SlabTileEntity ? Optional.of((SlabTileEntity)tile) : Optional.empty();
    }

    public static Optional<IBlockInfo> getAvailable(BlockGetter world, BlockPos pos) {
        return DynamicSlabBlock.getTile(world, pos).flatMap(tile -> Optional.of(tile.getPositiveBlockInfo().getBlockState() != null ? tile.getPositiveBlockInfo() : tile.getNegativeBlockInfo()));
    }

    public static int min(BlockGetter world, BlockPos pos, ToIntFunction<IBlockInfo> converter) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> Math.min(tile.getPositiveBlockInfo().getBlockState() != null ? converter.applyAsInt(tile.getPositiveBlockInfo()) : Integer.MAX_VALUE, tile.getNegativeBlockInfo().getBlockState() != null ? converter.applyAsInt(tile.getNegativeBlockInfo()) : Integer.MAX_VALUE)).orElse(0);
    }

    public static float minFloat(BlockGetter world, BlockPos pos, ToDoubleFunction<IBlockInfo> converter) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> Math.min(tile.getPositiveBlockInfo().getBlockState() != null ? converter.applyAsDouble(tile.getPositiveBlockInfo()) : 2.147483647E9, tile.getNegativeBlockInfo().getBlockState() != null ? converter.applyAsDouble(tile.getNegativeBlockInfo()) : 2.147483647E9)).orElse(0.0).floatValue();
    }

    public static int max(BlockGetter world, BlockPos pos, ToIntFunction<IBlockInfo> converter) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> Math.max(tile.getPositiveBlockInfo().getBlockState() != null ? converter.applyAsInt(tile.getPositiveBlockInfo()) : 0, tile.getNegativeBlockInfo().getBlockState() != null ? converter.applyAsInt(tile.getNegativeBlockInfo()) : 0)).orElse(0);
    }

    public static float maxFloat(BlockGetter world, BlockPos pos, ToDoubleFunction<IBlockInfo> converter) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> Math.max(tile.getPositiveBlockInfo().getBlockState() != null ? converter.applyAsDouble(tile.getPositiveBlockInfo()) : 0.0, tile.getNegativeBlockInfo().getBlockState() != null ? converter.applyAsDouble(tile.getNegativeBlockInfo()) : 0.0)).orElse(0.0).floatValue();
    }

    public static float addFloat(BlockGetter world, BlockPos pos, ToDoubleFunction<IBlockInfo> converter) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> (tile.getPositiveBlockInfo().getBlockState() != null ? converter.applyAsDouble(tile.getPositiveBlockInfo()) : 0.0) + (tile.getNegativeBlockInfo().getBlockState() != null ? converter.applyAsDouble(tile.getNegativeBlockInfo()) : 0.0)).orElse(0.0).floatValue();
    }

    public static void runIfAvailable(BlockGetter world, BlockPos pos, Consumer<IBlockInfo> consumer) {
        DynamicSlabBlock.getTile(world, pos).map(tile -> {
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                consumer.accept(tile.getPositiveBlockInfo());
            }
            if (tile.getNegativeBlockInfo().getBlockState() != null) {
                consumer.accept(tile.getNegativeBlockInfo());
            }
            return null;
        });
    }

    public static boolean both(BlockGetter world, BlockPos pos, Predicate<IBlockInfo> predicate) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> tile.getPositiveBlockInfo().getBlockState() != null && tile.getNegativeBlockInfo().getBlockState() != null && predicate.test(tile.getPositiveBlockInfo()) && predicate.test(tile.getNegativeBlockInfo())).orElse(false);
    }

    public static boolean either(BlockGetter world, BlockPos pos, Predicate<IBlockInfo> predicate) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> tile.getPositiveBlockInfo().getBlockState() != null && predicate.test(tile.getPositiveBlockInfo()) || tile.getNegativeBlockInfo().getBlockState() != null && predicate.test(tile.getNegativeBlockInfo())).orElse(false);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SlabTileEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return DynamicSlabBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)DSTiles.DYNAMIC_SLAB.get()), SlabTileEntity::tick);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidState) {
        DynamicSlabBlock.runIfAvailable((BlockGetter)world, pos, i -> {
            if (i.getBlockState().m_60734_() instanceof SimpleWaterloggedBlock) {
                ((SimpleWaterloggedBlock)i.getBlockState().m_60734_()).m_7361_((LevelAccessor)i.getWorld(), pos, i.getBlockState(), fluidState);
            }
        });
        return super.m_7361_(world, pos, state, fluidState);
    }

    public boolean m_6044_(BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return super.m_6044_(world, pos, state, fluid) && DynamicSlabBlock.either(world, pos, i -> i.getSupport() != null && i.getSupport().waterloggableWhenDouble(i.getWorld(), pos, i.getBlockState()));
    }

    @Nonnull
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        BlockState blockstate = context.m_43725_().m_8055_(blockpos);
        FluidState fluidstate = context.m_43725_().m_6425_(blockpos);
        if (blockstate.m_60713_((Block)this)) {
            return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_ && DynamicSlabBlock.either((BlockGetter)context.m_43725_(), blockpos, i -> i.getSupport() != null && i.getSupport().waterloggableWhenDouble(i.getWorld(), i.getPos(), i.getBlockState()))));
        }
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return type == PathComputationType.WATER && world.m_6425_(pos).m_205070_(FluidTags.f_13131_);
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        return DynamicSlabBlock.maxFloat(world, pos, i -> i.getBlockState().getExplosionResistance((BlockGetter)i.getWorld(), pos, explosion));
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return DynamicSlabBlock.max(world, pos, i -> i.getBlockState().getLightEmission((BlockGetter)i.getWorld(), pos));
    }

    public float m_7749_(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        BlockEntity tileEntity = (BlockEntity)builder.m_78970_(LootContextParams.f_81462_);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (tileEntity instanceof SlabTileEntity) {
            LootContext.Builder newBuilder;
            SlabTileEntity tile = (SlabTileEntity)tileEntity;
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                newBuilder = builder.m_78972_(LootContextParams.f_81461_, (Object)tile.getPositiveBlockInfo().getBlockState());
                if (tile.getPositiveBlockInfo().getBlockEntity() != null) {
                    newBuilder = newBuilder.m_78972_(LootContextParams.f_81462_, (Object)tile.getPositiveBlockInfo().getBlockEntity());
                }
                drops.addAll(tile.getPositiveBlockInfo().getBlockState().m_60724_(newBuilder));
            }
            if (tile.getNegativeBlockInfo().getBlockState() != null) {
                newBuilder = builder.m_78972_(LootContextParams.f_81461_, (Object)tile.getNegativeBlockInfo().getBlockState());
                if (tile.getNegativeBlockInfo().getBlockEntity() != null) {
                    newBuilder = newBuilder.m_78972_(LootContextParams.f_81462_, (Object)tile.getNegativeBlockInfo().getBlockEntity());
                }
                drops.addAll(tile.getNegativeBlockInfo().getBlockState().m_60724_(newBuilder));
            }
        }
        return drops;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (willHarvest) {
            return true;
        }
        if (player.m_7500_() && player.m_6047_()) {
            this.m_6240_(world, player, pos, state, world.m_7702_(pos), ItemStack.f_41583_);
            return true;
        }
        return super.onDestroyedByPlayer(state, world, pos, player, false, fluid);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (player.m_7500_()) {
            DynamicSlabBlock.runIfAvailable((BlockGetter)world, pos, i -> i.getBlockState().m_60753_(i.getWorld(), pos, Blocks.f_50016_.m_49966_(), false));
            super.m_5707_(world, pos, state, player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockColor getBlockColor() {
        return (state, world, pos, tintIndex) -> {
            if (world == null || pos == null) {
                return -1;
            }
            return DynamicSlabBlock.getTile((BlockGetter)world, pos).map(tile -> {
                if (tintIndex >= 1000) {
                    return tile.getPositiveBlockInfo().getBlockState() != null ? Minecraft.m_91087_().m_91298_().m_92577_(tile.getPositiveBlockInfo().getBlockState(), world, pos, tintIndex - 1000) : -1;
                }
                return tile.getNegativeBlockInfo().getBlockState() != null ? Minecraft.m_91087_().m_91298_().m_92577_(tile.getNegativeBlockInfo().getBlockState(), world, pos, tintIndex) : -1;
            }).orElse(-1);
        };
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        super.m_7455_(state, world, pos, random);
        DynamicSlabBlock.runIfAvailable((BlockGetter)world, pos, i -> {
            if (i.getBlockState().m_60823_()) {
                i.getBlockState().m_60735_((ServerLevel)i.getWorld(), pos, random);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level world, BlockPos pos, Random random) {
        DynamicSlabBlock.runIfAvailable((BlockGetter)world, pos, i -> i.getBlockState().m_60734_().m_7100_(i.getBlockState(), i.getWorld(), pos, random));
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader world, BlockPos pos) {
        return DynamicSlabBlock.addFloat((BlockGetter)world, pos, i -> i.getBlockState().getEnchantPowerBonus((LevelReader)i.getWorld(), pos));
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return DynamicSlabBlock.max(world, pos, i -> i.getBlockState().getFireSpreadSpeed((BlockGetter)i.getWorld(), pos, face));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return DynamicSlabBlock.max(world, pos, i -> i.getBlockState().getFlammability((BlockGetter)i.getWorld(), pos, face));
    }

    public boolean getWeakChanges(BlockState state, LevelReader world, BlockPos pos) {
        return true;
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return true;
    }

    public boolean isBurning(BlockState state, BlockGetter world, BlockPos pos) {
        return DynamicSlabBlock.either(world, pos, i -> i.getBlockState().isBurning((BlockGetter)i.getWorld(), pos));
    }

    public boolean isFertile(BlockState state, BlockGetter world, BlockPos pos) {
        return DynamicSlabBlock.either(world, pos, i -> i.getBlockState().isFertile((BlockGetter)i.getWorld(), pos));
    }

    public boolean isFireSource(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return DynamicSlabBlock.either((BlockGetter)world, pos, i -> i.getBlockState().isFireSource((LevelReader)i.getWorld(), pos, side));
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return DynamicSlabBlock.either(world, pos, i -> i.getBlockState().isFlammable((BlockGetter)i.getWorld(), pos, face));
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, world, pos, block, fromPos, isMoving);
        DynamicSlabBlock.runIfAvailable((BlockGetter)world, pos, i -> i.getBlockState().m_60690_(i.getWorld(), pos, i.getBlockState().m_60734_(), fromPos, isMoving));
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        DynamicSlabBlock.runIfAvailable((BlockGetter)world, pos, i -> i.getBlockState().onNeighborChange((LevelReader)i.getWorld(), pos, neighbor));
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        DynamicSlabBlock.runIfAvailable((BlockGetter)world, pos, i -> i.getBlockState().m_60616_(world, pos, random));
    }

    public void m_7592_(Level world, BlockPos pos, Explosion explosion) {
        DynamicSlabBlock.runIfAvailable((BlockGetter)world, pos, i -> i.getBlockState().m_60734_().m_7592_(i.getWorld(), pos, explosion));
    }

    public void m_141997_(BlockState state, Level world, BlockPos pos, Biome.Precipitation precipitation) {
        DynamicSlabBlock.getTile((BlockGetter)world, pos).ifPresent(tile -> {
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                tile.getPositiveBlockInfo().getBlockState().m_60734_().m_141997_(tile.getPositiveBlockInfo().getBlockState(), tile.getPositiveBlockInfo().getWorld(), pos, precipitation);
            }
        });
    }

    public float getFriction(BlockState state, LevelReader world, BlockPos pos, @Nullable Entity entity) {
        return DynamicSlabBlock.getTile((BlockGetter)world, pos).filter(tile -> tile.getPositiveBlockInfo().getBlockState() != null).map(tile -> Float.valueOf(tile.getPositiveBlockInfo().getBlockState().getFriction((LevelReader)tile.getPositiveBlockInfo().getWorld(), pos, entity))).orElseGet(() -> Float.valueOf(super.getFriction(state, world, pos, entity))).floatValue();
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> tile.getPositiveBlockInfo().getBlockState() != null && tile.getPositiveBlockInfo().getBlockState().canSustainPlant((BlockGetter)tile.getPositiveBlockInfo().getWorld(), pos, facing, plantable)).orElse(false);
    }

    public void m_7742_(BlockState state, LevelAccessor world, BlockPos pos, int flags, int recursionLeft) {
        DynamicSlabBlock.runIfAvailable((BlockGetter)world, pos, i -> i.getBlockState().m_60762_((LevelAccessor)i.getWorld(), pos, flags, recursionLeft));
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return DynamicSlabBlock.either((BlockGetter)world, pos, i -> i.getBlockState().isLadder((LevelReader)i.getWorld(), pos, entity));
    }

    public boolean isBed(BlockState state, BlockGetter world, BlockPos pos, @Nullable Entity player) {
        return DynamicSlabBlock.either(world, pos, i -> i.getBlockState().isBed((BlockGetter)i.getWorld(), pos, (LivingEntity)player));
    }

    public boolean isConduitFrame(BlockState state, LevelReader world, BlockPos pos, BlockPos conduit) {
        return DynamicSlabBlock.either((BlockGetter)world, pos, i -> i.getBlockState().isConduitFrame((LevelReader)i.getWorld(), pos, conduit));
    }

    public boolean isPortalFrame(BlockState state, BlockGetter world, BlockPos pos) {
        return DynamicSlabBlock.either(world, pos, i -> i.getBlockState().isPortalFrame((BlockGetter)i.getWorld(), pos));
    }

    public int getExpDrop(BlockState state, LevelReader world, BlockPos pos, int fortune, int silktouch) {
        return DynamicSlabBlock.max((BlockGetter)world, pos, i -> i.getBlockState().getExpDrop((LevelReader)i.getWorld(), pos, fortune, silktouch));
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, @Nullable Entity entity) {
        if (entity == null) {
            return DynamicSlabBlock.getAvailable((BlockGetter)world, pos).map(i -> i.getBlockState().getSoundType((LevelReader)i.getWorld(), pos, null)).orElse(super.getSoundType(state, world, pos, entity));
        }
        return super.getSoundType(state, world, pos, entity);
    }

    @Nullable
    public float[] getBeaconColorMultiplier(BlockState state, LevelReader world, BlockPos pos, BlockPos beaconPos) {
        ArrayList result = new ArrayList();
        DynamicSlabBlock.getTile((BlockGetter)world, pos).ifPresent(tile -> {
            float[] positiveBlockColours = null;
            float[] negativeBlockColours = null;
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                positiveBlockColours = tile.getPositiveBlockInfo().getBlockState().getBeaconColorMultiplier((LevelReader)tile.getPositiveBlockInfo().getWorld(), pos, beaconPos);
            }
            if (tile.getNegativeBlockInfo().getBlockState() != null) {
                negativeBlockColours = tile.getNegativeBlockInfo().getBlockState().getBeaconColorMultiplier((LevelReader)tile.getNegativeBlockInfo().getWorld(), pos, beaconPos);
            }
            if (positiveBlockColours != null) {
                for (float colour : positiveBlockColours) {
                    result.add(Float.valueOf(colour));
                }
            }
            if (negativeBlockColours != null) {
                for (float colour : negativeBlockColours) {
                    result.add(Float.valueOf(colour));
                }
            }
        });
        if (result.size() == 0) {
            return null;
        }
        float[] colours = new float[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            colours[i] = ((Float)result.get(i)).floatValue();
        }
        return colours;
    }

    @Nullable
    public BlockPathTypes getAiPathNodeType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return DynamicSlabBlock.getTile(world, pos).map(tile -> {
            BlockPathTypes positiveBlockNodeType = null;
            BlockPathTypes negativeBlockNodeType = null;
            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                positiveBlockNodeType = tile.getPositiveBlockInfo().getBlockState().m_60734_().getAiPathNodeType(tile.getPositiveBlockInfo().getBlockState(), (BlockGetter)tile.getPositiveBlockInfo().getWorld(), pos, entity);
            }
            if (positiveBlockNodeType != null) {
                return positiveBlockNodeType;
            }
            if (tile.getNegativeBlockInfo().getBlockState() != null) {
                negativeBlockNodeType = tile.getNegativeBlockInfo().getBlockState().m_60734_().getAiPathNodeType(tile.getNegativeBlockInfo().getBlockState(), (BlockGetter)tile.getNegativeBlockInfo().getWorld(), pos, entity);
            }
            return negativeBlockNodeType;
        }).orElse(super.getAiPathNodeType(state, world, pos, entity));
    }

    public void onCaughtFire(BlockState state, Level world, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        DynamicSlabBlock.runIfAvailable((BlockGetter)world, pos, i -> i.getBlockState().onCaughtFire(i.getWorld(), pos, face, igniter));
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return DynamicSlabBlock.both(world, pos, i -> i.getBlockState().canEntityDestroy((BlockGetter)i.getWorld(), pos, entity));
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        DynamicSlabBlock.runIfAvailable((BlockGetter)world, pos, i -> i.getBlockState().onBlockExploded(i.getWorld(), pos, explosion));
        super.onBlockExploded(state, world, pos, explosion);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }
}

