/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.init;

import cjminecraft.doubleslabs.common.capability.config.IPlayerConfig;
import cjminecraft.doubleslabs.common.capability.config.PlayerConfigCapability;
import cjminecraft.doubleslabs.common.network.PacketHandler;
import cjminecraft.doubleslabs.common.network.packet.config.UpdateServerPlayerConfigPacket;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="doubleslabs", value={Dist.CLIENT})
public class DSKeyBindings {
    private static final List<Pair<KeyMapping, Runnable>> KEYBINDINGS = new LinkedList<Pair<KeyMapping, Runnable>>();

    public static void register() {
        for (Pair<KeyMapping, Runnable> keybind : KEYBINDINGS) {
            ClientRegistry.registerKeyBinding((KeyMapping)((KeyMapping)keybind.getKey()));
        }
    }

    private static Pair<KeyMapping, Runnable> makeKeybind(String name, int key, Runnable action) {
        KeyMapping keyBinding = new KeyMapping("doubleslabs.key." + name, key, "doubleslabs.keycategory");
        return Pair.of((Object)keyBinding, (Object)action);
    }

    private static void toggleVerticalSlabPlacement() {
        assert (Minecraft.m_91087_().f_91074_ != null);
        Minecraft.m_91087_().f_91074_.getCapability(PlayerConfigCapability.PLAYER_CONFIG).ifPresent(config -> {
            config.setPlaceVerticalSlabs(!config.placeVerticalSlabs());
            PacketHandler.INSTANCE.sendToServer((Object)new UpdateServerPlayerConfigPacket((IPlayerConfig)config));
        });
    }

    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (Pair<KeyMapping, Runnable> keybind : KEYBINDINGS) {
            if (!((KeyMapping)keybind.getKey()).m_90857_()) continue;
            ((Runnable)keybind.getValue()).run();
        }
    }

    static {
        KEYBINDINGS.add(DSKeyBindings.makeKeybind("toggleVerticalSlabPlacement", 280, DSKeyBindings::toggleVerticalSlabPlacement));
    }
}

