/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.tileentity;

import cjminecraft.doubleslabs.api.BlockInfo;
import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.IStateContainer;
import cjminecraft.doubleslabs.api.IWorldWrapper;
import cjminecraft.doubleslabs.client.model.DynamicSlabBakedModel;
import cjminecraft.doubleslabs.common.init.DSTiles;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class SlabTileEntity
extends BlockEntity
implements IStateContainer {
    protected final BlockInfo negativeBlockInfo = new BlockInfo(this, false);
    protected final BlockInfo positiveBlockInfo = new BlockInfo(this, true);

    public SlabTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)DSTiles.DYNAMIC_SLAB.get(), pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        this.negativeBlockInfo.deserializeNBT(nbt.m_128469_("negativeBlock"));
        this.positiveBlockInfo.deserializeNBT(nbt.m_128469_("positiveBlock"));
        super.m_142466_(nbt);
        this.markDirtyClient();
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("negativeBlock", (Tag)this.negativeBlockInfo.serializeNBT());
        nbt.m_128365_("positiveBlock", (Tag)this.positiveBlockInfo.serializeNBT());
    }

    public CompoundTag m_5995_() {
        return this.serializeNBT();
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.deserializeNBT(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.deserializeNBT(pkt.m_131708_());
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag getTileData() {
        return this.serializeNBT();
    }

    @Override
    public void markDirty() {
        this.markDirtyClient();
    }

    public void markDirtyClient() {
        this.m_6596_();
        this.requestModelDataUpdate();
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
            this.f_58857_.m_5518_().m_142202_(this.f_58858_);
        }
    }

    public void m_142339_(Level world) {
        if (world instanceof IWorldWrapper) {
            return;
        }
        super.m_142339_(world);
        this.negativeBlockInfo.setWorld(world);
        this.positiveBlockInfo.setWorld(world);
    }

    @Override
    public IBlockInfo getPositiveBlockInfo() {
        return this.positiveBlockInfo;
    }

    @Override
    public IBlockInfo getNegativeBlockInfo() {
        return this.negativeBlockInfo;
    }

    public void onLoad() {
        this.negativeBlockInfo.onLoad();
        this.positiveBlockInfo.onLoad();
    }

    public void onChunkUnloaded() {
        this.negativeBlockInfo.onChunkUnloaded();
        this.positiveBlockInfo.onChunkUnloaded();
    }

    public void m_7651_() {
        super.m_7651_();
        this.negativeBlockInfo.remove();
        this.positiveBlockInfo.remove();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        LazyOptional<T> negativeCapability = this.negativeBlockInfo.getCapability(cap);
        return negativeCapability.isPresent() ? negativeCapability : this.positiveBlockInfo.getCapability(cap);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        LazyOptional<T> negativeCapability = this.negativeBlockInfo.getCapability(cap, side);
        return negativeCapability.isPresent() ? negativeCapability : this.positiveBlockInfo.getCapability(cap, side);
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(DynamicSlabBakedModel.NEGATIVE_BLOCK, (Object)this.negativeBlockInfo).withInitial(DynamicSlabBakedModel.POSITIVE_BLOCK, (Object)this.positiveBlockInfo).build();
    }

    public boolean m_7531_(int pA, int pB) {
        return this.negativeBlockInfo.triggerEvent(pA, pB) | this.positiveBlockInfo.triggerEvent(pA, pB);
    }

    public static <E extends SlabTileEntity, A extends BlockEntity, B extends BlockEntity> void tick(Level world, BlockPos blockPos, BlockState blockState, E entity) {
        if (world != null) {
            BlockEntityTicker ticker;
            if (entity.positiveBlockInfo.getBlockEntity() != null && entity.positiveBlockInfo.getBlockState() != null && (ticker = entity.positiveBlockInfo.getBlockState().m_155944_(entity.m_58904_(), entity.positiveBlockInfo.getBlockEntity().m_58903_())) != null) {
                if (entity.positiveBlockInfo.getBlockEntity().m_58904_() == null) {
                    entity.positiveBlockInfo.getBlockEntity().m_142339_(entity.positiveBlockInfo.getWorld());
                }
                ticker.m_155252_(entity.positiveBlockInfo.getWorld(), blockPos, entity.positiveBlockInfo.getBlockState(), entity.positiveBlockInfo.getBlockEntity());
            }
            if (entity.negativeBlockInfo.getBlockEntity() != null && entity.negativeBlockInfo.getBlockState() != null && (ticker = entity.negativeBlockInfo.getBlockState().m_155944_(entity.m_58904_(), entity.negativeBlockInfo.getBlockEntity().m_58903_())) != null) {
                if (entity.negativeBlockInfo.getBlockEntity().m_58904_() == null) {
                    entity.negativeBlockInfo.getBlockEntity().m_142339_(entity.negativeBlockInfo.getWorld());
                }
                ticker.m_155252_(entity.negativeBlockInfo.getWorld(), blockPos, entity.negativeBlockInfo.getBlockState(), entity.negativeBlockInfo.getBlockEntity());
            }
        }
    }
}

